<?php

/**
 * 平台价格管理服务
 * 价格管理服务
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\Pt;
use App\Models\PtPrice;
use App\Models\PjGoods;
use BlueCity\Core\Service\Service;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class PlatformPriceService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
//        $this->modelMain = new PtPrice();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $where = [];
        if ($param['pt_id']) {
            $where[] = ['pri_ptid', '=', $param['pt_id']];
        }
        if ($param['brand_name']) {
            $where[] = ['pri_brand', '=', $param['brand_name']];
        }
        if ($param['version']) {
            $where[] = ['version', 'like', '%' . $param['version'] . '%'];
        }

        $Db = PtPrice::leftJoin('pj_goods', 'pj_pricenew.pri_pgid', '=', 'pj_goods.pg_id')
            ->leftJoin('pt', 'pt.id', '=', 'pj_pricenew.pri_ptid');
        $count = $Db->count();

        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;
            $list = $Db->select('pri_id', 'pri_price', 'pri_peo', 'pri_ptid', 'pri_pgid', 'pj_goods.brand_name', 'pj_goods.pg_series', 'pj_goods.version', 'pt_name', 'pri_name', 'pri_show', 'national_version')
                ->where($where)
                ->offset($offset)
                ->limit($pageSize)
                ->orderBy('pri_id', 'DESC')
                ->get();

        } else {
            $list = $Db->select('pri_id', 'pri_price', 'pri_peo', 'pri_ptid', 'pri_pgid', 'pj_goods.brand_name', 'pj_goods.pg_series', 'pj_goods.version', 'pt_name', 'pri_name', 'pri_show', 'national_version')
                ->where($where)
                ->orderBy('pri_id', 'DESC')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list']->toArray();
        $all_button = BmmcService::wherebutton($token, $priID);
        $addPt = BmmcService::getTopButton('addPtprice', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮
        foreach ($list as $key => $value) {
//            $value = $value->toArray();
            // -----------button 处理开始-----------
            $buttonData = [];
            $buttonData[] = 'editPtprice';
            if ($value['pri_show'] == 1) {
                $buttonData[] = 'stopPtpriceT';
            } elseif ($value['pri_show'] == 2) {
                $buttonData[] = 'stopPtpriceQ';
            }
            $button = BmmcService::getListButton($buttonData,$all_button);
            $list[$key]['button_one'] = $button['button_one']??[];
            $list[$key]['button_two'] = $button['button_two']??[];
            $list[$key]['button_three'] = $button['button_three']??[];

            if ($value['pg_series'] != '') {
                $list[$key]['pg_series'] = $value['pg_series'] . '-' . $value['version'];
            } else {
                $list[$key]['pg_series'] = $value['version'];
            }
            // -----------数据内容描述结束-----------
        }
        $data['list'] = $list;

        return $data;
    }

    /**
     * @param int $id
     *
     * @param int $enable
     * @return mixed
     */
    public function setEnable(int $id, $enable = 1)
    {
        return Ptprice::where('id', $id)
            ->update(['enabled' => $enable]);
    }

    /**
     * 获取平台公用接口展示数据
     *
     * @param int $id
     * @return mixed $data
     */
    public static function getOne(int $id)
    {
        return Ptprice::where('pri_id', $id)
            ->leftJoin('pj_goods', 'pj_pricenew.pri_pgid', '=', 'pj_goods.pg_id')
            ->leftJoin('pt', 'pt.id', '=', 'pj_pricenew.pri_ptid')
            ->select('pri_id', 'pri_price', 'pj_goods.brand_name', 'pj_goods.pg_series', 'pj_goods.version', 'pt_name', 'pri_name')
            ->first()
            ->toArray();
    }

    public static function getPrice() {

    }

    /**|---------------------------------------------------------------------------------
     * @name 根据指定条件（多条件）获取平台售价
     * @param array $params 查询条件
     * @param array $select 查询内容
     * @param array $type 查询类型
     * @param array $limit 展示条数
     * @retrun /multitype:array
     * @author dou 2021/10/14 19:51
     * |---------------------------------------------------------------------------------
     */
    public static function getPtPrice ( $params , $select = [] , $type = 'get' , $limit = '20'){
        $db = new Ptprice();
        $list = CommonService::getMysqlData($db, $params,$select,[],$type,$limit);
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 查询平台信息
     * @param string $key 查询键
     * @param string/array $value 查询值
     * @param array $select 待查询参数
     * @param string $type 查询类型
     * @retrun /multitype:array
     * @author dou 2021/10/14 20:32
     * |---------------------------------------------------------------------------------
     */
    public static function getPtPriceBy ( $key , $value , $select = [] , $type = 'get' ){
        $db = new Ptprice();
        if(is_array($value)){
            $key .= '_searchin';
        }else{
            if($key == 'pri_id'){
                $type = 'first';
            }
        }
        if($type =='first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }


}
