<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Services\BmmcService;
use App\Services\ExceloutService;
use App\Services\FunctionsService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Models\BserviStore;
use App\Models\Bserviss;
use App\Models\Admin;
use App\Models\Disareanew;
use DB;
class BserviStoreController extends BaseController
{
    /**
     * @name  列表页
     * @param bs_state  状态
     * @param are_shi   市
     * @param are_xian  县
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function index (Request $request)
    {
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        //return $admin_groupnew;exit;
        $id = $request->get('session_token')['id'];
        //return $id;exit;
        $page_size = (int)$request->input('page_size',20);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        if (in_array($admin_groupnew, [7,79,86,89])) {
            $Db = BserviStore::leftJoin('admin','admin.id','=','bservi_store.bs_serid');
        } elseif ($admin_groupnew == 2) {
            $Db = BserviStore::leftJoin('admin','admin.id','=','bservi_store.bs_serid')->where('bservi_store.bs_serid',$id);
        } else {
            $Db = BserviStore::leftJoin('admin','admin.id','=','bservi_store.bs_serid');
        }

        if ($request->filled('are_shi')){//市
            $Db = $Db->where('bs_sid',intval($request->input('are_shi')));
        }
        if ($request->filled('are_xian')){//县
            $are_xian = intval($request->input('are_xian'));
            $are_id = Disareanew::where('are_xid',$are_xian)->value('are_id');
            $Db = $Db->whereRaw("FIND_IN_SET(".$are_id.",bs_areid)");
        }
        if ($request->filled('ser_id')){//服务中心名称
            $Db = $Db->where('bs_serid',$request->input('ser_id'));
        }
        if ($admin_groupnew != 2) {
            if ($request->filled('bs_state')){//状态
                $Db = $Db->where('bs_state',$request->input('bs_state'));
            }
        } else {
            if ($request->filled('bs_state') && $request->input('bs_state') == 1){//状态
                $Db = $Db->where('bs_state',$request->input('bs_state'));
            }
        }
        $session = $request->get('session_token');
        if($admin_groupnew!=7){
            $Db = $Db->where('admin.company_id',$session['company_id']);
        }

        $count = $Db->count();
        $list = $Db->select('bservi_store.*','admin.company_name')->offset($offset)->limit($page_size)->get();
        $data['page'] = [
            'count' => $count,
            'allPage' => ceil($count/$page_size),
            'page' => $page,
            'page_size' => $page_size,
        ];
        if ($admin_groupnew == 2) {
            $data['showMenu'] = [
                ['show_name'=>"未处理",'show_num'=>'--'],
            ];
        } else {
            $data['showMenu'] = [
                ['show_name'=>"未处理",'show_num'=>'--'],
                ['show_name'=>"已审核",'show_num'=>'--'],
                ['show_name'=>"已驳回",'show_num'=>'--'],
            ];
        }
        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('insert,bslog_list,export','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮

        //导出 start
        if ($request->input('is_excel') == 1) {

            $exceout = new ExceloutService();
            $sql = 'SELECT b.company_name,a.sheng,a.shi,a.xian,a.address,a.phone,a.busi_time,a.bisi_endtime FROM gone_bind_bserviss as a LEFT JOIN gone_admin as b on a.foreign_key=b.id';
            $avtion = FunctionsService::getFunctionsBy('function_id', $request->input('Pri_id'), ['function_name','function_model']);
            $con_name = $avtion['function_name'];//控制器名称
            $action = $avtion['function_model'];//控制器
            $field_data = $exceout->gainFields($session['id'],$action);
            if (empty($field_data)) {
                return $this->error('您暂时无导出权限', ErrorInc::MYSQL_FAILED);
            }
            return $exceout->createPlan($list,$sql,500,$action,$con_name,$session['id'],$session['admin_acc'],$session['company_id']);
        }
        //导出 end


        $time = DB::table("time_type")->where('t_type',1)->first();
        $data['time'] = $time;
        if (!$list->isEmpty()){
            $brand = DB::table('goods_brand')->pluck('brand_name','id')->toArray();
            $list = $list->toArray();
            foreach ($list as $k =>$v){
                $buttonData = [];
                $eng = Disareanew::whereIn('are_id',explode(',',$v['bs_areid']))->select('are_id','are_sheng','are_shi','are_xian')->get()->toArray();
                $area = [];
                foreach ($eng as $ks=>$vs){
                    $area[] = $vs['are_xian'];
                    $list[$k]['are_sheng'] = $vs['are_sheng'];
                    $list[$k]['are_shi'] = $vs['are_shi'];
                    $list[$k]['are_xian'] = implode("、",$area);
                }
                unset($area);
                $buttonData[] = 'edit,examine,reject';
                $button = BmmcService::getListButton($buttonData,$all_button);
                $list[$k]['button_one'] = $button['button_one']??[];
                $list[$k]['button_two'] = $button['button_two']??[];
                $list[$k]['button_three'] = $button['button_three']??[];
                if ($v['bs_brantype'] == 1){
                    $list[$k]['bs_brantype_mame'] = '代理';
                }elseif ($v['bs_brantype'] == 2){
                    $list[$k]['bs_brantype_mame'] = '经营';
                }
                if (isset($brand[$v['bs_branid']])){
                    $list[$k]['brand_name'] = $brand[$v['bs_branid']];
                }
                if (empty($v['company_name'])) {
                    $list[$k]['company_name'] = "管理员测试";
                }
            }
            $data['list'] = $list;
            return $this->success('获取成功',$data);exit;
        }else{
            $data['list'] = [];
            return $this->success('获取成功',$data);exit;
        }
    }

    /**
     *  @name  添加
     * @param type 1:获取门店信息；2：添加
     * @param ser_id  服务商id
     * @param are_sid 选择的城市id
     * @param areachech 区县id数组
     * @param brand_data  品牌，经营类型数组
     * @param bind_area [xian,address,phone,busi_time,bisi_endtime]
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/30
     */
    public function insert (Request $request)
    {
        $id = $request->get('session_token')['id'];
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        $ser_id = $request->input('ser_id');
        $are_sid = $request->input('are_sid');
        if ($admin_groupnew == 2 || $admin_groupnew == 7) {
            if ($request->input('type') == 1) {
                $admins = Admin::where('id',$id)->first(['id','company_name']);
                if ($admins) {
                    return $this->success('获取成功',$admins);exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                }
            } elseif ($request->input('type') == 2) {
                if ($request->filled(['ser_id','are_sid']) && $request->input('brand_data') != []) {
	                if ($request->input('bind_area')) {
                        $shi = DB::table('region')->where('reg_id', $are_sid)->select('reg_name','reg_blnum')->first();
                        $sheng = DB::table('region')->where('reg_num',$shi['reg_blnum'])->value('reg_name');
                        $bind_area = $request->input('bind_area');
                        foreach ($bind_area as $k => $v) {
                            DB::table('bind_bserviss')->insert([
                                'sheng' => $sheng,
                                'shi'   => $shi['reg_name'],
                                'xian'  => $v['xian'],
                                'address' => $v['address'],
                                'phone'   => $v['phone'],
                                'busi_time' => $v['busi_time'],
                                'bisi_endtime' => $v['bisi_endtime'],
                                'foreign_key'  => $ser_id,
                                'bs_sid'       => $are_sid,
                            ]);
                        }
                    }else{
                        return $this->error('请添加门店地址', ErrorInc::FAILED_PARAM);exit;
                    }
                    //$xianids = $request->input('areachech');
                    $brand_data = $request->input('brand_data');
                    $luna = BserviStore::where('bs_serid',$ser_id)->where('bs_sid',$are_sid)->first();
                    /*$exits = Bserviss::where('bs_serid',$ser_id)->where('bs_sid',$are_sid)->first();
*/
                    if ($luna) {
                        return $this->error('当前城市已添加绑定服务商，无需重复添加', ErrorInc::FAILED_PARAM);exit;
                    }
                    $listArr = [];
                    $vv = 0;
                    foreach ($brand_data as $ks=>$vs){
                        $listArr[$vv]['bs_serid']     = $ser_id;
                        $listArr[$vv]['bs_areid']     = implode(',',$vs['areachech']);
                        $listArr[$vv]['bs_sid']       = $are_sid;
                        $listArr[$vv]['bs_branid']    = $vs['bs_branid'];
                        $listArr[$vv]['bs_brantype']  = $vs['bs_brantype'];
                        $listArr[$vv]['bs_creactime'] = date('Y-m-d H:i:s');
                        $listArr[$vv]['bs_state']     = 1;
                        $vv++;
                    }

                    $res = BserviStore::insert($listArr);
                    if ($res){
                        $this->insertingLog("添加","","添加绑定数据","门店绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                        return $this->success('添加成功');exit;
                    }else{
                        return $this->error('添加失败', ErrorInc::MYSQL_FAILED);exit;
                    }
                } else {
                    return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
                }
            } else {
                return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
            }
        } else {
            return $this->error('你的账号不是服务商，无法进行添加操作', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * name 删除地址
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2021/8/30
     */
    public function bind_del (Request $request)
    {
        if ($request->input('id')) {
            $res = DB::table('bind_bserviss')->where('id', $request->input('id'))->delete();
            if ($res) {
                return $this->success('删除成功');exit;
            }else{
                return $this->error('删除失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }

    }

    /**
     * name 服务商绑定地址获取县
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function get_xian (Request $request)
    {
        if ($request->input('are_sid')) {
            $are_sid = $request->input('are_sid');
            $reg_num = DB::table('region')->where('reg_id', $are_sid)->value('reg_num');
            $list = DB::table('region')->where('reg_blnum', $reg_num)->select('reg_id','reg_name as xian')->get()->toArray();
            if ($list && $list != []) {
                return $this->success('获取成功',$list);exit;
            }else{
                return $this->error('该地区暂无县区', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  编辑
     * @param ser_id
     * @param bs_id
     * @param bs_sid
     * @param areachech
     * @param brand_data
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function edit (Request $request)
    {
        if ($request->filled(['ser_id','bs_id','bs_sid']) && $request->input('brand_data') != []) {
            $ser_id = $request->input('ser_id');
            $are_sid = $request->input('bs_sid');
            $brand_data = $request->input('brand_data');

            $listArr = [];
            $vv = 0;
            foreach ($brand_data as $ks=>$vs){
                $listArr[$vv]['bs_serid']     = $ser_id;
                $listArr[$vv]['bs_areid']     = implode(',',$vs['areachech']);
                $listArr[$vv]['bs_sid']       = $are_sid;
                $listArr[$vv]['bs_branid']    = $vs['bs_branid'];
                $listArr[$vv]['bs_brantype']  = $vs['bs_brantype'];
                $listArr[$vv]['bs_creactime'] = date('Y-m-d H:i:s');
                $listArr[$vv]['bs_state']     = 1;
                $listArr[$vv]['company_id']  = $request->get('session_token')['company_id'];
                $vv++;
            }
            $result = BserviStore::where('bs_serid',$ser_id)->where('bs_sid',$are_sid)->delete();
            $res = BserviStore::insert($listArr);
            if ($request->input('bind_area')) {
                DB::table('bind_bserviss')->where('foreign_key', $ser_id)->where('bs_sid',$are_sid)->delete();
                $shi = DB::table('region')->where('reg_id', $are_sid)->select('reg_name','reg_blnum')->first();
                $sheng = DB::table('region')->where('reg_id',$shi['reg_blnum'])->value('reg_name');
                $bind_area = $request->input('bind_area');
                foreach ($bind_area as $k => $v) {
                    DB::table('bind_bserviss')->insert([
                        'sheng' => $sheng,
                        'shi'   => $shi['reg_name'],
                        'xian'  => $v['xian'],
                        'address' => $v['address'],
                        'phone'   => $v['phone'],
                        'busi_time' => $v['busi_time'],
                        'bisi_endtime' => $v['bisi_endtime'],
                        'foreign_key'  => $ser_id,
                        'bs_sid'      => $are_sid,
                    ]);
                }
            }
            if ($result && $res){
                $this->insertingLog("编辑","","添加绑定数据","门店绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            }else{
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  编辑前获取数据
     * @param serid 服务商ID
     * @param bs_sid 市ID
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/30
     */
    public function befor_edit (Request $request)
    {
        if ($request->filled('serid') && $request->filled('bs_sid')){
            $serid = $request->input('serid');
            $bs_sid = $request->input('bs_sid');
            $bsArr = BserviStore::where('bs_serid',$serid)->where('bs_sid',$bs_sid)->get();

            if (!$bsArr->isEmpty()){
                foreach( $bsArr as $k => $v){
                    $brandid[] = $v['bs_branid'];
                }
                $brands = DB::table('goods_brand')->get()->toArray();
                foreach ($brands as $key=>$value){
                    $brandArr[$key]['id'] = $value['id'];
                    $brandArr[$key]['brand_name'] = $value['brand_name'];
                    $brandArr[$key]['bs_brantype'] = '';
                    $brandArr[$key]['bs_max'] = '';
                    $brandArr[$key]['bs_min'] = '';
                }
                foreach ($brandArr as $k=>$v){
                    foreach ($bsArr as $ks=>$vs){
                        $list[$k]['areachech'] = [];
                        $list[$k]['brand_name'] = $v['brand_name'];
                        $list[$k]['bs_branid'] = $v['id'];
                        if ($vs['bs_branid'] == $v['id']){
                            $list[$k]['bs_brantype'] = $vs['bs_brantype'];
                            $list[$k]['bs_max'] = $vs['bs_max'];
                            $list[$k]['bs_min'] = $vs['bs_min'];
                            $areachech = explode(',',trim($vs['bs_areid'],','));
                            $numbers = [];
                            foreach ($areachech as $item) {
                                $numbers[] = (int) $item;
                            }
                            $list[$k]['areid'] = $vs['bs_areid'];
                            $list[$k]['areachech'] = $numbers;
                            break;
                        }else{
                            $list[$k]['bs_brantype'] = '';
                            $list[$k]['bs_max'] = '';
                            $list[$k]['bs_min'] = '';
                        }
                    }
                }
                $areas = DB::table('disareanew')->where('are_sid',$request->input('bs_sid'))->select('are_id','are_xid','are_xian','are_sid')->get();
                $bs_areid = BserviStore::where('bs_id',$request->input('bs_id'))->first();
                $bind_area = DB::table('bind_bserviss')->where('bs_sid', $bs_sid)->where('foreign_key', $serid)->get()->toArray();
                if ($areas){
                    $Olaf = explode(',',$bs_areid['bs_areid']);
                    foreach ($areas as $k=>$v){
                        if (in_array($v['are_id'],$Olaf)){
                            $areas[$k]['are_type'] = 2;
                        }else{
                            $areas[$k]['are_type'] = 1;
                        }
                    }
                    $data['list'] = $areas;
                    $data['part'] = $Olaf;
                    $data['bind_area'] = $bind_area;
                }else {
                    $data['list'] = [];
                    $data['part'] = [];
                }
                $data['brandlist'] = $list;
                if($data){
                    return $this->success('操作成功',$data);exit;
                }else{
                    return $this->error('无可添加品牌', ErrorInc::MYSQL_FAILED);exit;
                }
            }
        }else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }
    /**
     * @name  审核
     * @param ser_id
     * @param areachech
     * @param bs_sid
     * @param brand_data
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2021/8/30
     */
    public function examine (Request $request)
    {
        if ($request->filled(['ser_id','areachech','bs_sid']) && $request->input('brand_data') != []) {
            $ser_id = intval($request->input('ser_id'));
            $are_sid = intval($request->input('bs_sid'));
            $brand_data = $request->input('brand_data');
            DB::beginTransaction();
            try{
                $listArr = [];
                $storeArr = [];
                $vv = 0;
                Bserviss::where('bs_serid', $ser_id)->where('bs_sid', $are_sid)->delete();
                foreach ($brand_data as $ks=>$vs){
                    $store = BserviStore::where('bs_serid', $ser_id)->where('bs_sid', $are_sid)->where('bs_branid', $vs['bs_branid'])->update([
                        'bs_max' => $vs['bs_max'],
                        'bs_min' => $vs['bs_min'],
                        'bs_areids' => implode(',',$vs['areachech']),
                        'bs_state' => 2
                    ]);
                    $listArr[$ks]['bs_serid'] = $ser_id;
                    $listArr[$ks]['bs_areid'] = implode(',',$vs['areachech']);
                    $listArr[$ks]['bs_branid'] = $vs['bs_branid'];
                    $listArr[$ks]['bs_brantype'] = $vs['bs_brantype'];
                    $listArr[$ks]['bs_max'] = $vs['bs_max'];
                    $listArr[$ks]['bs_min'] = $vs['bs_min'];
                    $listArr[$ks]['bs_sid'] = $are_sid;
                    $listArr[$ks]['bs_creactime'] = date('Y-m-d H:i:s');
                    $listArr[$ks]['bs_creactid'] = $request->get('session_token')['admin_name'];

                    $storeArr[$ks]['bs_serid'] = $ser_id;
                    $storeArr[$ks]['bs_areid'] = implode(',',$vs['areachech']);
                    $storeArr[$ks]['bs_branid'] = $vs['bs_branid'];
                    $storeArr[$ks]['bs_brantype'] = $vs['bs_brantype'];
                    $storeArr[$ks]['bs_max'] = $vs['bs_max'];
                    $storeArr[$ks]['bs_min'] = $vs['bs_min'];
                    $storeArr[$ks]['bs_sid'] = $are_sid;
                    $storeArr[$ks]['bs_creactime'] = date("Y-m-d H:i:s");
                    $storeArr[$ks]['bs_auditor'] = $request->get('session_token')['admin_acc'];
                    $storeArr[$ks]['bs_audit'] = $request->get('session_token')['id'];
                    $vv++;
                }
                if ($vv >= 1) {
                    $bser = Bserviss::insert($listArr);
                    $bslog = DB::table('bservi_log')->insert($storeArr);
                    if ($bser && $bslog) {
                        DB::commit();
                        $this->insertingLog("审核","服务商ID：".$ser_id,"审核","门店绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                        return $this->success('操作成功');exit;
                    } else {
                        DB::rollBack();
                        return $this->error('操作失败2', ErrorInc::MYSQL_FAILED);exit;
                    }
                } else {
                    DB::rollBack();
                    return $this->error('操作失败1', ErrorInc::MYSQL_FAILED);exit;
                }
            } catch(\Exception $e) {
                DB::rollBack();
                return $this->error($e->getMessage(), ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  驳回
     * @param ser_id
     * @param bs_sid
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function reject (Request $request)
    {
        if ($request->filled(['ser_id','bs_sid'])) {
            $bs_serid = $request->input('ser_id');
            $bs_sid = $request->input('bs_sid');
            $res = BserviStore::where('bs_serid',$bs_serid)->where('bs_sid',$bs_sid)->update(['bs_state' => 3]);
            if ($res) {
                $this->insertingLog("驳回",$bs_serid,"驳回","门店绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  重置
     * @param ser_id
     * @param bs_sid
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function reset (Request $request)
    {
        if ($request->filled(['ser_id','bs_sid'])) {
            $bs_serid = $request->input('ser_id');
            $bs_sid = $request->input('bs_sid');
            $res = BserviStore::where('bs_serid',$bs_serid)->where('bs_sid',$bs_sid)->update(['bs_state' => 1,'bs_max' => 0, 'bs_min' => 0]);
            $res2 = Bserviss::where('bs_serid',$bs_serid)->where('bs_sid',$bs_sid)->update(['bs_max' => 0, 'bs_min' => 0]);
            if ($res) {
                $this->insertingLog("重置",$bs_serid,"重置","门店绑定服务商",$request->ip(), $request->get('session_token')['admin_acc']);
                return $this->success('操作成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  审核日志
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/30
     */
    public function bslog_list (Request $request)
    {
        $page_size = (int)$request->input('page_size',20);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $Db = DB::table('bservi_log')->leftJoin('admin','admin.id','=','bservi_log.bs_serid');
        $count = $Db->count();
        $list = $Db->select('bservi_log.*','admin.company_name')->orderBy('bs_creactime','DESC')->offset($offset)->limit($page_size)->get();
        $data['page'] = [
            'count' => $count,
            'allPage' => ceil($count/$page_size),
            'page' => $page,
            'page_size' => $page_size,
        ];
        if (!$list->isEmpty()){
            $brand = DB::table('goods_brand')->pluck('brand_name','id')->toArray();
            $list = $list->toArray();
            foreach ($list as $k =>$v){
                $eng = Disareanew::whereIn('are_id',explode(',',$v['bs_areid']))->select('are_id','are_sheng','are_shi','are_xian')->get()->toArray();
                $area = [];
                foreach ($eng as $ks=>$vs){
                    $area[] = $vs['are_xian'];
                    $list[$k]['are_sheng'] = $vs['are_sheng'];
                    $list[$k]['are_shi'] = $vs['are_shi'];
                    $list[$k]['are_xian'] = implode("、",$area);
                }
                unset($area);
                if ($v['bs_brantype'] == 1){
                    $list[$k]['bs_brantype_mame'] = '代理';
                }elseif ($v['bs_brantype'] == 2){
                    $list[$k]['bs_brantype_mame'] = '经营';
                }
                if (isset($brand[$v['bs_branid']])){
                    $list[$k]['brand_name'] = $brand[$v['bs_branid']];
                }
            }
            $time = DB::table("time_type")->where('t_type',1)->first();
            $data['time'] = $time;
            $data['list'] = $list;
            return $this->success('获取成功',$data);exit;
        }else{
            $data['list'] = [];
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**
     * @name 获取地址
     * @param ser_id 服务商ID
     * @param bs_sid 市ID
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/7
     */
    public function getAdressBySid(Request $request){
        if(!$request->filled('ser_id')||!$request->filled('bs_sid')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }

        $serid = $request->input('ser_id');
        $bs_sid = $request->input('bs_sid');
        $bind_area = DB::table('bind_bserviss')->where('bs_sid', $bs_sid)->where('foreign_key', $serid)->get()->toArray();
        if($bind_area){
            return $this->success('获取成功',$bind_area);
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }

    }



/**
* @name 添加省
* @author du
* @date 2021/9/6
*/
    public function updateShengBySid(){
        $list = DB::table('bind_bserviss')->whereNull('sheng')->pluck('bs_sid');
        dump($list);
        foreach ($list as $v){
            $sheng = DB::table('disareanew')->where('are_shi',$v['bs_sid'])->value('are_sheng');
            if($sheng){
                $res = DB::table('bind_bserviss')->where('sheng','')->where('bs_sid',$v['bs_sid'])->update(['sheng'=>$sheng]);
                echo $res;
            }

        }
    }

}
