<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDownloadsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('downloads', function (Blueprint $table) {
            $table->increments('id');

            $table->string('file_name', 50)->comment('文件名称');
            $table->string('file_type', 50)->comment('内容类型');
            $table->string('file_path', 50)->comment('文件路径地址');
            $table->string('file_ext', 50)->comment('扩展名');
            $table->integer('create_uid')->comment('创建者UID');
            $table->integer('compress_id')->comment('不为0说明有压缩包');
            $table->tinyInteger('downloaded')->comment('是否已下载[0未下载,1已下载]');
            $table->integer('download_count')->comment('下载次数');
            $table->text('comments')->comment('生成条件');
            $table->dateTime('download_time')->comment('最后下载时间');

            $table->index('create_uid');
            $table->index('compress_id');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('downloads');
    }
}
