<?php


namespace App\Services;


use App\Inc\CacheInc;
use App\Models\AnswersBase;
use App\Models\SubjectsBase;
use App\Models\SubjectsTypes;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class FAQService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new SubjectsBase();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 问题检索管理
     * @param array $condition
     * @param array $column
     * @param int $pageNo
     * @param int $perPage
     * @return mixed|void
     */
    public function search($condition, $column = ['*'], $pageNo = 1, $perPage = 20)
    {
        if ($pageNo < 1) {
            $pageNo = 1;
        }
        $offset = ($pageNo - 1) * $perPage;
        $Db = Db::table('databasestitle')->leftjoin('pt', 'id', '=', 'd_pid')->join('databasestype', 'd_dtid', '=', 'dt_id')->orderBy('d_id', 'DESC');
        if ($condition['dt_id']) {
            $Db = $Db->where('d_dtid', $condition['dt_id']);
        }

        //问题
        if ($condition['d_title']) {
            $Db = $Db->where('d_title', 'like', '%' . $condition['d_title'] . '%');
        }

        //平台
        if ($condition['p_id']) {
            $Db = $Db->where('d_pid', $condition['p_id']);
        }

        //状态
        if ($condition['d_status']) {
            $Db = $Db->where('d_status', $condition['d_status']);
        }

        //项目
        if ($condition['d_name']) {
            $Db = $Db->where('d_name', 'like', '%' . $condition['d_name'] . '%');
        }

        //产品
        if ($condition['d_product']) {
            $Db = $Db->where('d_product', 'like', '%' . $condition['d_product'] . '%');
        }

        //关键字
        if ($condition['d_keywords']) {
            $Db = $Db->where('d_keywords', 'like', '%' . $condition['d_keywords'] . '%');
        }

        $count = $Db->count();
        $list = $Db->select()
            ->offset($offset)
            ->limit($perPage)
            ->get();
        $data['list'] = $list;

        $data['page'] = ['page' => $pageNo, 'page_size' => $perPage, 'count' => $count];

        return $data;
    }

    public static function formatSubjectContents($token, $prvID, $data)
    {
        $all_button = BmmcService::wherebutton($token, $prvID);
        $addPt = BmmcService::getTopButton('AppendData', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮

        if ($data['list']->isEmpty()) {
            $data['list'] = [];
        } else {
            $list = $data['list']->toArray();
            foreach ($list as $k => $v) {
                // -----------button 处理开始-----------
                $button = BmmcService::getListButton(['AnswerList,AddData,EditData,DelData,anwsermg'], $all_button);//编辑，删除按钮
                $list[$k]['button_one'] = $button['button_one'] ?? [];
                $list[$k]['button_two'] = $button['button_two'] ?? [];
                $list[$k]['button_three'] = $button['button_three'] ?? [];
                // -----------button 处理结束-----------
            }
            $data['list'] = $list;
        }

        return $data;
    }

    public static function checkSubjectExist($platformID, $projectID, $subject, $id = 0)
    {
        $exist = false;
        if ($id > 0) {

        } else {

        }

        return $exist;
    }

    public static function checkAnswerExist($dc_did, $answer, $id = 0)
    {
        if ($id > 0) {
            $exist = AnswersBase::where('dc_id', '!=', $id)
                ->where('dc_did', $dc_did)
                ->where('dc_content', $answer)
                ->first();
        } else {
            $exist = AnswersBase::where('dc_did', $dc_did)
                ->where('dc_content', $answer)
                ->first();
        }

        return $exist;
    }

    public static function insertGetId($data)
    {
        $subjects = SubjectsBase::create($data);
        if ($subjects) {
            return $subjects->id;
        }
        return false;
    }

    public static function insertAnswer($data)
    {
        return AnswersBase::create($data);
    }

    /**
     * 答案检索管理列表
     * @param $condition
     * @param array $column
     * @param int $pageNo
     * @param int $perPage
     */
    public static function searchAnswer($condition, $column = ['*'], $pageNo = 1, $perPage = 20)
    {
        if ($pageNo < 1) {
            $pageNo = 1;
        }
        $offset = ($pageNo - 1) * $perPage;
        $Query = Db::table('databasescontent')
            ->join('databasestitle','d_id','=','dc_did')
            ->join('databasestype','dc_type','=','dt_id')
            ->leftjoin('pt','dc_pid','=','id')
            ->orderBy('dc_sord','desc');
        //资料库跳转过来传递的id
        if ($condition['d_id']) {
            $Query = $Query->where('dc_did', (int)$condition['d_id']);
        }

        //问题
        if ($condition['d_title']) {
            $Query = $Query->where('d_title', 'like', '%' . $condition['d_title'] . '%');
        }

        //平台id
        if ($condition['p_id']) {
            $Query = $Query->where('dc_pid', (int)$condition['p_id']);
        }

        //所属分类id
        if ($condition['dt_id']) {
            $Query = $Query->where('dc_type', (int)$condition['dt_id']);
        }

        //答案
        if ($condition['dc_content']) {
            $Query = $Query->where('dc_content', 'like', '%' . $condition['dc_content'] . '%');
        }

        //状态
        if ($condition['d_status']) {
            $Query = $Query->where('dc_status', (int)$condition['d_status']);
        }
        $count = $Query->count();
        $list = $Query->select('dc_id', 'dc_content', 'dc_sord', 'dc_status', 'dc_creatime', 'd_name', 'dt_name', 'pt_name', 'd_title')
            ->offset($offset)
            ->limit($perPage)
            ->get();

        $data['list'] = $list;
        $data['page'] = ['page' => $pageNo, 'page_size' => $perPage, 'count' => $count];

        return $data;
    }

    public static function formatAnswerContents($token, $prvID, $data)
    {
        $all_button = BmmcService::wherebutton($token, $prvID);
        $list = $data['list'];
        if ($list->isEmpty()) {
            $data['list'] = [];
        } else {
            $list = $list->toArray();
            foreach ($list as $k => $v) {
                // -----------button 处理开始-----------
                $button = BmmcService::getListButton(['EditAnswer'], $all_button);//编辑，删除按钮
                $list[$k]['button_one'] = $button['button_one'] ?? [];
                $list[$k]['button_two'] = $button['button_two'] ?? [];
                $list[$k]['button_three'] = $button['button_three'] ?? [];
                // -----------button 处理结束-----------
            }
            $data['list'] = $list;
        }
        return $data;
    }

    public static function findAnswerByID($id)
    {
        return AnswersBase::find($id);
    }

    public static function appendAnswer($data)
    {
        return AnswersBase::insertGetId($data);
    }

    public static function updateAnswer($id, $data)
    {
        return AnswersBase::where('dc_id', $id)->update($data);
    }

    public static function deleteAnswer($id)
    {
        return AnswersBase::destroy($id);
    }

    //获取部分或者所有的类型数据
    public static function getTypes($ids = [])
    {
        $result = [];
        $exist = Cache::has('faq_types');
        if ($exist) {
            $types = Cache::get('faq_types');
            if ($ids) {
                foreach ($ids as $id) {
                    $result[$id] = $types[$id];
                }
            } else {
                $result = $types;
            }
        } else {
            $types = SubjectsTypes::where("dt_status", 1)
                ->select("dt_id", "dt_name")
                ->get()
                ->toArray();;
            foreach ($types as $type) {
                $result[$type['dt_id']] = $type;
            }
            Cache::set('faq_types', $result, CacheInc::CACHE_TIME + rand(0, 5));
        }

        return $result;
    }

    public static function getStates()
    {
        return [1 => "启动", 2 => "停用"];
    }

}
