<?php
/**
 * 测试文件（权限服务）
 * 文件简单描述（权限基础操作权限）
 * @author DouBin
 * @Date: 2023-07-07 007
 * @Time: 下午 3:59:11
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Http\Controllers\Dou;

use App\Http\Controllers\Orders\AotuorderController;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;

class MyTestController extends Controller
{
    public function test ( Request $request ){
        $input = $request->all();
        $AotuorderController = new AotuorderController();
        $data = $AotuorderController->Distrib($input['sys_num'], '192.168.1.140');
        return response()->json(['code'=>201, 'msg'=>'授权失败', 'data'=>$data]);
    }

    /**|---------------------------------------------------------------------------------
     * @name 方法入口
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/8/20 10:59
     * |---------------------------------------------------------------------------------
     */
    public function dataApi ( Request $request ){
        $input = $request->all();
        if(empty($input['method'])){
            return $this->error('缺少必要参数1',ErrorInc::FAILED_PARAM);
        }
        $api=['getSerStatistics'];
        if(!in_array($input['method'],$api)){
            return $this->error('接口不参数异常',ErrorInc::INVALID_PARAM,$input);
        }else {
            $api = (string)$input['method'];
            return $this->$api($input);
        }
    }
}
