<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateServiceItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service_items', function (Blueprint $table) {
            $table->increments('id');
            $table->string('item_name', 50)->comment('服务项名称');
            $table->integer('item_type')->comment('服务类型id');
            $table->integer('com_id')->comment('公司单位id');
            $table->integer('system_id')->comment('系统服务项编号');
            $table->tinyInteger('enabled')->comment('是否开启[0未, 1已]');
            $table->integer('create_uid')->comment('创建者UID');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_items');
    }
}
