<?php
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Models\Company;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Services\BmmcService;

//通用方法控制器
class CompanyController extends BaseController
{

    /**
     * @name 列表
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/9/9
     * @Time: 14:49
     */
     public function index(Request $request){
     	$page_size = (int)$request->input('page_size',20);
     	$page = (int)$request->input('page',1);
     	if($page<1){
     		$page = 1;
     	}
     	$session = $request->get('session_token');
     	$smode = new Company();

         if ($session['admin_groupnew'] != 7){//管理员可以看全部
             $smode = $smode->whereRaw("FIND_IN_SET(".$session['company_id'].",com_parent_id)");
//             $smode = $smode->where('com_id', '>',1);
         }
         if($request->filled('com_name')){
             $smode = $smode->where('com_name','like','%'.$request->input('com_name').'%');
         }
         CommonService::startmysql();
     	$paginate = $smode->orderBy('com_id','ASC')->paginate($page_size);
         $data['showmysql'] = CommonService::showmysql();
     	$list = self::dataToArray($paginate->items());
     	$all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
//print_r($all_button);
     	$export = BmmcService::getTopButton('addCom','', $all_button);
     	//print_r($export);
     	$data['button_top'] = $export['button_top']??[];//顶部按钮
     	$data['button_search'] = $export['button_search']??[];//搜索栏按钮

     	if ($list){
     		foreach ($list as $k=>$v){
     			$button = [];
                $button[] = "editCom";
     			$button = BmmcService::getListButton($button,$all_button);

     			$list[$k]['button_one'] = $button['button_one']??[];
     			$list[$k]['button_two'] = $button['button_two']??[];
     			$list[$k]['button_three'] = $button['button_three']??[];
     		}
     		//返回数据
     		$data['list'] = $list;
     		$data['page'] = [
     			'count' => $paginate->total(),
                'page' => $paginate->currentPage(),
                'page_size' => $page_size,
                'allPage' => $paginate->lastPage()
     		];
     		return $this->success('获取成功', $data);
     	}else{
     		return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $data);
     	}
     }

    /**
     * @name 添加
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/9/9
     * @Time: 14:24
     */
     public function addCom(Request $request){
     	$parameter = $request->only('com_name','com_phone','com_start_time','com_end_time', 'com_brand');
     	$checkKey = CommonService::checkKey(['com_name','com_phone','com_start_time','com_end_time','com_brand'],$parameter);
     	if($checkKey['code']!=1){
     		return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);exit;
     	}
     	$com_name = trim($parameter['com_name']);
     	$exists = Company::where('com_name',$com_name)->value('com_id');

     	if($exists){
     		return $this->error('已存在请重新填写', ErrorInc::MYSQL_FAILED, []);
     	}
     	$dataArr['com_phone'] = $parameter['com_phone'];
     	$dataArr['com_admin_id'] = $request->get('session_token')['id'];
     	$dataArr['com_start_time'] = $parameter['com_start_time'];
     	$dataArr['com_end_time'] = $parameter['com_end_time'];
     	$dataArr['com_name'] = $parameter['com_name'];
        $dataArr['com_brand'] = $parameter['com_brand'];
     	$dataArr['com_parent_id'] = $request->get('session_token')['com_parent_id'];

         $res = Company::insert($dataArr);
     	if($res){
     	    CommonService::resetToken($request->get('session_token'));
     		$this->insertingLog('添加公司，','',$com_name,'公司管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('添加成功', []);
     	}else{
     		return $this->error('添加失败', ErrorInc::MYSQL_FAILED, []);
     	}
     }


    /**
     * @name 编辑公司
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/9/9
     * @Time: 14:31
     */
     public function editCom(Request $request){
     	$parameter = $request->only('id','com_name','com_phone','com_start_time','com_end_time','com_brand');
     	$checkKey = CommonService::checkKey(['id','com_name','com_phone','com_start_time','com_end_time','com_brand'],$parameter);
     	if($checkKey['code']!=1){
     		return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);exit;
     	}
     	$id = $request->input('id');
     	$com_name = trim($request->input('com_name'));
     	$exists = Company::where('com_name',$com_name)->where('com_id','!=',$id)->value('com_name');
     	if($exists){
     		return $this->error('已存在请重新填写', ErrorInc::MYSQL_FAILED, []);
     	}
     	$dataArr['com_phone'] = $request->input('com_phone');
     	$dataArr['com_start_time'] = $request->input('com_start_time');
        $dataArr['com_end_time'] = $request->input('com_end_time');
        $dataArr['com_brand'] = $request->input('com_brand');
     	$dataArr['com_name'] = $com_name;
     	$dataArr['com_update_id'] = $request->get('session_token')['id'];
        $dataArr['com_update_time'] = date("Y-m-d H:i:s");
     	$res = Company::where('com_id',$id)->update($dataArr);
     	if($res){
     		$this->insertingLog('编辑公司，','',$exists.'->'.$com_name,'公司管理',$request->ip(),$request->get('session_token')['admin_acc']);
     		return $this->success('编辑成功', []);
     	}else{
     		return $this->error('编辑失败', ErrorInc::MYSQL_FAILED, []);
     	}

     }


}
