<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        Commands\GetJdOrder::class,
        Commands\GetJdSelfOrder::class,
        Commands\GetJdSelfRefund::class,
        Commands\GetJdSelfShhOrder::class,
        Commands\DeductionFee::class,
        Commands\SynJdOrderApi::class,
        Commands\SynCancelAuditList::class,
        Commands\GetJdOrderCancel::class,
        Commands\GetJdPurchaseOrder::class,
        Commands\GetJdPurchaseRefund::class,
        Commands\SynJdPopCancel::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();
        $schedule->command('getOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('decJdOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('SynJdPopCancel')->everyFiveMinutes();//每五分钟一次抓取十二小时内撤销的pop订单
//        $schedule->command('getJdSelfOrder')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('getJdSelfRefund')->everyFiveMinutes();//每五分钟执行一次
        $schedule->command('GetJdSelfShhOrder')->everyFiveMinutes();//每五分钟执行一次
//        $schedule->command('DeductionFee')->everyFiveMinutes();//每三十分钟执行一次  everyThirtyMinutes   按月扣除100服务费
        $schedule->command('SynJdOrderApi')->everyFiveMinutes();// 抓取京东社会化门店订单 //每五分钟执行一次
        $schedule->command('SynCancelAuditList')->everyFiveMinutes();// 抓取京东社会化门店退款单 //每五分钟执行一次
        $schedule->command('GetJdOrderCancel')->everyFifteenMinutes();// 抓取京东社会化门店12小时内撤销单 //每十五分钟执行一次
        $schedule->command('GetJdPurchaseOrder')->everyFiveMinutes();//抓取京东供销平台订单 每五分钟执行一次
        $schedule->command('GetJdPurchaseRefund')->everyFiveMinutes();//抓取京东供销平台退款 每五分钟执行一次
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
