<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
class OrderRevoke extends Model
{
    //指定表名
    protected $table = 'order_revoke';//退单表 模型
    protected $guarded = [];
    public $timestamps = false;


    /**|---------------------------------------------------------------------------------
     * @name 模型及搜索条件
     * @param $ser_id     服务商id
     * @param $date_time  时间
     * @param $brand_name 品牌名称
     * @param $p_id       平台id
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    private function mode ($ser_id,$date_time,$brand_name,$p_id)
    {
        $info = Self::when($ser_id,function($query)use($ser_id){
            $query->where('ser_id',$ser_id);
        })->when($brand_name,function ($query)use($brand_name){
            $query->where('brand_name',$brand_name);
        })->when($date_time,function($query)use($date_time){
            $query->whereBetween('order_time',[$date_time[0]." 00:00:00",$date_time[1]." 23:59:59"]);
        })->when($p_id,function($query)use($p_id){
            $query->where('p_id',$p_id);
        });
        return $info;
    }



    /**|---------------------------------------------------------------------------------
     * @name  已安装订单模型，计算拒单率使用
     * @param $ser_id
     * @param $date_time
     * @param $brand_name
     * @param $p_id
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    private function normal_sql($ser_id,$date_time,$brand_name,$p_id)
    {
        $normal_model = OrderNormal::when($ser_id,function($query)use($ser_id){
            $query->where('ser_id',$ser_id);
        })->when($brand_name,function ($query)use($brand_name){
            $query->where('brand_name',$brand_name);
        })->when($date_time,function($query)use($date_time){
            $query->whereBetween('order_time',[$date_time[0],$date_time[1]]);
        })->when($p_id,function($query)use($p_id){
            $query->where('p_id',$p_id);
        });
        return $normal_model;
    }



    /**|---------------------------------------------------------------------------------
     * @name 退单（单号）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function order_model ($param)
    {
        $ser_id = $param['ser_id']??"";
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $setys = SetmoneyType::where("lt_parent_id",'!=',0)->pluck('sety_name','sety_id')->toArray();
        //$info = $this->mode($ser_id,$date_time,$brand_name,$p_id);

        $count = $this->mode($ser_id,$date_time,$brand_name,$p_id)->count();//总数
        $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->select('id','pt_name','order_num','serial_number','order_time','payment_time','revocation_time','afs_type','brand_name','pg_series','version','goods_num','order_type')->orderBy('order_time','DESC')->offset($offset)->limit($page_size)->get();

        $header = ["平台","平台单号","工单号","下单时间","派单时间","撤销时间","退单原因","品牌","产品线","型号","数量"];
        $data['header'] = $header;
        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                if ($v['order_type'] == 1){
                    $list[$k]['order_type_name'] = "普通";
                }elseif ($v['order_type'] == 10){
                    $list[$k]['order_type_name'] = "夜间";
                }elseif ($v['order_type'] == 15){
                    $list[$k]['order_type_name'] = "40分钟";
                }elseif ($v['order_type'] == 20){
                    $list[$k]['order_type_name'] = "60分钟";
                }elseif ($v['order_type'] == 20){
                    $list[$k]['order_type_name'] = "90分钟";
                }elseif ($v['order_type'] == 30){
                    $list[$k]['order_type_name'] = "120分钟";
                }

                /*if (isset($setys[29])){
                    $list[$k]['reason'] = $setys[29];
                }else{
                    $list[$k]['reason'] = "";
                }*/
                if (isset($setys[$v['afs_type']])){
                    $list[$k]['reason'] = $setys[$v['afs_type']];
                }else{
                    $list[$k]['reason'] = "";
                }
            }
            $data['list'] = $list;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);
        }else{
            return response()->json(['Data'=>$data,'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  退单（地址）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function province_model ($param)
    {
        $ser_id = $param['ser_id']??"";
        $shr_sheng = $param['shr_sheng']??"";
        $shr_shi = $param['shr_shi']??"";
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;

        if ($shr_sheng!=''){
            if($shr_shi=='' && !in_array($shr_sheng,["北京","北京市","天津","天津市","上海","上海市","重庆","重庆市"])){
                $sums = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->sum('goods_num');
                $list_two = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->groupBy('shr_shi')->orderBy('num','DESC')->selectRaw("shr_shi as area,count('id') as num")->get();
                $count = $list_two->count();
                $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->groupBy('shr_shi')->orderBy('num','DESC')->orderBy('shr_shi','ASC')->selectRaw("shr_shi as area,count('id') as num")->offset($offset)->limit($page_size)->get();
            }else{
                $sums = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->sum('goods_num');

                $list_two = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->selectRaw("shr_xian as area,count('id') as num")->groupBy('shr_xian')->orderBy('num','DESC')->orderBy('shr_xian','ASC')->orderBy('num','DESC')->get();

                $count = $list_two->count();
                $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->selectRaw("shr_xian as area,count('id') as num")->groupBy('shr_xian')->orderBy('num','DESC')->orderBy('num','DESC')->offset($offset)->limit($page_size)->get();

            }

        }else{
            $sums = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->sum('goods_num');
            $list_two = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->groupBy('shr_sheng')->orderBy('num','DESC')->selectRaw("shr_sheng as area,count('id') as num")->get();
            $count = $list_two->count();
            $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->groupBy('shr_sheng')->orderBy('num','DESC')->orderBy('num','DESC')->selectRaw("shr_sheng as area,count('id') as num")->offset($offset)->limit($page_size)->get();
        }

        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                $list[$k]['round'] = round($v['num']/$sums*100,2);
                $list[$k]['index'] = $offset+$k+1;
            }
            $list_two = $list_two->toArray();
            foreach ($list_two as $ks=>$vs){
                $list_two[$ks]['round'] = round($vs['num']/$sums*100,2);
            }

            $data['list'] = $list;
            $data['list_two'] = $list_two;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }

    }



    /**|---------------------------------------------------------------------------------
     * @name  退单（服务商）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function ser_model ($param)
    {
        $ser_id = $param['ser_id']??"";
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;

        $serid = Admin::pluck('company_name','id')->toArray();

        //$info = $this->mode($ser_id,$date_time,$brand_name,$p_id);
        $sums = $this->mode($ser_id,$date_time,$brand_name,$p_id)->sum('goods_num');
        $list_two = $this->mode($ser_id,$date_time,$brand_name,$p_id)->groupBy('ser_id')->orderBy('num','DESC')->orderBy('ser_id','ASC')->selectRaw("ser_id,count('id') as num")->get();
        $count = $list_two->count();
        $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->groupBy('ser_id')->orderBy('num','DESC')->orderBy('ser_id','ASC')->selectRaw("ser_id,count('id') as num")->offset($offset)->limit($page_size)->get();
        $normal = $this->normal_sql($ser_id,$date_time,$brand_name,$p_id)->selectRaw("ser_id,count('id') as num")->groupBy('ser_id')->get()->toArray();


        if (!$list->isEmpty()){
            $list = $list->toArray();
            $normal_nums = [];
            foreach ($normal as $ks => $vs){
                $normal_nums[$vs['ser_id']] = $vs['num'];
            }
            foreach ($list as $k=>$v){
                if(isset($serid[$v['ser_id']])){
                    $list[$k]['company_name'] = $serid[$v['ser_id']];
                    $list[$k]['round'] = round($v['num']/$sums*100,2);
                    $list[$k]['index'] = $offset+$k+1;
                    $chart[$k]['company_name'] = $serid[$v['ser_id']];
                    $chart[$k]['num'] = $v['num'];
                }
                if (isset($normal_nums[$v['ser_id']])){
                    $list[$k]['rate'] = round($v['num']/($v['num']+$normal_nums[$v['ser_id']])*100,2);
                } else {
                    $list[$k]['rate'] = round($v['num']/$v['num']*100,2);
                }
            }

            $data['list'] = $list;
            $data['chart'] = $chart;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  退单（平台）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function pt_model ($param)
    {
        $ser_id = $param['ser_id']??"";
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;

        $sums = $this->mode($ser_id,$date_time,$brand_name,$p_id)->sum('goods_num');
        $list_two = $this->mode($ser_id,$date_time,$brand_name,$p_id)->groupBy('p_id')->orderBy('num','DESC')->orderBy('p_id','ASC')->selectRaw("p_id,pt_name,count('id') as num")->get();
        $count = $list_two->count();
        $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->groupBy('p_id')->orderBy('num','DESC')->orderBy('p_id','ASC')->selectRaw("ser_id,p_id,pt_name,count('id') as num")->offset($offset)->limit($page_size)->get();
        $normal = $this->normal_sql($ser_id,$date_time,$brand_name,$p_id)->selectRaw("ser_id,count('id') as num")->groupBy('p_id')->get()->toArray();
        //return $list->toArray();
        if (!$list->isEmpty()){
            $list = $list->toArray();
            $normal_nums = [];
            foreach ($normal as $ks => $vs){
                $normal_nums[$vs['ser_id']] = $vs['num'];
            }
            //return $normal_nums;
            foreach ($list as $k=>$v){
                $list[$k]['round'] = round($v['num']/$sums*100,2);
                $list[$k]['index'] = $offset+$k+1;
                $chart[$k]['pt_name'] = $v['pt_name'];
                $chart[$k]['num'] = $v['num'];

                if (isset($normal_nums[$v['ser_id']])){
                    $list[$k]['rate'] = round($v['num']/($v['num']+$normal_nums[$v['ser_id']])*100,2);
                } else {
                    $list[$k]['rate'] = round($v['num']/$v['num']*100,2);
                }
            }


            $data['list'] = $list;
            $data['chart'] = $chart;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  退单（详情）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function detail_model ($param)
    {
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $ser_id = $param['ser_id']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        //模型搜索


        $count = $this->mode($ser_id,$date_time,$brand_name,$p_id)->count();//总数
        $list = $this->mode($ser_id,$date_time,$brand_name,$p_id)->orderBy('order_time','DESC')->offset($offset)->limit($page_size)->get();
        $serid = Admin::pluck('company_name','id')->toArray();
        $certification = Certification::where('certification_num','!=',null)->pluck('certification_num','ser_id')->toArray();
        $setys = SetmoneyType::where("lt_parent_id",'!=',0)->pluck('sety_name','sety_id')->toArray();
        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k => $v){
                if ($v['order_type'] == 1){
                    $v['order_type_name'] = "普通";
                }elseif ($v['order_type'] == 10){
                    $v['order_type_name'] = "夜间";
                }elseif ($v['order_type'] == 15){
                    $v['order_type_name'] = "40分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "60分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "90分钟";
                }elseif ($v['order_type'] == 30){
                    $v['order_type_name'] = "120分钟";
                }
                if (empty($v['pg_series'])){
                    $list[$k]['goods_information'] = $v['brand_name'].'-'.$v['version'];
                }else{
                    $list[$k]['goods_information'] = $v['brand_name'].'-'.$v['pg_series'].'-'.$v['version'];
                }
                $list[$k]['user_information'] = $v['shr_sheng'].$v['shr_shi'].$v['shr_xian'];

                if (isset($serid[$v['ser_id']])){
                    $list[$k]['company_name'] = $serid[$v['ser_id']];
                }else{
                    $list[$k]['company_name'] = "暂无";
                }
                if(isset($certification[$v['ser_id']])){
                    $list[$k]['certification_num'] = $certification[$v['ser_id']];
                }else{
                    $list[$k]['certification_num'] = "";
                }

                if (isset($setys[$v['afs_type']])){
                    $list[$k]['reason'] = $setys[$v['afs_type']];
                }else{
                    $list[$k]['reason'] = "";
                }

            }
            $data['list'] = $list;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }
}
