<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Aftercust extends Model
{
    //指定表名
    protected $table = 'aftercust';
    // 拒绝添加的字段
    protected $guarded = [];
    public $timestamps = false;
    protected $primaryKey = 'afc_id';


    public function getOrderStatusAttribute()
    {
        $status = $this->getAttribute('afc_orderstatus');
        $statusName = '未知';
        if ($status != '') {
            switch ($status) {
                case 1:
                    $statusName = "新订单";
                    break;
                case 5:
                    $statusName = "处理中";
                    break;
                case 10:
                    $statusName = "可派单";
                    break;
                case 20:
                    $statusName = "已派单";
                    break;
                case 30:
                    $statusName = "安装中";
                    break;
                case 34:
                    $statusName = "待完成";
                    break;
                case 40:
                    $statusName = "已完成";
                    break;
                case 50:
                    $statusName = "已撤销";
                    break;
                case 55:
                    $statusName = "已撤销55";
                    break;
                default:
                    $statusName = "未知状态";
                    break;
            }
        }

        return $statusName;
    }

    public function getAfcStatusAttribute()
    {
        $status = $this->getAttribute('afc_state');
        switch ($status) {
            case 1:
                $statusName = "未处理";
                break;
            case 2:
                $statusName = "需跟进";
                break;
            case 3:
                $statusName = "待审核";
                break;
            case 4:
                $statusName = "已完成";
                break;
            default:
                $statusName = "未知状态";
                break;
        }
        return $statusName;
    }


    public function getTypeNameAttribute()
    {
        switch ($this->getAttribute('afc_state')) {
            //1.安装问题，2.退款问题，3.催单问题，4.预约问题
            case 1:
                $typeName = '安装问题';
                break;
            case 2:
                $typeName = '退款回访';
                break;
            case 3:
                $typeName = '催单回访';
                break;
            case 4:
                $typeName = '预约回访';
                break;
            default:
                $typeName = '未知';
                break;
        }
        return $typeName;
    }


}
