<?php


namespace App\Exports;

class AfterCustExport extends Export
{
    protected $sheetName; //sheet title
    protected $data;
    protected $headings;
    //用户自选导出表头的文件（传值$headings为空的）不要用下面的参数暂时有问题，我再改一个版本出来
    protected $columnWidth = ['A' => 10, 'B' => 20, 'C' => 30, 'D' => 10, 'E' => 20, 'F' => 20, 'G' => 20, 'H' => 20];//设置列宽       key：列  value:宽
    protected $rowHeight = [1 => 25];  //设置行高       key：行  value:高
    protected $mergeCells = []; //合并单元格    value:A1:K8
    protected $font = ['A1:P1' => '微软雅黑'];       //设置字体       key：A1:K8  value:Arial
    protected $fontSize = [];       //设置字体大小       key：A1:K8  value:11
    protected $bold = ['A1:P1' => true];       //设置粗体       key：A1:K8  value:true
    protected $background = []; //设置背景颜色    key：A1:K8  value:F0F0F0F
    protected $vertical = [];   //设置定位       key：A1:K8  value:center
    protected $borders = []; //设置边框颜色  key：A1:K8  value:000000
    // 设置需要从库中检索出的字段
    protected static $columns = [
        'afc_id' =>'【编号】',
        'afc_sys' =>'【系统单号】',
        'afc_order' =>'【平台单号】',
        'afc_serial' =>'【派工单号】',
        'pt_name' =>'【平台名称】',
        'afc_ordertime' =>'【订单创建时间】',
        'afc_goodname' =>'【商品名称】',
        'afc_price' =>'【商品单价】',
        'afc_num' =>'【商品数量】',
        'afc_creacter' =>'【创建人】',
        'afc_creactime' =>'【创建时间】',
        'invoice' =>'【发票类型】',
        'kd_no'=>'【快递单号】',
        'shr_name' =>'【客户姓名】',
        'shr_phone' =>'【客户电话】',
        'shr_adree' =>'【客户地址】',
    ];

    public function __construct($data, $headings = [], $sheetName = '电话沟通数据表格')
    {
        parent::__construct($data, $headings, $sheetName);
    }

    // headings方法,提供文件头部信息内容
    public function defineHeader($columns)
    {
        $headers = [];
        foreach ($columns as $key => $column) {
            if ($this->columns[$column]) {
                $headers[$column] = $this->columns[$column];
            }
        }

        $this->headings = $headers;
    }
    //业务代码
    public function createData()
    {
        $tmp = $this->data;
        $data = [];
        foreach ($tmp as $key=>$value) {
            $row = [];
            foreach ($this->headings as $k=>$val) {
                $row[$k] = $value[$k];
            }
            $data[] = $row;
        }
        $this->data = collect($data)->toArray();
    }

}
