<?php

namespace App\Services;

use App\Models\Pt;
use BlueCity\Core\Service\Service;
use DB;



class BangdingService extends Service
{

    /**
     * 获取列表
     * @param array $input
     * @param array $session
     * @return Ambigous <multitype:, unknown, multitype:unknown NULL >
     * @author du 2021年8月23日下午3:39:38
     */
    public static function getList($input,$session){
    	$where = [];
        $pt_id = (int)$input['pt_id']??77;
        switch ($pt_id) {
            case 44:
                $Db = Db::table('jd_goods')->leftjoin('pj_goods','pg_id','=','tg_gid');
                break;
            case 88:
                $Db = Db::table('tm_goods')->leftjoin('pj_goods','pg_id','=','tg_gid');
                break;
            default:
                $Db = Db::table('th_goods')->leftjoin('pj_goods','pg_id','=','tg_gid');
                break;
        }
        $where['1'] = 1;
        if(isset($input['goods_name'])){
            $where['tg_tname_like'] = $input['goods_name'];
        }

    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
    	$paginate = $Db->whereRaw($where)->select('tg_id','tg_tname','tg_time','tg_name','pg_series','version','brand_name','tg_pid')->orderBy('tg_time','desc')->paginate($page_size);
    	//print_r(DB::getQueryLog());

    	$all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$export = BmmcService::getTopButton('goodsAdd','',$all_button);
    	$data['button_top'] = $export['button_top']??[];//顶部按钮
    	$data['button_search'] = $export['button_search']??[];//搜索栏按钮
    	$list = CommonService::dataToArray($paginate->items());
        $pt = Pt::select('id','pt_name','sord')->whereIn('id',[44,77,88])->orderBy('sord','asc')->get();
        $data['pt'] = $pt;
    	if($list){
    		$list = BangdingService::getButtonDatas($all_button, $list);
    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=>$paginate->currentPage(),
    				'page_size'=>$page_size,
    				'allPage'=>$paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }
    /**
     * 获取按钮和数据
     * @param array $all_button
     * @param array $list
     * @return string
     * @author du 2021年8月23日下午4:40:48
     */
    public static function getButtonDatas($all_button,$list){

    	foreach ($list as $k => $v){
            $buttonData = [];
            if($v['pg_series']!=""){
                $list[$k]['version']=$v['brand_name'].'-'.$v['pg_series']."-".$v['version'];
            }else{
                $list[$k]['version']=$v['brand_name']."-".$v['version'];
            }
    		$buttonData[] = 'goodsEdit';
    		$button = BmmcService::getListButton($buttonData,$all_button);

    		$list[$k]['button_one'] = $button['button_one']??[];
    		$list[$k]['button_two'] = $button['button_two']??[];
    		$list[$k]['button_three'] = $button['button_three']??[];
    	}
    	return $list;
    }


}
