<?php
/**
 * 文件名称（第三方账目管理）
 * 文件简单描述（处理第三方金额汇款）
 * @author DouBin
 * @Date: 2021/9/15
 * @Time: 10:05
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Http\Controllers\Financial;
use App\Http\Controllers\BaseController;
use App\Models\Pictures;
use App\Models\PtThree;
use App\Services\PtThreeService;
use App\Services\SettlementThreeService;
use Illuminate\Http\Request;
use DB;
use App\Services\CommonService;//通用服务
use BlueCity\Core\Inc\ErrorInc;

/**
 * @name 第三方账目管理
 * Class InvoiceTableController
 * @package App\Http\Controllers\Financial
 */
class PtThreeController extends BaseController{
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param int status 结算状态 1:代收; 2:待付; 3:已完结;
     * @param string wat_num   结算单号
     * @param string apply_for_name   经手人
     * @param string pt_name    平台名称
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/15 10:13
     * |---------------------------------------------------------------------------------
    */
    public function index ( Request $request ){
        if($request->filled('status')){
            $data = PtThreeService::getList($request->all(), $request->get("session_token"));
            if($data['ErrorCode']!=1){
                return $data;
            }else {
                $list = $data['Data'];
                if ($list['list']) {
                    return $this->success('获取成功', $list);
                    exit;
                } else {
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $list);
                    exit;
                }
            }

        }else{
            return $this->error('缺少参数status', ErrorInc::INVALID_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看凭证 或 修改凭证
     * @param int type 操作类型；1:查看凭证; 2: 修改凭证
     * @param string wat_num 结算单号
     * @param string image 结算单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/15 17:46
     * |---------------------------------------------------------------------------------
    */
    public function editVoucher(Request $request){
        $input = $request->all();
        $checkKey = CommonService::checkKey(['type', 'wat_num'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM, []);exit;
        }
        if(in_array($input['type'], [1,2])){
            $pic = Pictures::where("sett_wat_num",$input['wat_num'])->value('upload_pictures');
            if($input['type'] == 1){
                if (isset($pic)){
                    $pic = $this->picurl($pic);
                    return $this->success('操作成功',$pic);exit;
                }else{
                    return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
                }
            }else{
                if($request->filled('image')){
                    $info = Pictures::where('sett_wat_num',$input['wat_num'])->first();
                    if (isset($info)){
                        $type = '编辑凭证';
                        $result = Pictures::where('sett_wat_num',$input['wat_num'])->update(['upload_pictures'=>$input['image']]);
                    }else{
                        $type = '添加凭证';
                        $result = Pictures::insert(['upload_pictures'=>$input['image'],'sett_wat_num'=>$input['wat_num']]);
                    }
                    if($result){
//                        DealPicService::deletPic($pic);
                        $this->insertingLog($type,$input['wat_num'],$type.'结算单号：'.$input['wat_num'],"第三方账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
                        return $this->success('操作成功');exit;
                    }else{
                        return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
                    }
                }else{
                    return $this->error('缺少参数image', ErrorInc::INVALID_PARAM, []);exit;
                }
            }
        }else{
            return $this->error('参数错误type', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 确认付款
     * @param string wat_num 结算单号
     * @param string remarks 备注内容
     * @param string image 图片链接
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/15 18:59
     * |---------------------------------------------------------------------------------
    */
    public function confirmPayment(Request $request){
        $input = $request->all();
        $checkKey = CommonService::checkKey(['wat_num', 'remarks','image'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $settlement = PtThree::where('wat_num',$input['wat_num'])->where('type','<',3)->value('settlement_num');
        if(empty($settlement)){
            return $this->error('无结算单对应可操作数据，请刷新', ErrorInc::DATA_EMPTY);exit;
        }
        $iptv['sett_wat_num'] = $input['wat_num'];
        $iptv['upload_pictures'] = $input['image'];
        Pictures::insert($iptv);
        $arr['type'] = 3;
        $arr['apply_pay_time'] = date("Y-m-d H:i:s");//付款时间
        DB::beginTransaction(); //开启事务
        $res = CommonService::accMe($input['wat_num'], '第三方账目管理', $input['remarks'], '', 2, $request->get('session_token')['admin_groupnew'], $request->get('session_token')['admin_acc'], $request->get('session_token')['id']);
        $settlement_num = explode(',',$settlement);
        $re = PtThree::where('wat_num',$input['wat_num'])->update($arr);
        $r = Db::table('settlement_three')->whereIn("id",$settlement_num)->update(['three_status'=>30]);
        if($res && $re && $r){
            DB::commit();
            $this->insertingLog('确认付款',$input['wat_num'],'确认付款,结算单号：'.$input['wat_num'],"第三方账目管理",$request->ip(), $request->get('session_token')['admin_acc']);
            return $this->success('操作成功');
        }else{
            DB::rollback();
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 退回结算
     * @param string wat_num 结算单号
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/15 19:21
     * |---------------------------------------------------------------------------------
    */
    public function returnSettle(Request $request){
        if($request->filled('wat_num')){
            $wat_num = $request->input('wat_num');
            $settlement=PtThree::where('wat_num',$wat_num)->where('type','<',3)->value('settlement_num');
            if(!$settlement){
                return $this->error('无结算单对应可操作数据，请刷新', ErrorInc::DATA_EMPTY);exit;
            }
            $settle_arr=explode(',',$settlement);
            DB::beginTransaction(); //开启事务
            $sre=Db::table('settlement_three')->whereIn('id',$settle_arr)->update(['three_status'=>10,'wat_num'=>'']);
            Db::table('note')->where('orders_id',$wat_num)->delete();
            $rea = PtThree::where('wat_num',$wat_num)->delete();
            if($sre){
                DB::commit();
                $this->insertingLog('退回结算，','','结算单号：'.$wat_num,'第三方账目管理',$request->ip(),$request->get('session_token')['admin_acc']);
                return $this->success('操作成功');
            }else{
                DB::rollback();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
            }
        }else{
            return $this->error('缺少参数wat_num', ErrorInc::INVALID_PARAM);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 查看详情
     * @param string wat_num 结算单号
     * @param string sys_num 系统单号
     * @param string order_num 平台单号
     * @param int p_id 平台id
     * @param string shr_name 姓名
     * @param string shr_phone 电话
     * @param array creactDate 创建时间
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/9/15 19:36
     * |---------------------------------------------------------------------------------
     */
    public function lookDetail (Request $request){
        if(!$request->filled('wat_num')){
            return $this->error('缺少参数wat_num', ErrorInc::INVALID_PARAM);exit;
        }
        $input = $request->all();
        $session = $request->get('session_token');
        $input['three_status'] = 0;
        $input['source_type'] = 1;
        $data = settlementThreeService::getList($input, $session);
        if($data['ErrorCode']!=1){
            return $data;
        }else {
            $list = $data['Data'];
            if ($list['list']) {
                return $this->success('获取成功', $list);
                exit;
            } else {
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY, $list);
                exit;
            }
        }
    }
}
