<?php


namespace App\Services;

use BlueCity\Core\Service\Service;
use App\Models\Downloads;
use App\Models\DownloadsRecords;

class DownloadService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new Downloads();
    }

    public static function downloaded($file, $data = []) {
        $fileID = $file->id;
        $data['file_id'] = $fileID;

        DownloadsRecords::create($data);
        $downloadInfo = ['downloaded'=>1, 'download_count'=>$file->download_count + 1,'download_time'=>time()];
        $file->update($downloadInfo);

        Downloads::where('compress_id', $file->id)->update($downloadInfo);

        return true;
    }
}
