<?php
namespace App\Http\Middleware;
use Closure;
use DB;
class RequestAppMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
      $contr = request()->route()->getActionName();
      $action = explode('@',$contr)[1];//方法
        if(!$request->filled('appVersion') || !$request->filled('phoneType') || !$request->filled('UUID') || !$request->filled('ser_type')){
            return response()->json(['data'=>$request->all(),'state'=>3,'desecption'=>'参数错误']);exit;
        }else{
            $appVersion = self::versionDetection($request->input('appVersion'));
            if($appVersion['state']!=1){
                return response()->json($appVersion);exit;
            }
        }
        if ($action != 'Json_login' && $action != 'Json_verification_code' && $action != 'Json_editpass'  && $action != 'install_EditInfo'){



        	if(!$request->filled('admin_id')||!$request->filled('UUID')||!$request->filled('ser_type')){

        		return response()->json(['data'=>'','state'=>3,'desecption'=>'参数错误']);exit;
        	}


        	$input = $request->only('ser_type','admin_id','UUID');

			if($input['ser_type']=='1'){
				// 1:服务商 2：技师

				$admin_infor = DB::table("admin_infor");

				$uuids = $admin_infor->where('admin_id',$input['admin_id'])->value('UUID');

				if($uuids!=$input['UUID']){

					return response()->json(['data'=>'','state'=>12,'desecption'=>'设备号错误']);exit;

				}else{

					  return $next($request);
				}

			}else{

				$install_person = DB::table('install_person');

				$uuids = $install_person->where('id',$input['admin_id'])->value('UUID');

				if($uuids!=$input['UUID']){

					return response()->json(['data'=>null,'state'=>12,'desecption'=>'设备号错误']);exit;

				}else{
					return $next($request);
				}
			}
		}else{
            return $next($request);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string appVersion 订单单号
     * @retrun /multitype:array
     * @author dou 2022/5/16 16:58
     * |---------------------------------------------------------------------------------
    */
    public function versionDetection ( $appVersion ){
        $version = explode('.', $appVersion);
        if(count($version)!=3){
            return ['data' => $appVersion, 'desecption' => '版本号异常', 'state' => 11];
        }else{
            $appVersion = $version[0].'.'.$version[1];
            $runApp = ['V1.6','V1.7'];
            if(in_array($appVersion, $runApp)){
                return ['data' => $appVersion, 'desecption' => 'success', 'state' => 1];
            }else{
                return ['data' => $appVersion, 'desecption' => 'success', 'state' => 11];
            }
        }
    }
}
