<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\OrderService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;
class SearchDressController extends BaseController
{
    /**
     * @name 地址查询
     * @param conditions 搜索地址
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/2
     */
    public function index (Request $request)
    {
        if(!$request->filled('conditions')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $search = $request->input('conditions');
		$shr_sheng = DB::table('dress')->leftjoin('order_list','dress.data_id','=','order_list.id') ->where('shr_sheng','like','%'.$search.'%')->where('data_type','1')->orderBy('dress.feeds_time','DESC')->select('dr_id','shr_sheng','shr_shi','shr_xian','shr_adress','dress.feeds_time','dress.goods_name','data_type','order_num')->get()->toArray();
		$dressArr = array();
		$dr_id = array();
		if(isset($shr_sheng)){
			$data1 = $this->mult_unique ($shr_sheng,$dressArr,$dr_id);
			$dressArr = $data1[0];
			$dr_id = $data1[1];
		}
		unset($shr_sheng);
		$shr_shi = DB::table('dress')->leftjoin('order_list','dress.data_id','=','order_list.id') ->where('shr_shi','like','%'.$search.'%')->where('data_type','1')->orderBy('dress.feeds_time','DESC')->select('dr_id','shr_sheng','shr_shi','shr_xian','shr_adress','dress.feeds_time','dress.goods_name','data_type','order_num')->get()->toArray();
		if(isset($shr_shi)){
			$data1 = $this->mult_unique ($shr_shi,$dressArr,$dr_id);
			$dressArr = $data1[0];
			$dr_id = $data1[1];
		}
		unset($shr_shi);
		$shr_xian = DB::table('dress')->leftjoin('order_list','dress.data_id','=','order_list.id') ->where('shr_xian','like','%'.$search.'%')->where('data_type','1')->orderBy('dress.feeds_time','DESC')->select('dr_id','shr_sheng','shr_shi','shr_xian','shr_adress','dress.feeds_time','dress.goods_name','data_type','order_num')->get()->toArray();
		if(isset($shr_xian)){
			$data1 = $this->mult_unique ($shr_xian,$dressArr,$dr_id);
			$dressArr = $data1[0];
			$dr_id = $data1[1];
		}
		unset($shr_xian);
		$shr_adress = DB::table('dress')->leftjoin('order_list','dress.data_id','=','order_list.id')  ->where('shr_adress','like','%'.$search.'%')->where('data_type','1')->orderBy('dress.feeds_time','DESC')->select('dr_id','shr_sheng','shr_shi','shr_xian','shr_adress','dress.feeds_time','dress.goods_name','data_type','order_num')->get()->toArray();
		if(isset($shr_adress)){
			$data1 = $this->mult_unique ($shr_adress,$dressArr,$dr_id);
			$dressArr = $data1[0];
			$dr_id = $data1[1];
		}
        if ($dressArr && $dressArr != []) {
            foreach ($dressArr as $k => $v) {
	            $dressArr[$k]['shr_adress'] = $v['shr_adress']." 单号：(".$v['order_num'].")";
                $dressArr[$k]['detail'] = $v['shr_sheng']." ".$v['shr_shi']." ".$v['shr_xian']." ".$v['shr_adress']." ".$v['goods_name'];
            }
            return $this->success('获取成功',$dressArr);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }
    //筛选数据
    public function mult_unique ($dressArr,$array,$dr_id)
    {
    	foreach( $dressArr as $k => $v ){
			if(!in_array($v['dr_id'], $dr_id)){
		     $array[] = $v;
		     $dr_id[] = $v['dr_id'];
		    }
		}
		$data[0] = $array;
		$data[1] = $dr_id;
		return $data;
    }

}
