<?php
/**
 * 同步门店信息
 * 同步门店接口惭怍
 * @author DouBin
 * @Date: 2021/08/31
 * @Time: 11:31
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class SysStoresService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 同步通知门店
     * @param array $pop 请求参数
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author dou 2021/8/31 11:32
     * |---------------------------------------------------------------------------------
     */
    public static function sysStore ( $pop , $type , $store ){
        $url = SysStoresService::returnUrl($type , $store);
        if(!$url){
            return ['ErrorCode' => ErrorInc::FAILED_PARAM, 'ErrorMessage' => '链接类型错误'];
        }else {
            $data = '';
            $time = date("Y-m-d H:i:s");
            $pop['time'] = $time;
            $pop['token'] = md5(md5($time . '4a392d38f53a162699bda15b6f97e4f9'));
            $pop = CommonService::ToUrlencode($pop);
            $pop=urldecode(json_encode($pop));
            $resp = CommonService::requestPost($url, $pop);
            $data .= $pop."--".$url.'--'.$resp;
            CommonService::addLog($type, $data, '','sysStore');
            $resps = json_decode($resp, true);
            if (isset($resps['code'])) {
                if ($resps['code'] != 200) {
                    return ['ErrorCode' => ErrorInc::TRANSFER_FAILED, 'ErrorMessage' => $resps['msg'] . ",code:" . $resps['code']];
                }
            } else {
                return ['ErrorCode' => ErrorInc::TRANSFER_FAILED, 'ErrorMessage' => $resp];
            }
            return ['ErrorCode' => 1];
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 请求链接
     * @param string $type 请求类型
     * @retrun /multitype:string
     * @author dou 2021/8/31 11:35
     * |---------------------------------------------------------------------------------
     */
    public static function returnUrl ( $type , $store ){
        if($_SERVER["HTTP_HOST"]=='zpsaas.bluearp.com') {
            $url = self::getUrl('product');
        }else{
            $url = self::getUrl('test');
        }
        $url = $url[$store]??false;
        if(!$url){
            return false;
        }
        switch ( $type ){
            case 'orderUrl':
                return $url['orderUrl'];//订单推送
                break;
            case 'recycleOrder':
                return $url['recycleOrder'];//同步拒单回收
                break;
            case 'opinionOrder':
                return $url['opinionOrder'];//驳回/审核订单
                break;
            case 'editSd':
                return $url['editSd'];//改单
                break;
            case 'sdReminder':
                return $url['sdReminder'];//催单
                break;
            case 'lockUrl':
                return $url['lockUrl'];//订单锁定/解除锁定
                break;
            case 'importBillOrders':
                return $url['importBillOrders'];//同步账单
                break;
            case 'opinionAfterOrder':
                return $url['opinionAfterOrder'];//审核售后
                break;
            case 'reject':
                return $url['reject'];//管理员驳回到商家确认
                break;
            case 'importAfterOrders':
                return $url['importAfterOrders'];//同步售后
                break;
            case 'searchShop':
                return $url.'v1/zptzSystemShop/searchShop';//查询门店
                break;
            case 'correlation':
                return $url.'v1/zptzSystemShop/correlation';//绑定门店信息
                break;
            default:
                return false;
                break;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取链接
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2022-11-30 030 上午 11:46:21
     * |---------------------------------------------------------------------------------
     */
    public static function getUrl ( $type ){
        $url = [
            'product'=>[
                '2'=>[
                    'skuGblue' => 'http://sa.bluearp.com/index.php/api/v1/ReplenishmentGoods/getReplenishmentGood',

                    'skuMkblue' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemGoods/getSystemGoods',

                    'staGblue'  =>'http://sa.bluearp.com/index.php/api/v1/ReplenishmentBills/getReplenishmentBill',

                    'staMkblue' => 'http://sa.bluearp.com/index.php/api/g1/DispatchingBills/getDeliveryBills',
                    //订单推送
                    'orderUrl' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/importOrders',

                    //订单锁定/解除锁定
                    'lockUrl' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/sdOrderLock',
                    //改单
                    'editSd' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/sdOrderEdit',
                    //驳回/审核订单
                    'opinionOrder' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/opinionOrder',
                    //催单
                    'sdReminder' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/sdReminder',
                    //同步售后
                    'importAfterOrders' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/importAfterOrders',
                    //同步拒单回收
                    'recycleOrder' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/recycleOrder',
                    //同步账单
                    'importBillOrders' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/importBillOrders',
                    //审核售后
                    'opinionAfterOrder' => 'http://sa.bluearp.com/index.php/api/v3/OtherSystemOrders/opinionAfterOrder',
                    //管理员驳回到商家确认
                    'reject'=>'http://sa.bluearp.com/index.php/api/v2/BillContrast/reject',
                ]
            ],
            'test'=>[
                '2'=>[
                    'skuGblue' => 'http://mktwo.bluearp.com/index.php/api/v1/ReplenishmentGoods/getReplenishmentGood',

                    'skuMkblue' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemGoods/getSystemGoods',

                    'staGblue'  =>'http://mktwo.bluearp.com/index.php/api/v1/ReplenishmentBills/getReplenishmentBill',

                    'staMkblue' => 'http://mktwo.bluearp.com/index.php/api/g1/DispatchingBills/getDeliveryBills',
                    //订单推送
                    'orderUrl' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/importOrders',

                    //订单锁定/解除锁定
                    'lockUrl' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/sdOrderLock',
                    //改单
                    'editSd' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/sdOrderEdit',
                    //驳回/审核订单
                    'opinionOrder' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/opinionOrder',
                    //催单
                    'sdReminder' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/sdReminder',
                    //同步售后
                    'importAfterOrders' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/importAfterOrders',
                    //同步拒单回收
                    'recycleOrder' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/recycleOrder',
                    //同步账单
                    'importBillOrders' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/importBillOrders',
                    //审核售后
                    'opinionAfterOrder' => 'http://mktwo.bluearp.com/index.php/api/v3/OtherSystemOrders/opinionAfterOrder',
                    //管理员驳回到商家确认
                    'reject'=>'http://mktwo.bluearp.com/index.php/api/v2/BillContrast/reject',
                ]

            ]
        ];
        return $url[$type];
    }
}
