<?php
/**
 * 测试文件（权限服务）
 * 文件简单描述（权限基础操作权限）
 * @author DouBin
 * @Date: 2023-07-07 007
 * @Time: 下午 3:59:11
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Http\Controllers\Dou;

use App\Http\Controllers\Orders\AotuorderController;
use App\Models\Admin;
use App\Models\OrderList;
use App\Models\OrderRejected;
use App\Services\CommonService;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;
use DB;

class MyTestController extends Controller
{
    public function test ( Request $request ){
        $input = $request->all();
        $AotuorderController = new AotuorderController();
        $data = $AotuorderController->Distrib($input['sys_num'], '192.168.1.140');
        return response()->json(['code'=>201, 'msg'=>'授权失败', 'data'=>$data]);
    }

    /**|---------------------------------------------------------------------------------
     * @name 方法入口
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/8/20 10:59
     * |---------------------------------------------------------------------------------
     */
    public function dataApi ( Request $request ){
        $input = $request->all();
        if(empty($input['method'])){
            return $this->error('缺少必要参数1',ErrorInc::FAILED_PARAM);
        }
        $api=['getSerStatistics','getSerStatisticsDetail'];
        if(!in_array($input['method'],$api)){
            return $this->error('接口不参数异常',ErrorInc::INVALID_PARAM,$input);
        }else {
            $api = (string)$input['method'];
            return $this->$api($input);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取京东token
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/9/29 8:56
     * |---------------------------------------------------------------------------------
    */
    public function getSerStatistics ( $input ){
        if(empty($input['company_id'])){
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>请输入公司id</h1></html>";
            echo $html;exit;
        }
        $admindata = Admin::where('company_id',$input['company_id'])
            ->where('admin_groupnew',2)
            ->where('enable',1)
            ->select('id','company_name')->get();
        $admindata = CommonService::dataToArray($admindata);
        if($admindata){
            $time_start = $input['time_start'];
            $time_end = date("Y-m-d", strtotime($input['time_end'] . " +1 day"));
            $html = "<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><table>";
            $html .= "<tr>";
            $html .= "<td rowspan='2'>序号</td><td rowspan='2'>服务商（公司名称）</td><td colspan='6'>本周".date("m-d", strtotime($input['time_start']))."-".date("m-d", strtotime($input['time_end']))."</td><td colspan='6'>累计至今</td>";
            $html .= "</tr>";
            $html .= "<tr>";
            $html .= "<td>总推送单量</td><td>接单量</td><td>拒单量</td><td>拒单率</td><td>接单时效</td><td>履约时效</td><td>总推送单量</td><td>接单量</td><td>拒单量</td><td>拒单率</td><td>接单时效</td><td>履约时效</td>";
            $html .= "</tr>";
            foreach($admindata as $k => $v){
                $order_listnum = OrderList::whereRaw("ser_id='".$v['id']."' and create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1 and get_time != '' and company_id = '".$input['company_id']."'")->count();//接单数量
                $order_rejectednum = OrderRejected::whereRaw("or_ser_id='".$v['id']."' and or_creact_time BETWEEN '".$time_start."' and '".$time_end."' and or_show=1")->count();//拒单数量
                $order_listAllnum = OrderList::whereRaw("ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and is_delete=1 and get_time != '' and company_id = '".$input['company_id']."'")->count();//总接单数量
                $order_rejectedAllnum = OrderRejected::whereRaw("or_ser_id='".$v['id']."' and or_creact_time BETWEEN '2024-08-19' and '".$time_end."' and or_show=1")->count();//总拒单数量
                $sql = "SELECT CAST((SUM(UNIX_TIMESTAMP(feeds_time))-SUM(UNIX_TIMESTAMP(get_time)))/COUNT(id) as SIGNED) as timenum FROM gone_order_list WHERE ser_id='".$v['id']."' and get_time != '' and get_time!='0000-00-00 00:00:00' and feeds_time != '' and feeds_time!='0000-00-00 00:00:00' and create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1  and company_id = '".$input['company_id']."'";
                $data = DB::select($sql);
                $sql1 = "SELECT CAST((SUM(UNIX_TIMESTAMP(get_time))-SUM(UNIX_TIMESTAMP(create_time)))/COUNT(id) as SIGNED) as pdnum FROM gone_order_list WHERE ser_id='".$v['id']."' and get_time != '' and get_time!='0000-00-00 00:00:00' and create_time BETWEEN '".$time_start."' and '".$time_end."' and time(create_time)>='08:30:00' and time(create_time)<='18:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";
                $data1 = DB::select($sql1);
                $sqls = "SELECT CAST((SUM(UNIX_TIMESTAMP(feeds_time))-SUM(UNIX_TIMESTAMP(get_time)))/COUNT(id) as SIGNED) as timenum FROM gone_order_list WHERE ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and get_time != '' and get_time!='0000-00-00 00:00:00' and feeds_time != '' and feeds_time!='0000-00-00 00:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";// and is_delete=1
                $datas = DB::select($sqls);
                $sqls1 = "SELECT CAST((SUM(UNIX_TIMESTAMP(get_time))-SUM(UNIX_TIMESTAMP(create_time)))/COUNT(id) as SIGNED) as pdnum FROM gone_order_list WHERE ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and get_time != '' and get_time!='0000-00-00 00:00:00' and time(create_time)>='08:30:00' and time(create_time)<='18:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";// and is_delete=1
                $datas1 = DB::select($sqls1);
                $html .= "<tr>";
                $html .= "<td>".$v['id']."</td>";
                $html .= "<td>".$v['company_name']."</td>";
                $html .= "<td>".($order_listnum+$order_rejectednum)."</td>";
                $html .= "<td>".$order_listnum."</td>";
                $html .= "<td>".$order_rejectednum."</td>";
                if(($order_listnum+$order_rejectednum) == 0){
                    $html .= "<td>0.00%</td>";
                }else {
                    $gl = sprintf("%.2f", $order_rejectednum / ($order_listnum + $order_rejectednum) * 100);
                    $html .= "<td>" . $gl . "%</td>";
                }
                if($data){
                    $html .= "<td>".self::Compute_Time($data1[0]['pdnum'])."</td>";
                    $html .= "<td>".self::Compute_Time($data[0]['timenum'])."</td>";
                }else{
                    $html .= "<td>0时0分0秒</td>";
                    $html .= "<td>0时0分0秒</td>";
                }
                $html .= "<td>".($order_listAllnum+$order_rejectedAllnum)."</td>";
                $html .= "<td>".$order_listAllnum."</td>";
                $html .= "<td>".$order_rejectedAllnum."</td>";
                if(($order_listAllnum+$order_rejectedAllnum) == 0){
                    $html .= "<td>0.00%</td>";
                }else {
                    $gls = sprintf("%.2f", $order_rejectedAllnum / ($order_listAllnum + $order_rejectedAllnum) * 100);
                    $html .= "<td>" . $gls . "%</td>";
                }
                if($data){
                    $html .= "<td>".self::Compute_Time($datas1[0]['pdnum'])."</td>";
                    $html .= "<td>".self::Compute_Time($datas[0]['timenum'])."</td>";
                }else{
                    $html .= "<td>0时0分0秒</td>";
                    $html .= "<td>0时0分0秒</td>";
                }
                $html .= "</tr>";

            }
            $html .= "<table></html>";
            echo $html;
        }else{
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>无相应公司信息</h1></html>";
            echo $html;exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取订单门店施工明细
     * @param string company_id 公司id
     * @param string time_start 开始时间
     * @param string time_end 结算是啊金
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/9/11 17:27
     * |---------------------------------------------------------------------------------
     */
    public function getSerStatisticsDetail ( $input ){
        if(empty($input['company_id'])){
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>请输入公司id</h1></html>";
            echo $html;exit;
        }
        $admindata = Admin::where('company_id',$input['company_id'])
            ->where('admin_groupnew',2)
            ->where('enable',1)
            ->pluck('company_name','id');
        $time_start = $input['time_start'];
        $time_end = date("Y-m-d", strtotime($input['time_end'] . " +1 day"));
        $sql = "SELECT (UNIX_TIMESTAMP(feeds_time)-UNIX_TIMESTAMP(get_time)) AS sgtime,(UNIX_TIMESTAMP(get_time)-UNIX_TIMESTAMP(create_time)) AS jdtime,stauas,order_num,ser_id,create_time,get_time,feeds_time FROM gone_order_list WHERE create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1 and company_id = ".$input['company_id']." order by create_time";
        $datas = DB::select($sql);
        $statusName = ['10'=>'未接单','20'=>'未接单','30'=>'安装中','34'=>'待审核','40'=>'已完成','50'=>'已撤销','55'=>'已撤销（补邮费）'];
        $html = "<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><table>";
        $html .= "<tr>";
        $html .= "<td>门店名称</td><td>单号</td><td>订单状态</td><td>创建时间</td><td>接单时间</td><td>反馈时间</td><td>接单时效</td><td>5分钟接单达标</td><td>10钟接单达标</td><td>履约时效</td><td>12小时履约达标</td><td>24小时履约达标</td>";
        $html .= "</tr>";
        foreach($datas as $k => $v){
            $html .= "<tr>";
            $html .= "<td>".$admindata[$v['ser_id']]."</td>";
            $html .= "<td>".$v['order_num']."</td>";
            $html .= "<td>".$statusName[$v['stauas']]."</td>";
            $html .= "<td>".$v['create_time']."</td>";
            $html .= "<td>".$v['get_time']."</td>";
            $html .= "<td>".$v['feeds_time']."</td>";
            if($v['get_time'] != '' && $v['get_time'] != '0000-00-00 00:00:00'){
                $html .= "<td>".self::Compute_Time($v['jdtime'])."</td>";
                if($v['jdtime']<300){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
                if($v['jdtime']<600){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
            }else{
                $html .= "<td></td>";
                $html .= "<td>不达标</td>";
                $html .= "<td>不达标</td>";
            }

            if($v['feeds_time'] != '' && $v['feeds_time'] != '0000-00-00 00:00:00'){
                $html .= "<td>".self::Compute_Time($v['sgtime'])."</td>";
                if($v['sgtime']<43200){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
                if($v['sgtime']<86400){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
            }else{
                $html .= "<td></td>";
                $html .= "<td>不达标</td>";
                $html .= "<td>不达标</td>";
            }
            $html .= "</tr>";
        }
        $html .= "<table></html>";
        echo $html;
    }
    /**|---------------------------------------------------------------------------------
     * @name 转化为时分秒
     * @param string timediff 时间
     * @retrun  /multitype:string
     * @author dou 2024/8/23 11:43
     * |---------------------------------------------------------------------------------
     */
    private function Compute_Time( $timediff ){
        $days = intval($timediff/86400);
        //计算小时数
        $remain = $timediff%86400;
        $hours = intval($remain/3600);
        //计算分钟数
        $remain = $remain%3600;
        $mins = intval($remain/60);
        //计算秒数
        $secs = $remain%60;
        //$res = array("day" => $days,"hour" => $hours,"min" => $mins,"sec" => $secs);
        $res = $days.'天'.$hours.'时'.$mins.'分'.$secs.'秒';
        return $res;
    }
}
