<?php

namespace App\Http\Controllers\Api\MobileWeb;

use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\LoginValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\LoginService;
use Illuminate\Support\Facades\Crypt;

class LoginController extends Controller
{
    public function __construct()
    {
        $this->dataValidator = new LoginValidator();
    }

    // 登录
    public function login(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->loginValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[]]);
        }

        $return_data = LoginService::login($request->all());
        return $return_data;
    }

    //退出
    public function quit(Request $request)
    {
        return LoginService::quit($request->all());
    }

    //修改密码
    public function updatePassword(Request $request){
        // 验证数据
        $error_message = $this->dataValidator->updatePasswordValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[]]);
        }

        $return_data = LoginService::updatePassword($request->all(),$request->ip());
        return $return_data;
    }

    //修改密码
    public function getOpenid(Request $request){
        // 验证数据
        $error_message = $this->dataValidator->getOpenidValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[]]);
        }
        $return_data = LoginService::getOpenid($request->all(),$request->ip());

        return $return_data;
    }
}
