<?php
/**
 * 文件名称（统计车膜评分）
 * 文件简单描述（用于月初结算车模类门店评分）
 * @author DouBin
 * @Date: 2021/11/12
 * @Time: 9:56
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\Api;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Models\Admin;
use App\Models\OrderList;
use App\Models\ServicePointsmonth;
use App\Models\SetmoneyType;
use App\Models\SettlementCount;
use App\Services\CommonService;
use Illuminate\Http\Request;
use DB;
use BlueCity\Core\Inc\ErrorInc;


class CountScoreController extends BaseController{
    /**|---------------------------------------------------------------------------------
     * @name 每月一号统计车膜门店评分
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/12 10:11
     * |---------------------------------------------------------------------------------
    */
    public function service_pointsmonth ( Request $request ){
        dump(time());
        $to_time=time();
        $time=$to_time-(24*60*60*20);
        $year=date('Y',$time);
        $month=(int)date('m',$time);
        $y_m=date('Y-m',$time);
        $res = ServicePointsmonth::where('ss_year',$year)->where('ss_month',$month)->select('ss_serid')->get();
        $res = CommonService::dataToArray($res);
        if($res){
            $id=array_column($res,'ss_serid');
            $admin_data = Admin::whereRaw("admin_groupnew in (2) and FIND_IN_SET('3',ad_project) and id not in (".implode(',', $id).")")->select('id','admin_acc')->get();
        }else{
            $admin_data = Admin::whereRaw("admin_groupnew in (2) and FIND_IN_SET('3',ad_project)")->select('id','admin_acc')->get();
        }
        if(empty($admin_data)){
            return false;
        }
        $admin_data = CommonService::dataToArray($admin_data);
        $js_label = SetmoneyType::where('lt_parent_id',458)->select('sety_id')->get();
        $js_label = CommonService::dataToArray($js_label);
        $fw_label = SetmoneyType::where('lt_parent_id',459)->select('sety_id')->get();
        $fw_label = CommonService::dataToArray($fw_label);

        $js_label=array_column($js_label,'sety_id');
        $fw_label=array_column($fw_label,'sety_id');

        $labe_where=array_merge($js_label,$fw_label);

        $sys_data = OrderList::where('feeds_time','like',$y_m.'%')->where("category",3)->select('sys_num')->get();
        $sys_data = CommonService::dataToArray($sys_data);
        $sys_data=array_column($sys_data,'sys_num');

        $settlem_sys = SettlementCount::where('cou_synum',$sys_data)->where('cou_status',1)->where('cou_type',$labe_where)->select('cou_synum')->get();
        $settlem_sys = CommonService::dataToArray($settlem_sys);

        $settlem_sys=array_unique(array_column($settlem_sys,'cou_synum'));

        $add_data=[];
        $step_num=0;
        dump(time());
        foreach ($admin_data as $key => $val) {
            $ser_count = OrderList::where('feeds_time','like',$y_m.'%')->where("category",3)->where('ser_id',$val['id'])->count();

            if($ser_count){
                $fwlabel_gtzero = (float)SettlementCount::where('cou_serid',$val['id'])->whereIn('cou_synum',$settlem_sys)->where('cou_status',1)->where('cou_price','>','0')->whereIn('cou_type',$fw_label)->sum('cou_price');
                $fwlabel_ltzero = (float)SettlementCount::where('cou_serid',$val['id'])->whereIn('cou_synum',$settlem_sys)->where('cou_status',1)->where('cou_price','<','0')->whereIn('cou_type',$fw_label)->sum('cou_price');

                $jslabel_gtzero = (float)SettlementCount::where('cou_serid',$val['id'])->whereIn('cou_synum',$settlem_sys)->where('cou_status',1)->where('cou_price','>','0')->whereIn('cou_type',$js_label)->sum('cou_price');
                $jslabel_ltzero = (float)SettlementCount::where('cou_serid',$val['id'])->whereIn('cou_synum',$settlem_sys)->where('cou_status',1)->where('cou_price','<','0')->whereIn('cou_type',$js_label)->sum('cou_price');

                $ser_countnum=100*$ser_count+$jslabel_gtzero+$fwlabel_gtzero; # 总分分母
                $ser_countnums=100*$ser_count+$fwlabel_gtzero+$jslabel_gtzero+$fwlabel_ltzero+$jslabel_ltzero; # 总分分子
                $ser_jsnum=100*$ser_count+$jslabel_gtzero; # 技术总分分母
                $ser_jsnums=100*$ser_count+$jslabel_gtzero+$jslabel_ltzero; # 技术总分分子
                $ser_fwnum=100*$ser_count+$fwlabel_gtzero; # 服务总分分母
                $ser_fwnums=100*$ser_count+$fwlabel_gtzero+$fwlabel_ltzero; # 服务总分分子

                $zf_num=round($ser_countnums/$ser_countnum*100,2);
                $js_num=round($ser_jsnums/$ser_jsnum*100,2);
                $fw_num=round($ser_fwnums/$ser_fwnum*100,2);
                $add_data[]=[
                    'ss_serid'=>$val['id'],
                    'ss_adminacc'=>$val['admin_acc'],
                    'ss_servicepoints'=>$fw_num,
                    'ss_technicalpoints'=>$js_num,
                    'ss_totalpoints'=>$zf_num,
                    'ss_year'=>$year,
                    'ss_month'=>$month,
                    'ss_yearmonth'=>$y_m,
                    'ss_ordernum'=>$ser_count,
                    'ss_jsrewardnum'=>$jslabel_gtzero,
                    'ss_jspenalizenum'=>$jslabel_ltzero,
                    'ss_fwrewardnum'=>$fwlabel_gtzero,
                    'ss_fwpenalizenum'=>$fwlabel_ltzero
                ];
            }else{
                $add_data[]=[
                    'ss_serid'=>$val['id'],
                    'ss_adminacc'=>$val['admin_acc'],
                    'ss_servicepoints'=>100,
                    'ss_technicalpoints'=>100,
                    'ss_totalpoints'=>100,
                    'ss_year'=>$year,
                    'ss_month'=>$month,
                    'ss_yearmonth'=>$y_m,
                    'ss_ordernum'=>0,
                    'ss_jsrewardnum'=>0,
                    'ss_jspenalizenum'=>0,
                    'ss_fwrewardnum'=>0,
                    'ss_fwpenalizenum'=>0
                ];
            }
            $step_num++;
            if($step_num >= 300){
                ServicePointsmonth::insert($add_data);
                $add_data=[];
                $step_num=0;
            }
        }
        dump(time());
        if(!empty($add_data)){
            ServicePointsmonth::insert($add_data);
        }
        if($res){
            $id=array_column($res,'ss_serid');
            $admin_data = Admin::whereIn('admin_groupnew',[2])->whereIn('id',$id)->where('ad_project',3)->select('id','admin_acc')->get();
        }
        dump(time());
        if(!empty($admin_data)) {
            $admin_data = CommonService::dataToArray($admin_data);
//            $ids = array_column($admin_data, 'id');
//            $sql = "select count(id) as num,ser_id from `gone_order_list` where `feeds_time` like '".$y_m."%' and category = 3 and `ser_id` in (".implode(',', $ids).") group by ser_id";
//            echo $sql;
//            $ser_count = DB::select($sql);
//            if($ser_count){
//                $ser_count = CommonService::dataToArray($ser_count);
//                dump($ser_count);
//            }else{
//                $ser_count = [];
//            }
//            dump(time());
            foreach ($admin_data as $key => $value) {
                $ser_count = (int)OrderList::where('feeds_time','like',$y_m.'%')->where('ser_id',$value['id'])->where("category",3)->count();
                ServicePointsmonth::where('ss_serid',$value['id'])->where('ss_yearmonth',$y_m)->update(['ss_ordernum' => $ser_count]);
            }
            dump(time());
        }
    }
}
