<?php

/**
 * 文件名称（处理图片）
 * 文件简单描述（对图片文件进行相应处理）
 * @author DouBin
 * @Date: 2021/9/10
 * @Time: 18:15
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use BlueCity\Core\Service\Service;
use OSS\OssClient;
use OSS\Core\OssException;

class DealPicService extends Service{

    public static function upload($request) {
        $session = $request['session'];

        //在源生的php代码中是使用$_FILE来查看上传文件的属性
        //但是在laravel里面有更好的封装好的方法，就是下面这个
        $file_object = $request->file('file');
        if (empty($file_object)) {
            return response()->json(['code'=>500, 'msg'=>'上传文件过大！请重新上传文件', 'data'=>'']);
        }
        if ($file_object->isValid()) { //括号里面的是必须加
            //如果括号里面的不加上的话，下面的方法也无法调用的

            //获取文件的扩展名
            $ext = $file_object->getClientOriginalExtension();
            //获取文件的绝对路径
            $path = $file_object->getRealPath();
            // 获取php.ini允许上传的最大大小
            // $max_file_size = $file_object->getMaxFilesize();

            // 获取客户端上传文件类型 视频：video/mp4  图片：image/jpeg
            $client_file_type = $file_object->getClientMimeType();
            // 判断上传文件类型
            if (strpos($client_file_type, 'image/') !== false) {
                // 上传的是图片
                $path_type_name = 'image';//文件夹名
            } elseif (strpos($client_file_type, 'video/') !== false) {
                // 上传的是视频
                $path_type_name = 'video';//文件夹名
            } else {
                return ['code'=>500, 'msg'=>'不支持的上传类型', 'data'=>''];
            }

            //定义文件名
            $file_name = time() . rand(11, 99) .rand(111, 999).'.'.$ext;
            $original_file_name = 'original2'.$file_name;

            // $company_id = $session['company_id'];
            $dir=rtrim($request['path'],'/');
            $dirs = explode('/', $dir);
            $adddir = '';
            foreach($dirs as $k => $v){
                if($adddir==''){
                    $adddir = $v;
                }else{
                    $adddir = $adddir.'/'.$v;
                }
                if($adddir!='.'){
                    if(!is_dir($adddir)){
                        mkdir(iconv("UTF-8", "GBK", $adddir),0777,true);
                    }
                }
            }
            //$dir='./Feekimages/'.date('Ym');
            $streamFileType = $ext??'jpeg';
            $streamFilename=self::creact_url($dir,$streamFileType);
            $path_name = $dir.'/';
            $file_name = $streamFilename['streamFileRand'];
            $original_file_name = 'original2'.$streamFilename['streamFileRand'];
            // $folder = $company_id.date('/Y/m/d/');
            $path_name = $path_name.$path_type_name.'/'; //定义上传文件路径

            //获取上传文件大小，字节 kb
            $files_size = $file_object->getClientSize();
            $size = $files_size / 1024 / 1024;//换算为mb

            $size = sprintf( "%.2f", $size);//保留两位小数

            // 如果上传视频，限制上传视频文件大小
            if ($path_type_name == 'video' && $size > 20) {
                return ['code'=>500, 'msg'=>'上传视频文件过大！', 'data'=>''];
            }

            // // 判断文件夹是否存在，不存在创建文件夹
            // if (!file_exists($path_name)) {
            //     mkdir($path_name, 0775, true);
            //     chmod($path_name, 0775);
            // }
            // laravel框架的上传文件方法，文件夹路径，文件名
            $move_return = $file_object->move($path_name, $file_name);
            // 复制原图
            // $copy = copy($path_name.$file_name, $path_name.$original_file_name);
            $copy = self::copyImage($path_name.$file_name, $path_name.$original_file_name);

            // 上传图片，图片大小超过1M，进行压缩图片
            if ($size > 1 && $path_type_name == 'image') {
                if ($size < 2) {
                    $percent = 0.6;//压缩比例
                } else if ($size < 4) {
                    $percent = 0.4;//压缩比例
                } else if ($size < 20) {
                    $percent = 0.3;//压缩比例
                } else {
                    // 上传十几M的图片在压缩的时候，压缩不了
                    return response()->json(['code'=>500, 'msg'=>'上传图片文件过大！', 'data'=>'{}']);
                }
                // 压缩图片
                $new_stream_file_name = $path_name.'2'.$file_name; //上传到服务器图片路径
                $stream_file_name = $path_name.$file_name;
                try {
                    self::imageCompress($stream_file_name, $percent, $new_stream_file_name);
                } catch (\Exception $e) {
                    return ['code'=>500, 'msg'=>'上传失败', 'data'=>'{}'];
                }
                // 删除原来的图片
                self::deleteImage([$stream_file_name]);
                $file_name = '2'.$file_name;
            }
            $return['file_name'] = $file_name;
            $return['path_name'] = $path_name;
            require_once("./aliyunoss/autoload.php");
            $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
            $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
            $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            // $filename =$_POST['order_id'].uniqid().$type.'.jpeg';
            $bucket= "sdkb";//oss中的文件上传空间
            $object = 'JdhData/FeekUploads'.trim($path_name,'.').$file_name;//想要保存文件的名称
            $res=$ossClient->uploadFile($bucket,$object,$path_name.$file_name);
            if($res['info']['url']!=''){
                $url=ltrim($path_name.$file_name,"/");
                unlink($url);
                $streamFilename['streamFilename'] = "http://img.sudianwang.com/".$object;
            } else {
                $url=ltrim($path_name.$file_name,"./");
                $streamFilename['streamFilename'] = "http://jdh.bluearp.com/".$url;
            }
            return $streamFilename['streamFilename'];
        } else {
            return ['code'=>500, 'msg'=>'未找到上传文件', 'data'=>''];
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 添加图片
     * @param string $imge 图片文件base64
     * @param string $path 文件路径
     * @retrun /multitype:array
     * @author dou 2021/9/10 18:18
     * |---------------------------------------------------------------------------------
    */
    public static function addPic ( $imge , $path , $type=1 ){
        if (preg_match('/(?<=\/)[^\/]+(?=\;)/',$imge,$pregR)) $streamFileType ='.' .$pregR[0];//读取扩展名，如果你的程序仅限于画板上来的，那一定是png，这句可以直接streamFileType 赋值png
        preg_match('/(?<=base64,)[\S|\s]+/',$imge,$streamForW);
        $dir=rtrim($path,'/');
        $dirs = explode('/', $dir);
        $adddir = '';
        foreach($dirs as $k => $v){
            if($adddir==''){
                $adddir = $v;
            }else{
                $adddir = $adddir.'/'.$v;
            }
            if($adddir!='.'){
                if(!is_dir($adddir)){
                    mkdir(iconv("UTF-8", "GBK", $adddir),0777,true);
                }
            }
        }
        //$dir='./Feekimages/'.date('Ym');
        $streamFileType = $streamFileType??'jpg';
        $streamFilename=self::creact_url($dir,$streamFileType);
        if (file_put_contents($streamFilename['streamFilename'],base64_decode($streamForW[0]))){
            try{
                require_once("./aliyunoss/autoload.php");
                $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
                $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
                $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
                $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
                $filename =$_POST['order_id'].uniqid().$type.'.jpeg';
                $bucket= "sdkb";//oss中的文件上传空间
                $object = 'JdhData/FeekUploads'.trim($dir,'.').'/'.$filename;//想要保存文件的名称
                $res=$ossClient->uploadFile($bucket,$object,$streamFilename['streamFilename']);
                if($res['info']['url']!=''){
                    $url=ltrim($streamFilename['streamFilename'],"/");
                    unlink($url);
                    $streamFilename['streamFilename'] = "http://img.sudianwang.com/".$object;
                }
                return $streamFilename['streamFilename'];
            }catch (OssException $e) {
                return $streamFilename['streamFilename'];
            }
        }else{
            return false;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 上传oss
     * @param string $file 本体图片文件路径
     * @param string $dir oss定义路径
     * @retrun /multitype:string
     * @author dou 2021/9/10 19:03
     * |---------------------------------------------------------------------------------
    */
    public static function addOss ( $file , $dir , $type = 1 ){
        require_once("./aliyunoss/autoload.php");
        $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
        $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
        $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
        $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
        try{
            $filename = uniqid().$type.'.jpeg';
            $bucket= "sdkb";//oss中的文件上传空间
            $object =  'JdhData/'.$dir.'/'.$filename;//想要保存文件的名称
            $res = $ossClient->uploadFile($bucket,$object,$file);
            if($res['info']['url']!=''){
                $url=ltrim($file,"/");
                unlink($url);
                $file= "http://img.sudianwang.com/".$object;
            }else{
                return $res;
            }
        }catch (OssException $e) {
            return $e->getMessage();
        }
        return $file;
    }

    /**|---------------------------------------------------------------------------------
     * @name 生成图片本地文件路径
     * @param string $upPath 文件待存储位置
     * @param string $streamFileType 文件后缀名
     * @retrun /multitype:array
     * @author dou 2021/9/10 18:56
     * |---------------------------------------------------------------------------------
    */
    public static function creact_url($upPath,$streamFileType){
        $streamFileRand = date('YmdHis').rand(1000,9999);    //产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        //$upPath='./Feekimages/'.date('Ym');
        $streamFilename = $upPath."/".$streamFileRand.'.' .$streamFileType;

        if(file_exists($streamFilename)){
            self::creact_url($upPath,$streamFileType);
        }else{
            $data['streamFileRand']=$streamFileRand.'.' .$streamFileType;
            $data['streamFilename']=$streamFilename;
            return $data;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 删除图片
     * @param string $upPath 文件待存储位置
     * @retrun /multitype:array
     * @author dou 2021/9/10 19:25
     * |---------------------------------------------------------------------------------
    */
    public static function deletPic ( $upPath ){
        if(strstr($upPath,'http://img.sudianwang.com')){
            require_once("./aliyunoss/autoload.php");
            $accessKeyId = "LTAI4GAhRHWDjheUxeUQCE42";//去阿里云后台获取秘钥
            $accessKeySecret = "3SYbAgutMNDIHk5c7ELEn3aBig5fUV";//去阿里云后台获取秘钥
            $endpoint = "http://oss-cn-beijing.aliyuncs.com";//你的阿里云OSS地址
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            try{
                $filename = uniqid().'.jpeg';
                $bucket= "sdkb";//oss中的文件上传空间
                $object = "SDKB".explode('SDKB', $upPath)[1];
                $res=$ossClient->uploadFile($bucket,$object);
            }catch (OssException $e) {

            }
        }else{
            $url=ltrim($upPath,"/");
            unlink($url);
        }
        return true;
    }

     // 等比例复制图片
    public static function copyImage($src, $newname)
    {
        ini_set("memory_limit","-1");
        $filename=str_replace("images","image",$newname);
        $size = getimagesize($src);
        if (!$size){
            return false;
        }
        list($src_w, $src_h, $src_type) = $size;


        $src_mime = $size['mime'];
        switch ($src_type) {
            case 1 :
                $img_type = 'gif';
                break;
            case 2 :
                $img_type = 'jpeg';
                break;
            case 3 :
                $img_type = 'png';
                break;
            case 15 :
                $img_type = 'wbmp';
                break;
            default :
                return false;
        }

        //等比例缩放
        if (!isset($width)){
            $width = $src_w;
        }
        if (!isset($height)){
            $height = $src_h;
        }
        //根据上传的文件的类型来调用不同函数
        $imagecreatefunc = 'imagecreatefrom' . $img_type;
        $src_img = $imagecreatefunc($src);
        //新建一个真彩色图像
        $dest_img = imagecreatetruecolor($width, $height);
        //重采样拷贝部分图像并调整大小
        /**
         imagecopyresampled() 将一幅图像中的一块正方形区域拷贝到另一个图像中，平滑地插入像素值，
         因此，尤其是，减小了图像的大小而仍然保持了极大的清晰度。
         如果源和目标的宽度和高度不同，则会进行相应的图像收缩和拉伸。坐标指的是左上角。
         本函数可用来在同一幅图内部拷贝（如果 dst_image 和 src_image 相同的话）区域，但如果区域交迭的话则结果不可预知。
        */
        imagecopyresampled($dest_img, $src_img, 0, 0, 0, 0, $width, $height, $src_w, $src_h);

        $imagefunc = 'image' . $img_type;
        if ($filename) {
            $imagefunc($dest_img, $filename);
        } else {
            header('Content-Type: ' . $src_mime);
            $imagefunc($dest_img);
        }
        //销毁文件资源
        imagedestroy($src_img);
        imagedestroy($dest_img);
        return true;
    }


    /**
     * @name 修改图片大小 按照指定大小压缩
     * @param $filename：文件名
     * @param$tmpname：文件路径，如上传中的临时目录
     * @param $percent 为缩小比例
     * @param $img
     * @param $size
     * @param $tmpname
     * @param $xmax
     * @param $ymax
     * @param $type 是否删除原图片1删除2不删除
     * @author du
     * @date 2023/1/2
     * @Time: 9:07
     */
    function resizeImage($img,$size,$tmpname,$type = 1){
        //获取图片大小
        $s = @filesize($img); //echo $s; exit;
        $img_size = ceil($s/ 1000) . "k"; //获取文件大小

        if($img_size>$size){
            $percent = 0.7;
            list($width, $height) = getimagesize($img);

            $ii = getimagesize($img);
            $iimagen = explode('/', end($ii))[1];

            $new_width = $width * $percent;
            $new_height = $height * $percent;
            $image_p = @imagecreatetruecolor($new_width, $new_height);
            // $image = imagecreatefromjpeg($img);
            $image = getImgN($img,$iimagen);
            //print_r($image);
            @imagecopyresampled($image_p, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
            $new_img = $tmpname.uniqid().'.'.$iimagen;
            @imagejpeg($image_p,$new_img); //输出保存图片
            if(file_exists($new_img)){
                if($type == 1) {
                    unlink($img);
                }
                return resizeImage($new_img,$size,$tmpname);
            }else{
                \App\Services\CommonService::addLog('新图片不存在', $new_img, '1111111111111','新图片不存在');
            }
        }else{
            return $img;
        }
    }

    //获取图片后缀名
    function getImgN($filename,$iimagen){
        switch($iimagen){
            case "png":
                $img_r = imagecreatefrompng($filename);
                break;
            case "jpg":
                $img_r = imagecreatefromjpeg($filename);
                break;
            case "jpeg":
                $img_r = imagecreatefromjpeg($filename);
                break;
            case "gif":
                $img_r = imagecreatefromgif($filename);
                break;
        }
        return $img_r;
    }


    /**
     * [imageCompress 压缩图片]
     * @param  [type] $src                  [原来图片路径]
     * @param  [type] $percent              [压缩比例]
     * @param  [type] $new_stream_file_name [压缩图片路径]
     * @return [type]                       [description]
     */
    public static function imageCompress($src, $percent, $new_stream_file_name)
    {
        // 打开图片
        list($width, $height, $type, $attr) = getimagesize($src);
        $imageinfo = [
            'width'=>$width,
            'height'=>$height,
            'type'=>image_type_to_extension($type, false),
            'attr'=>$attr,
        ];
        $fun = 'imagecreatefrom'.$imageinfo['type'];
        $image = $fun($src);

        // 操作图片
        $new_width = $imageinfo['width'] * $percent;
        $new_height = $imageinfo['height'] * $percent;
        $image_thump = imagecreatetruecolor($new_width, $new_height);
        // 将原图复制带图片载体上面，并且按照一定比例压缩,极大的保持了清晰度
        imagecopyresampled($image_thump, $image,0,0,0,0, $new_width, $new_height, $imageinfo['width'], $imageinfo['height']);
        imagedestroy($image);
        $image = $image_thump;

        // 保存图片
        $dst_img_name = $new_stream_file_name;
        $allow_imgs = ['.jpg', '.jpeg', '.png', '.bmp', '.wbmp', '.gif'];//如果目标图片名有后缀就用目标图片扩展名 后缀，如果没有，则用源图的扩展名
        $dst_ext = strrchr($dst_img_name, '.');
        $sourse_ext = strrchr($src, '.');
        if (!empty($dst_ext)) {
            $dst_ext =strtolower($dst_ext);
        }
        if(!empty($sourse_ext)) {
            $sourse_ext = strtolower($sourse_ext);
        }
        // 有指定目标名扩展名
        if (!empty($dst_ext) && in_array($dst_ext, $allow_imgs)) {
            $dst_name = $dst_img_name;
        }elseif (!empty($sourse_ext) && in_array($sourse_ext, $allow_imgs)) {
            $dst_name = $dst_img_name.$sourse_ext;
        }else{
            $dst_name = $dst_img_name.$imageinfo['type'];
        }
        $funcs = 'image'.$imageinfo['type'];
        $funcs($image, $dst_name);
    }

        /**
     * [deleteImage 删除图片]
     * @param  [type] $image_path [图片路径，数组]
     * @return [type]             [description]
     */
    public static function deleteImage($image_path)
    {
        if (empty($image_path)) {
            return true;
        }
        try {
            foreach ($image_path as $key => $value) {
                unlink($value);//删除图片
            }
        } catch (Exception $e) {

        }
        return true;
    }
}
