<?php

/**
 * 平台售价管理服务
 *
 * @author lixiaolin
 * @Date: 2021/07/29
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\SalesPrice;
use App\Models\PriceLog;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class SalePriceService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new SalesPrice();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search_s($param, $columns = array('*'), $page = 1, $pageSize = 20,$session)
    {
        $Db = $this->modelMain;

        if ($param['type']) {
            $Db = $Db->where('type', $param['type']);
        }
        if ($param['pt_id']) {
            $Db = $Db->where('pt_id', $param['pt_id']);
        }
        if ($param['goods_id']) {
            $Db = $Db->where('pg_id', $param['goods_id']);
        } else {
            if ($param['brand_name']) {
                $Db = $Db->where('brand_name', $param['brand_name']);
            }
            if ($param['pg_series']) {
                $Db = $Db->where('pg_series', $param['pg_series']);
            }
        }
        if ($param['state']) {
            switch ($param['state']) {
                case 1:

                    break;
                case 2:
                    $Db = $Db->where('start_time', '<=', date('Y-m-d'));
                    $Db = $Db->where('end_time', '>=', date('Y-m-d'));
                    break;
                case 3:
                    $Db = $Db->where('start_time', '>', date('Y-m-d'));
                    break;
                case 4:
                    $Db = $Db->where('end_time', '<', date('Y-m-d'));
                    break;
                default:
                    $Db = $Db->where('start_time', '<=', date('Y-m-d'));
                    $Db = $Db->where('end_time', '>=', date('Y-m-d'));
                    break;
            }
        }
        if ($param['order_time']) {
            $Db = $Db->where('start_time', '<=', $param['order_time']);
            $Db = $Db->where('end_time', '>=', $param['order_time']);
        }

        $offset = ($page - 1) * $pageSize;
        if ($param['order_num']) {
            $order = OrderService::getOrderByOrderNumber($param['order_num']);
            $goods_id = OrderService::getOrderMsgBySysNumber($order['sys_num'])->goods_id;
            $Db = $Db->where('pg_id', $goods_id)
                ->where('start_time', '<=', $order['order_time'])
                ->where('end_time', '>=', $order['order_time']);
        }

        if ($session['admin_groupnew'] != 7){//管理员可以看全部
            $Db = $Db->where("company_id",$session['company_id']);
        }

        $count = $Db->count();
        $totalPage = ceil($count / $pageSize);
        $list = $Db->offset($offset)
            ->limit($pageSize)
            ->get()
            ->toArray();
        $showcount = [
            ['showname' => "全部", 'shownum' => '--', 'status' => 1],
            ['showname' => "进行中", 'shownum' => '--', 'status' => 2],
            ['showname' => "未开始", 'shownum' => '--', 'status' => 3],
            ['showname' => "已结束", 'shownum' => '--', 'status' => 4]
        ];
        $data = ['list' => $list];
        $data['showcount'] = $showcount;
        $data['page'] = [
            'page' => $page,
            'totalPage' => $totalPage,
            'page_size' => $pageSize,
            'count' => $count
        ];

        return $data;
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list'];

        $all_button = BmmcService::whereButton($token, $priID);
        $export = BmmcService::getTopButton('AddEntry, SeeLog, synchro', '', $all_button);
        $data['button_top'] = $export['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $export['button_search'] ?? [];//搜索栏按钮

        foreach ($list as $k => $v) {
            //格式化输出信息
            $list[$k]['pt_name'] = (new PlatformService())->find($list[$k]['pt_id'])->pt_name;
            $list[$k]['goods_name'] = (new GoodsService())->find($list[$k]['pg_id'], ['brand_name', 'version', 'pg_series', 'pg_id']);
            //button信息开始
            $list[$k]['button_type'] = 2;
            if ($list[$k]['type'] == 1) {
                $button = BmmcService::getButton(['EditPtprice'], $all_button, 2);
                if ($button != 'none') {
                    $Arr = $button;
                    $list[$k]['button_type'] = 1;
                }
            } else {
                $button = BmmcService::getButton(['EdiClPtprice'], $all_button, 2);
                if ($button != 'none') {
                    $Arr = $button;
                }
            }
            if ($list[$k]['revoke_type'] == 1) {
                $revoke = BmmcService::getButton(['revoke'], $all_button, 2);
                if ($revoke != 'none') {
                    $button = array_merge($button, $revoke);
                    unset($typeDo);
                }
            } else {
                $button = array();
            }
            $list[$k]['button_one'] = $button['button_one'] ?? [];
            $list[$k]['button_two'] = $button['button_two'] ?? [];
            $list[$k]['button_three'] = $button['button_three'] ?? [];
        }
        $data['list'] = $list;

        return $data;
    }


    /**
     * 检查系统是不是已经存在这个价格设置
     *
     * @param $supplierID
     * @param $goodsID
     * @return mixed
     */
    public static function getPrice($goodsID)
    {
        $exist = SalesPrice::where('pg_id', $goodsID)
            ->select('brand_name', 'pg_series')
            ->get()
            ->first();;

        if ($exist) {
            return true;
        }

        return false;
    }

    /**
     * 获取服务商的指定商品签约价
     *
     * @param int $platformID 平台id
     * @param int $platformGoodsID 平台商品id
     * @return mixed
     */
        public static function findPrice($platformID, $platformGoodsID)
    {
        $exist = SalesPrice::where('pg_id', $platformGoodsID)
            ->where('pt_id', $platformID)
            ->first()
            ->toArray();

        if ($exist) {
            return $exist;
        }

        return false;
    }


    public static function insertLog($pg_id, $price, $pt_id, $acc) {
        $data['pt_id'] = $pt_id;//登录者
        $data['pg_id'] = $pg_id;//商品id
        $data['time'] = date("Y-m-d H:i:s");//创建时间
        $data['price'] = $price;//平台卖价
        $data['user'] = $acc;//登录者
        $res = PriceLog::create($data); //添加操作日志
        if ($res) {
            return 1;
        } else {
            return 2;
        }
    }

    public static function getLogs($param, $columns = array('*'), $page = 1, $pageSize = 20) {
        $Db = new PriceLog();
        if ($param['pt_id']) {
            $Db = $Db->where('pt_id', $param['pt_id']);
        }
        if ($param['pg_id']) {
            $Db = $Db->where('pg_id', $param['pg_id']);
        }

        $offset = ($page - 1) * $pageSize;
        $count = $Db->count();
        $list = $Db->offset($offset)
            ->limit($pageSize)
            ->get()
            ->toArray();
        $data['page'] = [
            'page' => $page,
            'allPage' => ceil($count / $pageSize),
            'page_size' => $pageSize,
            'count' => $count
        ];
        foreach ($list as $k => $v) {
            $list[$k]['pt_name'] = $res = (new PlatformService())->find($list[$k]['pt_id'])->pt_name;
            $list[$k]['goods_name'] = $res = (new GoodsService())->find($list[$k]['pg_id']);
        }
        $data['list'] = $list;

        return $data;
    }
}
