<?php

/**
|--------------------------------------------------------------------------
 * redis 数据链接
|--------------------------------------------------------------------------
| 管理员管理 所需的主要业务逻辑
 * @author doubin
 * @Date: 2021/7/26
 * @Time: 16:22
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use Illuminate\Support\Facades\Redis;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class RedisService extends Service
{
	/**|--------------------------------------------------------------------
     * @name 验证键是否存在
     * @param string $key redis 键名
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
    //public static function redisHas ( $key )
    //{
    //	try{
    //    	return Redis::has($key);
    //	}catch(\Exception $e){
	   // 	return false;
    //	}
    //}

    /**|--------------------------------------------------------------------
     * @name 设置数据内容
     * @param string $key redis 键名
     * @param string $value redis 数据内容
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
    public static function redisSet ( $key , $value , $seconds ='' )
    {
    	try{
	    	if(is_array($value)){
		    	$value = json_encode($value);
	    	}
	    	if($seconds) {
                return Redis::set($key, $value, 'EX', $seconds);
            }else {
                return Redis::set($key, $value, '6480');
            }
    	}catch(\Exception $e){
	    	return false;
    	}
    }

    /**|--------------------------------------------------------------------
     * @name 获取数据内容
     * @param string $key redis 键名
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
    public static function redisGet ( $key )
    {
    	try{
	    	$value = Redis::get($key);
	    	if($value){
		    	$value = json_decode($value,true);
	    	}
        	return $value;
    	}catch(\Exception $e){
	    	return false;
    	}
    }

    /**|--------------------------------------------------------------------
     * @name 删除数据
     * @param string $key redis 键名
     * @return \Illuminate\Http\JsonResponse
     * |--------------------------------------------------------------------
     */
    public static function redisDel ( $key )
    {
    	try{
        	return Redis::del($key);
    	}catch(\Exception $e){
	    	return false;
    	}
    }
}
