<?php
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Services\BmmcService;
use App\Services\CommonService;
use Illuminate\Http\Request;
use BlueCity\Core\Inc\ErrorInc;
use DB;
class VersionController extends BaseController
{
 /**|---------------------------------------------------------------------------------
  *@name  版本日志列表
  * @param outline   概要
  * @retrun \Illuminate\Http\JsonResponse /multitype:array
  * @author du 2021/8/23 15:14
  * |---------------------------------------------------------------------------------
 */
    public function index (Request $request)
    {
        $input = $request->all();
    	$Db = Db::table('version');
        if($request->filled('outline')){
			$Db = $Db->where('outline','like','%'.$request->input('outline').'%');
        }
        $page_size = $input['page_size']??10;
        //DB::connection()->enableQueryLog();#开启执行日志
        $paginate = $Db->orderBy('id','desc')->paginate($page_size);
        //print_r(DB::getQueryLog());
        $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
        $export = BmmcService::getTopButton('addEntry','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        $list = CommonService::dataToArray($paginate->items());

        //$buttonData = [];

        foreach($list as $k=>$v){
            $buttonData = [];
            $buttonData[] = 'editEntry';
            $button = BmmcService::getListButton($buttonData,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];
        }
        $data['list'] = $list;
        $data['page'] = [
            'count' => $paginate->total(),
            'page'=> $paginate->currentPage(),
            'page_size' => $page_size,
            'allPage' => $paginate->lastPage()
        ];
        if ($list) {
            return $this->success('获取成功', $data); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);exit;
        }
    }

/**|---------------------------------------------------------------------------------
 * @name  添加日志
 * @param version_num 版本号
 * @param outline     概要
 * @param content 　　内容
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 15:14
 * |---------------------------------------------------------------------------------
*/
public function addEntry(Request $request){
    if (!$request->filled('version_num')||!$request->filled('outline')||!$request->filled('content')){
        return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    }
    $add['version_num'] = $request->input('version_num');
    $add['outline'] = $request->input('outline');
    $add['content'] = $request->input('content');
    $add['time'] = date('Y-m-d H:i:s');
    $res = Db::table('version')->insert($add);
    if($res){
        $this->insertingLog("添加，","",$add['outline'],"版本日志",$request->ip(), $request->get('session_token')['admin_acc']);
        return $this->success('添加成功'); exit;
    }else{
        return $this->error('添加失败', ErrorInc::DATA_EMPTY);exit;
    }
}

/**|---------------------------------------------------------------------------------
 * @name  编辑显示
 * @param id       数据id
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 15:16
 * |---------------------------------------------------------------------------------
*/
public function editEntry(Request $request){
    if (!$request->filled('id')){
        return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    }
    $where['id'] = intval($request->input('id'));
    $res = Db::table('version')->where($where)->get()->first();
    $time = time() - 86400;
    if($time < strtotime($res['time'])){
        return $this->success('获取成功',$res); exit;
}else{
        return $this->error('操作时间过时', ErrorInc::DATA_EMPTY);exit;
    }
}

/**|---------------------------------------------------------------------------------
 * @name  编辑日志操作
 * @param id       数据id
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 15:17
 * |---------------------------------------------------------------------------------
*/
public function editEntryDo(Request $request){
    if (!$request->filled('id')){
        return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    }
    $where['id'] = intval($request->input('id'));
    $time = time() - 86400;
    $res = Db::table('version')->where($where)->get()->first();
    if($time > strtotime($res['time'])){
        return $this->error('操作时间过时', ErrorInc::DATA_EMPTY);exit;
    }
    $update['version_num'] = $request->input('version_num');
    $update['outline'] = $request->input('outline');
    $update['content'] = $request->input('content');
    $res = Db::table('version')->where($where)->update($update);
    if($res){
        return $this->success('操作成功'); exit;
    }else{
        return $this->error('操作失败', ErrorInc::DATA_EMPTY);exit;
    }
}


}
