<?php

/**
 * Pj品牌服务类[我还有点没明白为啥不把车品、商品品牌、pj品牌放一起，然后对品牌分个类]
 *
 * @author lixiaolin
 * @Date: 2021/7/23
 * @Time: 18:56
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\ServiceItems;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class ServiceItemsService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new ServiceItems();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 获取pj品牌数据
     *
     * @param int $type
     * @param array $itemIDs
     *
     * @return mixed $data
     */
    public static function getAll(int $type, array $itemIDs = []) {
        $data = [];
        $cacheExist = Cache::has('service_items');
        if ($cacheExist) {
            $itemList = Cache::get('service_items');
            foreach ($itemList as $key=>$val) {
                if ($itemIDs && in_array($val['id'], $itemIDs)) {
                    $data[$val['id']] = $val;
                }
                if (empty($itemIDs) && $type == $val['item_type']) {
                    $data[$val['id']] = $val;
                }
            }
        } else {
            $itemList = [];
            $itemData = (new ServiceItems())
                ->select('id','item_type','item_name')
                ->get()
                ->toArray();
            foreach ($itemData as $key=>$val) {
                if ($itemIDs && in_array($val['id'], $itemIDs)) {
                    $data[$val['id']] = $val;
                }
                if (empty($itemIDs) && $type == $val['item_type']) {
                    $data[$val['id']] = $val;
                }
                $itemList[$val['id']] = $val;
            }
            Cache::set('service_items', $itemList);
        }

        return !empty($itemIDs) ? $data: $itemList;
    }

    /**
     * 获取某个brand
     *
     * @param int $ID
     *
     * @return mixed
     */
    public static function getByID(int $ID) {
        $cacheExist = Cache::has('service_items');
        $data = [];
        if ($cacheExist) {
            $brandList = Cache::get('service_items');
            foreach ($brandList as $key=>$val) {
                if ($val['id'] = $ID) {
                    return $val;
                }
            }
        } else {
            $brandList = [];
            $brandData = (new ServiceItems())
                ->select('id','item_type','item_name')
                ->get()
                ->toArray();
            foreach ($brandData as $key=>$val) {
                if ($val['id'] = $ID) {
                    $data = $val;
                }
                $brandList[$val['id']] = $val;
            }
            Cache::set('service_items', $brandList);
        }

        return $data;
    }

    public static function dataList() {
        return $attribute = [
            ['id'=>1,'attribute'=>"瓦尔塔总代"],
            ['id'=>2,'attribute'=>"博士总代"],
            ['id'=>3,'attribute'=>"统一总代"],
            ['id'=>4,'attribute'=>"风帆总代"],
            ['id'=>5,'attribute'=>"德尔福总代"],
            ['id'=>6,'attribute'=>"骆驼总代"],
            ['id'=>7,'attribute'=>"AC德科总代"],
            ['id'=>8,'attribute'=>"版纳总代"],
            ['id'=>9,'attribute'=>"浅汤总代"],
            ['id'=>10,'attribute'=>"理士总代"],
        ];
    }

}
