<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\LoginValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\LoginService;
use Illuminate\Support\Facades\Crypt;

class LoginController extends Controller
{
    public function __construct()
    {
        $this->dataValidator = new LoginValidator();
    }

    // 登录
    public function login(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->loginValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[]]);
        }

        $return_data = LoginService::login($request->all());
        return $return_data;
    }

    //退出
    public function quit(Request $request)
    {
        return LoginService::quit($request->all());
    }
}
