<?php
/**
 * 订单服务
 * 订单基础操作服务
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\GateWay;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;
use phpDocumentor\Reflection\Types\Integer;

class GateService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new GateWay();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public function create(array $input)
    {
        $userArr['skb_xm'] = $input['shr_phone'];
        $userArr['shr_name'] =$this->restrict($input['shr_name']);
        $userArr['shr_phone'] = $input['shr_phone'];
        $userArr['shr_sheng'] = $input['shr_sheng'];
        $userArr['shr_shi'] = $input['shr_shi'];
        $userArr['shr_xian'] = $input['shr_xian'];
        $userArr['shr_adress'] =$this->restrict($input['shr_adress']);
        $userArr['shr_other'] = $input['shr_other'];
        $userArr['sys_num'] = $input['sys_bh'];
        $userArr['create_time'] = date('Y-m-d H:i:s');
        $customer_id = GateWay::insertGetId($userArr);

        return $customer_id;
    }

    /**
     * @param Integer $id
     *
     * @return mixed
     */
    public function setEnabled(Integer $id){
        return $this->modelMain->where('id', $id)
            ->update(['enabled'=>1]);
    }

    /**
     * @param Integer $id
     *
     * @return mixed
     */
    public function setDisabled(Integer $id){
        return $this->modelMain->where('id', $id)
            ->update(['enabled'=>0]);
    }
}
