<?php

namespace App\Http\Controllers\orders;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use BlueCity\Core\Inc\ErrorInc;
use App\Models\SetmoneyType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\EvaluationForm;
use App\Models\Orders;
use DB;
use Excel;
use App\Services\EvaluationFormService;
use App\Services\CommonService;
use App\Services\LabtypeService;
use App\Models\Aftersale;
use App\Services\AfterSaleService;
use App\Services\OrderListService;
use App\Services\OrderService;

class EvaluationFormController extends BaseController
{
	/**
	 * @name  列表页
     * @param plat_number       平台单号
     * @param eval_leval        评价级别
     * @param eval_time(array)  评价时间
     * @param eva_status 1:新录入,4:待处理2:处理中3:商家处理5:申诉中10:已审核15:已完成50:已撤消
     * @param page              当前页码
     * @param page_size         每页条数
	 * @param Request $request
	 * @return \BlueCity\Core\Controllers\mixed
	 * @author du 2021年8月12日下午2:21:48
	 */
    public function index (Request $request)
    {
        //$input = $request->only('eva_status','plat_number','goods_name','eval_leval','ser_id','eval_time');
    	if (!in_array($request->input('eva_status'),[0,1,3,2,4,5,10,15,50])){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
        $input = $request->all();
		$session_token = $request->get('session_token');
		$list = EvaluationFormService::getList($input,$session_token);

        //导出 start
        if ($input['is_excel'] == 1) {
            $sqls = $list['sqls'];
            $excel = new CommonController();
            return $excel->getExcelOut($input['Pri_id'], $sqls, $session_token);
        }
        unset($list['sqls']);
        //导出 end

    	if($list['list']){
	    	return $this->success('获取成功', $list); exit;
    	}else{
	    	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}
    }

    /**
     * @name  导入评价
     * @param file  excel格式文件
     * @param Request $request
     * @throws Exception
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月12日下午5:32:42
     */
    public function importEvaluation (Request $request)
    {
    	try{
            $file = $request->file('file');
            if (!$file){
            	return $this->error('请选择文件', ErrorInc::FAILED_PARAM, []);exit;
            }
            $ext = $file->getClientOriginalExtension();     // 扩展名
            if(!in_array($ext,['xls','xlsx'])){
                throw new Exception("仅支持xls和xlsx结尾的excel文件");
            }
            //上传文件
            $file_name = date('YmdHis').rand(10,99).'.'.$ext;
            $urlname = public_path('excel/upload/'.date('y-m-d'));
            $file->move($urlname,$file_name);
            $filename = $urlname.'/'.$file_name;
            $admin_id = $request->get('session_token')['id'];
            $company_id = $request->get('session_token')['company_id'];
            Excel::load($filename,function($reader)use($admin_id,$company_id){
                $reader = $reader->getSheet(0);
                $data = $reader->toArray();
                $arr = [];
                $list = $data;
                if($list[0][0]!='单号' || $list[0][1]!='时间' || $list[0][2]!='评价级别' || $list[0][3]!='评价内容'|| $list[0][4]!='评价标签'){
                    throw new \Exception('excel格式错误');
                }
                foreach ($data as $key => $val){
                    $arr[$key]['plat_number']  = $val[0];//单号
                    $arr[$key]['eval_leval']  = $val[2];//评价级别
                    //对时间格式进行处理
                    if ($key == 0){
                        $arr[$key]['eval_time'] = '2019-10-08 12:00:00';
                    }else{
                        $tims = explode(' ',$val[1]);
                        $arr[$key]['eval_time'] = date("Y-m-d",strtotime($tims[0])).' '.$tims[1].':00';
                    }
                    $arr[$key]['eval_content']  = CommonService::restrict($val[3]);//评价内容
                    $arr[$key]['eval_content_show']  = CommonService::restrict($val[3]);//评价显示内容
                    $arr[$key]['eval_label']  = $val[4]??'';//评价标签
                    $arr[$key]['source_type']  = 2; //1 添加； 2 导入
                    $arr[$key]['creact_id']  = $admin_id; //1 添加； 2 导入
                    $arr[$key]['company_id']  = $company_id;
                    if ($key >0){
                        $a = EvaluationForm::insert($arr[$key]);
                    }
                }
            });
            if (file_exists($filename)){
                unlink($filename);
            }
            unset($data);
            return $this->success('导入成功');exit;
        }catch(\Exception $e){
        	return $this->error($e->getMessage(), ErrorInc::MYSQL_FAILED);exit;
        }
    }


    /**
     * @name  手动同步数据
     * @param type 2:同步数据; 1:查询需更新条数; 3:暂停
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月12日下午5:45:44
     */
    public function syncEvaluation (Request $request)
    {
    	if (!$request->filled('type')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
        if ($request->input('type') == 2){//同步数据
            $list = EvaluationForm::where('state',1)->orderBy('eva_id','ASC')->limit(10)->get();
            if (!$list){
                //return $this->error('暂无需更新的数据-1', ErrorInc::DATA_EMPTY,$list);exit;
               return response()->json(['Data' => '', 'ErrorCode' => 3, 'ErrorMessage' => "暂无需更新的数据"]);exit;

            } else {
                try{
                    Db::beginTransaction();
                    $info = $list->toArray();
                    $orderNumArr = array_column($info,'plat_number');
                    $orderArr = Orders::leftJoin('admin','orders.ser_id','=','admin.id')->whereIn('order_num',$orderNumArr)->select('orders.order_num','orders.goods_name','orders.order_time','orders.ser_id','admin.company_name','orders.ser_id','orders.order_status')->get()->toArray();

                    if (!$orderArr){
                    	//return $this->error('暂无需更新的数据-2', ErrorInc::DATA_EMPTY,$list);exit;
                        return response()->json(['Data' => '', 'ErrorCode' => 3, 'ErrorMessage' => "暂无需更新的数据"]);
                        exit;
                    }
                    //$num_arr = [];
                    /* $arr2 = [];
                    foreach ($orderArr as $ks => $vs){
                        $num_arr[$vs['order_num']] = $vs;
                        $arrs[] = $vs['order_num'];
                    } */
                    $num_arr = CommonService::jointArrayKey($orderArr, 'order_num');
                    /* $exte = array_diff($orderNumArr,$arr2);
                    if ($exte){
                        EvaluationForm::whereIn('plat_number',$exte)->update(['state'=>2]);
                    } */
                    $num = 0;
                    foreach ($info as $k => $v){
                        $oid = OrderService::getOrderBy('order_num', $v['plat_number'],['id']);

                        if(!$oid){
                            //单号不存在
                            $arr[$k]['syn_time'] = date("Y-m-d H:i:s");//同步时间
                            $arr[$k]['state'] = 3;
                            $arr[$k]['eva_status'] = 55;
                            $res = EvaluationForm::where('eva_id',$v['eva_id'])->update($arr[$k]);
                            if ($res){
                                $num++;
                            }
                            continue;
                        }

                        $or = EvaluationForm::where('plat_number',$v['plat_number'])->where('state','!=',1)->value('eva_id');

                        if($or){
                            //单号重复
                            $arra[$k]['syn_time'] = date("Y-m-d H:i:s");//同步时间
                            $arra[$k]['state'] = 4;
                            $arra[$k]['eva_status'] = 55;
                            $res = EvaluationForm::where('eva_id',$v['eva_id'])->update($arra[$k]);
                            if ($res){
                                $num++;
                            }
                            continue;
                        }


//                         if (isset($num_arr[$v['plat_number']])){
                            $poss[$k]['order_time']    = $num_arr[$v['plat_number']]['order_time']??'';
                            $poss[$k]['goods_name']    = $num_arr[$v['plat_number']]['goods_name']??'';
                            $poss[$k]['company_name']  = $num_arr[$v['plat_number']]['company_name']??'';
                            $poss[$k]['ser_id']        = $num_arr[$v['plat_number']]['ser_id']??'';
                            $poss[$k]['status']        = $num_arr[$v['plat_number']]['order_status'];

                            $poss[$k]['state']         = 2;
                            $poss[$k]['syn_time'] = date("Y-m-d H:i:s");//同步时间
                            $res = EvaluationForm::where('eva_id',$v['eva_id'])->update($poss[$k]);
                            if ($res){
                                $num++;
                            }
//                         }
                    }
                    if ($num >0){
                        DB::commit();
                        $data = $list->count();
                        unset($num);
                        return $this->success('同步成功',$data);exit;
                    }else{
                        DB::rollBack();
                        //return $this->error('同步失败',ErrorInc::MYSQL_FAILED);exit;
                        return response()->json(['Data' => '', 'ErrorCode' => 2, 'ErrorMessage' => "同步失败"]);
                        exit;
                    }
                }catch(\Exception $e){
                    DB::rollBack();
                    //return $this->error($e->getMessage(),ErrorInc::MYSQL_FAILED);exit;
                    return response()->json(['Data' => '', 'ErrorCode' => 3, 'ErrorMessage' => $e->getMessage()]);
                    exit;
                }
            }
        } elseif ($request->input('type') == 1){//查询数据条数
            $count = EvaluationForm::distinct('plat_number')->where('state',1)->select('plat_number')->get()->toArray();
            $count = count($count);
            if ($count > 0){
            	return $this->success('获取成功',$count);exit;
            } else {
                return response()->json(['Data' => '', 'ErrorCode' => 3, 'ErrorMessage' => "暂无需更新的数据"]);
                exit;
            	//return $this->error('暂无需更新的数据3', ErrorInc::DATA_EMPTY);exit;
            }

        } elseif ($request->input('type') == 3){//暂停
        	//return $this->error('暂停成功',ErrorInc::MYSQL_FAILED);exit;
            return response()->json(['Data' => '', 'ErrorCode' => 11, 'ErrorMessage' => "暂停成功"]);
            exit;
        }else{
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
    }

    /**
     * @name  评价类型
     * @param id      数据id
     * @param labtype 评价标签(array)
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月13日下午2:01:21
     */
    public function labEvaluation (Request $request)
    {
        if (!$request->filled('id')||!$request->filled('labtype')) {
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $id = intval($request->input('id'));
        $labtype = $request->input('labtype');
        //添加标签 afterSale
        $order_num = EvaluationFormService::getInfoBy('eva_id',$id,['plat_number']);
        $orderlist = OrderListService::getOrderListBy('order_num', $order_num,'first',['serial_number','ser_id','order_num','p_id']);
        if($orderlist){
        	$orderinfo = $orderlist;
        }else{
        	$orderinfo = OrderService::getOrderBy('order_num', $order_num,['order_num','p_id','ser_id']);
        	$orderinfo['serial_number'] = '';
        }

        $info = AfterSaleService::insertData($labtype, $orderinfo, $request->get('session_token'));
        //组装数据
        if (isset($info) && $info != []){
        	$eval_label = implode(',',$info);
        	$res = EvaluationForm::where('eva_id',$id)->update([
        			'eval_label' => $eval_label
        	]);
        	if ($res) {
        		$plat_number = EvaluationFormService::getInfoBy('eva_id',$id,['plat_number']);
        		$this->insertingLog('评价类型，',$plat_number,'标签：'.$eval_label,'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
        		return $this->success('操作成功');exit;
        	} else {
        		return $this->error('更新失败', ErrorInc::MYSQL_FAILED);exit;
        	}
        }

    }


    /**
     * @name  详情
     * @param id 数据id
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年8月13日下午1:37:30
     */
    public function listEvaluation (Request $request)
    {
        if (!$request->filled('id')) {
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $id = intval($request->input('id'));
        $data = EvaluationFormService::listEvaluation($id);
        return response()->json(['Data' => $data, 'ErrorCode' => 1, 'ErrorMessage' => '成功']);exit;
    }


    /**
     * @name  解释
     * @param id 数据id
     * @param evld_content 备注内容
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月13日上午9:28:37
     */
    public function explainEvaluation (Request $request)
    {
        if (!$request->filled('id')||!$request->filled('evld_content')) {
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $input = $request->only('id','evld_content');
        $eva_status = EvaluationFormService::getInfoBy('eva_id', $input['id'],['eva_status']);
        if($eva_status==2){
        	return $this->error('已解释', ErrorInc::MYSQL_FAILED);exit;
        }
        $session = $request->get('session_token');
        $res = EvaluationFormService::createEvaData($input['id'], $session['id'], $session['admin_acc'], $request->input('evld_content'), '', 1);
        if ($res) {
        	EvaluationForm::where('eva_id', $input['id'])->update(['eva_status' => 2]);
        	$plat_number = EvaluationFormService::getInfoBy('eva_id', $request->input('id'),['plat_number']);
        	$this->insertingLog('解释，',$plat_number,'解释','平台评价',$request->ip(),$session['admin_acc']);
        	return $this->success('操作成功');exit;
        } else {
        	return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  申诉
     * @param id           数据id
     * @param evld_content 备注内容
     * @param evld_pic     图片（array）
     * @param evld_sound   音频
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月13日上午10:05:23
     */
    public function appealEvaluation (Request $request)
    {
        if (!$request->filled('id')||!$request->filled('evld_content')) {
        	return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $input = $request->only('id','evld_content','evld_pic','evld_sound','evld_label');
        $session = $request->get('session_token');

        $eva_status = EvaluationFormService::getInfoBy('eva_id', $input['id'],['eva_status']);
        if($eva_status==5){
        	return $this->error('已申诉', ErrorInc::MYSQL_FAILED);exit;
        }

        if ($request->filled('evld_pic') && $request->input('evld_pic') != []) {
        	$picArr = $request->input('evld_pic');
        	$evld_pic = implode(',',$picArr);
        }
        if ($request->filled('evld_sound')) {
        	$evld_sound = $request->input('evld_sound');
        }
        $res = EvaluationFormService::createEvaData($input['id'], $session['id'], $session['admin_acc'], $request->input('evld_content'), $request->input('evld_label'), 5,$evld_pic,$evld_sound);
        EvaluationForm::where('eva_id',$input['id'])->update(['eva_status'=>5]);
        if ($res) {
        	$plat_number = EvaluationFormService::getInfoBy('eva_id', $request->input('id'),['plat_number']);
        	$this->insertingLog('申诉，',$plat_number,'标签：'.$request->input('evld_label'),'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
       		return $this->success('操作成功');exit;
        } else {
        	return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }

    }

    /**
     * @name  商家处理
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du 2021年8月13日上午10:58:53
     */
    public function businessDeal (Request $request)
    {
    	if (!$request->filled('id')||!$request->filled('eval_content_show')) {
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$input = $request->only('id','eval_content_show','content');
    	$token = $request->get('session_token');
    	$eva_status = EvaluationFormService::getInfoBy('eva_id', $input['id'],['eva_status']);
    	if($eva_status==3){
    		return $this->error('商家已处理', ErrorInc::MYSQL_FAILED);exit;
    	}
    	$plat_number = EvaluationFormService::getInfoBy('eva_id', $input['id'],['plat_number']);
    	if ($request->filled('content')) {
    		$content = $request->input('content');
    		CommonService::accMe($plat_number,'平台评价',"商家处理，".$content,'','',$token['admin_groupnew'],$token['admin_acc'],$request->get('session_token')['id']);//添加备注);
    	}
    	if ($token['admin_groupnew'] == 2) {
    		$eval_person = 2;
    	} else {
    		$eval_person = 1;
    	}
    	$result = EvaluationForm::where('eva_id',$input['id'])->update([
    			'eva_status' => 3,
    			'eval_person'=> $eval_person,
    			'eval_content_show' => $input['eval_content_show'],
    			'eval_level' => $token['admin_groupnew']
    	]);
    	if ($result) {
    		$this->insertingLog('商家处理，',$plat_number,'评价ID:'.$input['id'],'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
    		return $this->success('操作成功');exit;
        } else {
        	return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }


    /**
     * @name  审核
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du 2021年8月13日上午10:59:35
     */
    public function toExamine (Request $request)
    {
    	if (!$request->filled('id')) {
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$input = $request->only('id');
    	$token = $request->get('session_token');
    	$eva_status = EvaluationFormService::getInfoBy('eva_id', $input['id'],['eva_status']);
    	if($eva_status==10){
    		return $this->error('已审核', ErrorInc::MYSQL_FAILED);exit;
    	}
    	$plat_number = EvaluationFormService::getInfoBy('eva_id', $input['id'],['plat_number']);
    	if ($request->filled('content')) {
            $content = $request->input('content');
    	    $even_data['evld_evid'] = $input['id'];
            $even_data['evld_creactid'] = $request->get('session_token')['id'];
            $even_data['evld_creacter'] = $request->get('session_token')['admin_acc'];
            $even_data['evld_creactime'] = date("Y-m-d H:i:s");
            $even_data['evld_content'] = $content;
            $even_data['evld_type'] = 1;
            DB::table('evaluation_data')->insert($even_data);
    		CommonService::accMe($plat_number,'平台评价',"审核，".$content,'','',$token['admin_groupnew'],$token['admin_acc'],$request->get('session_token')['id']);//添加备注);
    	}
    	$result = EvaluationForm::where('eva_id',$input['id'])->update(['eva_status' => 10]);
    	if ($result) {
    		$this->insertingLog('审核，',$plat_number,'评价ID:'.$input['id'],'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
    		return $this->success('操作成功');exit;
    	} else {
    		return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
    	}
    }

    /**
     * 撤消
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月13日上午11:38:07
     */
    public function cancle(Request $request){
    	if (!$request->filled('id')) {
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$input = $request->only('id');
    	$token = $request->get('session_token');
    	$eva_status = EvaluationFormService::getInfoBy('eva_id', $input['id'],['eva_status']);
    	if($eva_status==50){
    		return $this->error('已撤消', ErrorInc::MYSQL_FAILED);exit;
    	}
    	$result = EvaluationForm::where('eva_id',$input['id'])->update(['eva_status' => 50]);
    	if ($result) {
    		$plat_number = EvaluationFormService::getInfoBy('eva_id', $request->input('id'),['plat_number']);
    		$this->insertingLog('撤消，',$plat_number,'评价ID:'.$input['id'],'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
    		return $this->success('操作成功');exit;
    	} else {
    		return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
    	}
    }
    /**
     * 获取评价标签
     * @param order_num 平台单号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月14日上午10:22:20
     */
    public function evaluateLabe(Request $request)
    {
    	if (!$request->filled('order_num')) {
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$labList = LabtypeService::labelList ();
    	$db = new Aftersale();
    	$afsArr = CommonService::getMysqlData($db, ['afs_order'=>$request->input ( 'order_num' )],['afs_paid', 'afs_type']);
		if ($afsArr) {
			$afs_paids = array_column ( $afsArr, 'afs_paid' );
			$afs_types = array_column ( $afsArr, 'afs_type' );
			$labArr = array_unique(array_merge ( $afs_paids, $afs_types ));
		}

	$list = LabtypeService::getsTree($labList,60,1,$labArr,false);
	return $this->success('获取成功',$list);

    }

    /**
     * @name 便捷评价
     * @param Request $request
     * @return array|mixed
     * @author du
     * @date 2022/1/4
     */
/*    public function fastEvaluate(Request $request){
        if (!$request->filled('order_num')||!$request->filled('content')||!$request->filled('labtype')) {
            return $this->error('少订单号或少备注或少标签', ErrorInc::FAILED_PARAM, []);exit;
        }
        $input = $request->all();
        $orderInfo = OrderService::getOrderBy('order_num', $input['order_num'],['sys_num','id']);
        if(!$orderInfo){
            return $this->error('订单不存在', ErrorInc::MYSQL_FAILED);exit;
        }
        $input['sys_num'] = $orderInfo['sys_num'];
        $input['id'] = $orderInfo['id'];
        $session = $request->get('session_token');
        $data = EvaluationFormService::addEvaluation($input,$session,$request->ip());
        return $data;

    }*/

    /**
     * 新录入修改为待处理
     * param id int 数据ID
     * eva_status 状态：1:新录入,4:待处理2:处理中3:商家处理5:申诉中10:已审核15:已完成50:已撤消
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/20
     */
    public function newToWait(Request $request){
        if (!$request->filled('id')) {
            return $this->error('Id不能为空', ErrorInc::FAILED_PARAM, []);exit;
        }
        $id = intval($request->input('id'));
        $res = EvaluationForm::where('eva_id',$id)->value('eva_status');
        if(!$res){
            return $this->error('不存在', ErrorInc::MYSQL_FAILED);exit;
        }
        if($res!=1){
            return $this->error('状态不正确', ErrorInc::MYSQL_FAILED);exit;
        }

        $ret = EvaluationForm::where('eva_id',$id)->update(['eva_status'=>4]);
        if($ret){
            $plat_number = EvaluationForm::where('eva_id',$id)->value('plat_number');
            $this->insertingLog('修改为待处理',$plat_number,'评价ID:'.$id,'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
            return $this->success('操作成功');
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }

    }

    /**
     *
     * eva_status 状态：1:新录入,4:待处理2:处理中3:商家处理5:申诉中10:已审核15:已完成50:已撤消
     * @param ids array
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/20
     */
    public function matchNewToFinish(Request $request){
        if (!$request->filled('ids')) {
            return $this->error('Id不能为空', ErrorInc::FAILED_PARAM, []);exit;
        }
        $ids = $request->input('ids');
        if(!is_array($ids)){
            return $this->error('不是数组', ErrorInc::FAILED_PARAM, []);exit;
        }
        $ret = EvaluationForm::whereIn('eva_id',$ids)->update(['eva_status'=>15]);
        if($ret){
            $plat_numbers = EvaluationForm::whereIn('eva_id',$ids)->pluck('plat_number')->toarray();
            $ids = implode(',',$ids);
            $plat_numbers = implode(',',$plat_numbers);
            $this->insertingLog('修改为已完成',$plat_numbers,'评价ID:'.$ids,'平台评价',$request->ip(),$request->get('session_token')['admin_acc']);
            return $this->success('操作成功');
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }

    }



}
