<?php

/**
 * 服务商签约价管理服务
 * 服务商签约价
 * @author lixiaolin
 * @Date: 2021/7/22
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\GhXPrice;
use BlueCity\Core\Service\Service;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class SupplierXPriceService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new GhXPrice();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $Db = GhXPrice::leftJoin('pj_goods', 'pj_goods.pg_id', '=', 'gh_xprice.goods_id')
            ->leftJoin('admin', 'admin.id', '=', 'gh_xprice.ser_id');
        $Db = $Db->where("is_delect", '1');
        if (!empty($param['version'])) {//商品编号
            $Db = $Db->where("pg_goodsname", 'like','%'.$param['version'].'%');
        }
        if (!empty($param['brand_name'])) {//商品品牌
            $Db = $Db->where("brand_name", $param['brand_name']);
        }
        if (!empty($param['pt_type'])) {//平台类型ID
            $Db = $Db->where("pt_type", $param['pt_type']);
        }
        if (!empty($param['gh_price_name'])) { //操作人
            $Db = $Db->where("gh_price_name", $param['gh_price_name']);
        }
        if (!empty($param['company_id'])) { //公司名称
            $Db = $Db->where("ser_id", (int)$param['company_id']);
        }
        if (!empty($param['create_time'])) { //开始时间
            $time = date('Y-m-d H:i:s', strtotime($param['create_time']));
            $Db = $Db->where("create_time", ">=", $time);
        }
        if (!empty($param['end_time'])) { //结束时间
            $time = date('Y-m-d H:i:s', strtotime($param['end_time']));
            $Db = $Db->where("create_time", '<=', $time);
        }

        $count = $Db->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $Db->select('gh_xprice.id AS id', 'gh_xprice.gh_price_name AS gh_price_name', 'gh_xprice.goods_id AS goods_id', 'gh_xprice.ser_id AS ser_id', 'gh_xprice.remarks', 'gh_xprice.create_time AS create_time', 'supply_price', 'brand_name', 'pj_goods.pg_series AS pg_series', 'pj_goods.version AS version', 'company_name','gh_xprice.pt_type')
                ->orderBy('gh_xprice.id', 'DESC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $Db->select('gh_xprice.id AS id', 'gh_xprice.gh_price_name AS gh_price_name', 'gh_xprice.goods_id AS goods_id', 'gh_xprice.ser_id AS ser_id', 'gh_xprice.remarks', 'gh_xprice.create_time AS create_time', 'supply_price', 'brand_name', 'pj_goods.pg_series AS pg_series', 'pj_goods.version AS version', 'company_name','gh_xprice.pt_type')
                ->orderBy('gh_xprice.id', 'DESC')
                ->limit($pageSize)
                ->get();
        }

        return ['list' => $list, 'totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list'];
        //按钮-添加
        $all_button = BmmcService::wherebutton($token, $priID);
        $addPt = BmmcService::getTopButton('addGhprice', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮

        $pt_types = PlatformService::getPtType(true);

        if (!$list->isEmpty()) {
            $list = $list->toArray();
            foreach ($list as $kl => $vl) {
                if ($vl["ser_id"] == 0) {
                    $list[$kl]["company_name"] = "统一价格";
                }
                if ($vl['pg_series'] == "") {
                    $list[$kl]['type'] = $vl['version'];
                } else {
                    $list[$kl]['type'] = $vl['pg_series'] . '-' . $vl['version'];
                }
                $list[$kl]['pt_type_name'] = $pt_types[$vl['pt_type']];

                $button = BmmcService::getListButton(['editGhprice, delGhPrice'], $all_button);//编辑，删除按钮
                $list[$kl]['button_one'] = $button['button_one'] ?? [];
                $list[$kl]['button_two'] = $button['button_two'] ?? [];
                $list[$kl]['button_three'] = $button['button_three'] ?? [];
            }
            $data['list'] = $list;
        }
        $data['pt_type'] = PlatformService::getPtType();
        return $data;
    }

    public static function getPrice($id)
    {
        $res = GhXPrice::where('gh_xprice.id', $id)
            ->leftJoin('pj_goods', 'pj_goods.pg_id', '=', 'gh_xprice.goods_id')
            ->leftJoin('admin', 'admin.id', '=', 'gh_xprice.ser_id')
            ->select('gh_xprice.id', 'gh_xprice.goods_id', 'gh_xprice.ser_id', 'remarks', 'supply_price', 'company_name', 'brand_name', 'pg_series', 'version', 'gh_xprice.pt_type')
            ->first()
            ->toArray();
        if ($res['pg_series'] == "") {
            $res['goods_number'] = $res['brand_name'] . '-' . $res['version'];
        } else {
            $res['goods_number'] = $res['brand_name'] . '-' . $res['pg_series'] . '-' . $res['version'];
        }

        return $res;
    }

    /**
     * 检查系统是不是已经存在这个价格设置
     *
     * @param $supplierID
     * @param $goodsID
     * @return mixed
     */
    public static function checkExistPrice($supplierID, $goodsID,$pt_type)
    {
        $exist = GhXPrice::where('goods_id', $goodsID)
            ->where('ser_id', $supplierID)
            ->where('pt_type', $pt_type)
            ->exists();

        if ($exist) {
            return true;
        }

        return false;
    }
    /**
     * 获取服务商的指定商品签约价
     *
     * @param int $supplierID 用户id
     * @param int $goodsID 商品id
     * @param array $select 待查询字段
     * @return mixed
     */
    public static function findPrice($supplierID, $goodsID , $select = [])
    {
        $type = 'first';
        $db = new GhXPrice();
        if(count($select) == '1'){
            $type = 'value';
        }
        $exist = CommonService::getMysqlData($db, ['goods_id'=>$goodsID,'ser_id'=>$supplierID],$select,['id'=>'DESC'],$type);
        if ($exist) {
            return $exist;
        } else {
            $db = new GhXPrice();
            $exist = CommonService::getMysqlData($db, ['goods_id'=>$goodsID,'ser_id'=>0],$select,['id'=>'DESC'],$type);
            return $exist;
        }

        return false;
    }
}
