<?php

/**
|--------------------------------------------------------------------------
 * 管理员服务类
|--------------------------------------------------------------------------
| 管理员管理 所需的主要业务逻辑
 * @author lixiaolin
 * @Date: 2021/7/22
 * @Time: 08:49
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Factory\OrderFactory;
use App\Models\Admin;
use App\Models\AdminInfor;
use App\Models\AdminToken;
use App\Models\AdminCertificate;
use App\Models\Certification;
use App\Models\ScoresSend;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class AdminService extends Service
{
    public  static $instance;
    public  $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new Admin();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 插入新的数据获取ID值
     * @param array $adminData
     *
     * @return int $id
     */
    public static function insertData(array $adminData) {

        return Admin::insertGetId($adminData);
    }

    /**
     * 插入新的数据获取ID值
     * @param array $adminData
     *
     * @return int $id
     */
    public static function insertAdminInfo(array $adminData) {

        return AdminInfor::insertGetId($adminData);
    }

    /**
     * 插入新的数据获取ID值
     * @param array $scoresSend
     *
     * @return int $id
     */
    public static function insertScoresSend(array $scoresSend) {

        return ScoresSend::insertGetId($scoresSend);
    }
    /**
     * 插入新的数据获取ID值
     * @param array $scoresSend
     *
     * @return int $id
     */
    public static function insertCertification(array $certification) {

        return Certification::insertGetId($certification);
    }

    /**
     * 获取订单列表
     * @param array $params
     * @param array $columns
     * @return array|mixed
     */
    public static function getAdmins($params, $columns = ['id', 'company_name'])
    {
        $db = new Admin();
        return CommonService::getMysqlData($db, $params,$columns,['id'=>'desc']);
    }

    /**获取admin详细内容
     *
     * @param int $ID ID
     *
     * @return array|mixed
     */
    public function getAdminByID($ID)
    {
        return Admin::where('id',$ID)->first();
    }

    /**获取admin详细内容
     *
     * @param  $key
     * @param  $value
     * @param  $select
     * @param string $type
     *
     * @return mixed
     */
    public static function getAdminBy($key, $value, $select = [] , $type = 'get')
    {
        $db = new Admin();
        if(in_array($key, ['id'])) {
            $type = 'first';
        }
        if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }


}
