<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;

class DeductionFee extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'DeductionFee';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command DeductionFee';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $find_data = DB::table('admin')
            ->groupBy('company_id')
            ->get();
        foreach ($find_data as $key => $value) {
            $find_balance = DB::table('admin_recharge')
                ->where('adre_company_id', $value['company_id'])
                ->first();
            if (empty($find_balance)) {
                $add_data['adre_company_id'] = $value['company_id'];
                $add_data['adre_banlance'] = -100;
                $add_data['adre_first_monthFee'] = date('Y-m-d H:i:s');
                $add_data['adre_next_monthFee'] = date('Y-m-d H:i:s', strtotime('+1 month'));
                $add_res = DB::table('admin_recharge')->insertGetId($add_data);
            } else {
                if (empty($find_balance['adre_next_monthFee'])) {
                    $update['adre_banlance'] = $find_balance['adre_banlance'] - 100;
                    $update['adre_first_monthFee'] = date('Y-m-d H:i:s');
                    $update['adre_next_monthFee'] = date('Y-m-d H:i:s', strtotime('+1 month'));
                    $update_res = DB::table('admin_recharge')
                        ->where('adre_id', $find_balance['adre_id'])
                        ->update($update);
                } else {
                    if (time() >= strtotime($find_balance['adre_next_monthFee'])) {
                        $update['adre_banlance'] = $find_balance['adre_banlance'] - 100;
                        $update['adre_next_monthFee'] = date('Y-m-d H:i:s', strtotime($find_balance['adre_next_monthFee'],'+1 month'));
                        $update_res = DB::table('admin_recharge')
                            ->where('adre_id', $find_balance['adre_id'])
                            ->update($update);
                    }
                }
            }
            $order_number = 'YF'.date('YmdHis').rand(1000,9999);
            $recharge_order['reo_adm_id'] = $value['id'];
            $recharge_order['reo_company_id'] = $value['company_id'];
            $recharge_order['reo_order_number'] = $order_number;
            $recharge_order['reo_price'] = -100;
            $recharge_order['reo_pay_state'] = 1;
            $recharge_order['reo_state'] = 1;
            $recharge_order['reo_type'] = 3;//扣月费
            if ($value['admin_groupnew'] == 2) {
                $recharge_order['reo_client_type'] = 1;
            } elseif ($value['admin_groupnew'] == 3) {
                $recharge_order['reo_client_type'] = 2;
            } else {
                $recharge_order['reo_client_type'] = 3;
            }
            $recharge_order['reo_pay_way'] = 1;
            $recharge_order['reo_create_time'] = date('Y-m-d H:i:s');
            $recharge_order['reo_pay_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('recharge_order')->insertGetId($recharge_order);
        }
    }
}
