<?php
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\AfterSaleService;
use App\Services\OrderService;
use App\Services\CommonService;
use App\Models\Aftersale;



/**
 * @name 标签记录
 * Class AfterSaleController
 * @package App\Http\Controllers\Common
 */
class AfterSaleController extends BaseController
{

	/**
	 * @name  标签记录 >> 列表页
     * @param afs_statues   1:未处理 2:已处理
     * @param afs_order     平台单号
     * @param afs_serial    工单号
     * @param afs_serid     网点id
     * @param afs_creactime 创建时间
	 * @param Request $request
	 * @return \BlueCity\Core\Controllers\mixed
	 * @author du 2021年8月18日下午2:39:50
	 */
    public function index (Request $request)
    {
    	if (!$request->filled('afs_statues')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
        $input = $request->all();
        $session = $request->get('session_token');
    	$list = AfterSaleService::getList($input,$session);
    	if($list['list']){
	    	return $this->success('获取成功', $list); exit;
    	}else{
	    	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}
    }

    /**
     * @name 处理标签
     * @param afs_order 平台单号
     * @param afs_id    数据id
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年8月18日下午3:31:20
     */
    public function chuliOrder (Request $request)
    {
        if (!$request->filled('afs_order')|| !$request->filled('afs_id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        $afs_order = $request->input('afs_order');
        $id = intval($request->input('afs_id'));
        $session = $request->get('session_token');
        $orders_id = OrderService::getOrderBy('order_num', $afs_order,['sys_num']);
        if (!$orders_id){
        	return $this->error('该订单无系统单号，请确认', ErrorInc::DATA_EMPTY);exit;
        }
        if($request->filled('note_content')){
            CommonService::accMe($orders_id, '售后管理', $request->input('note_content'), $afs_order, 1, $session['admin_groupnew'], $session['admin_name'], $session['id']);
		}
        $data['asf_time'] = date('Y-m-d H:i:s');
        $data['afs_statues'] = 2;
        $data['afs_dealer'] = $session['admin_name'];
        $save = Aftersale::where('afs_id',$id)->update($data);
        if($save){
        	$this->insertingLog('处理标签，',$afs_order,'订单('.$afs_order.')','售后管理',$request->ip(),$session['admin_acc']);//日志
        	return $this->success('操作成功');exit;
        }else{
        	return $this->error('暂无数据', ErrorInc::MYSQL_FAILED);exit;
        }

    }


}
