<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Downloads extends Model
{
    use SoftDeletes;

    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'downloads';
    protected $primaryKey = 'id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
    protected $fillable = ['file_name', 'file_type', 'file_path', 'file_ext', 'comments'];
    public $attributeNames = [
        'id'=>'编号',
        'file_name'=>'文件名称',
        'file_type'=>'文件类型',
        'file_path'=>'文件路径',
        'file_ext'=>'文件扩展名',
        'downloaded'=>'已下载',
        'download_count'=>'下载次数',
        'comments'=>'创建条件',
        'create_uid'=>'创建人ID',
        'deleted_at'=>'删除时间',
        'created_at'=>'创建时间',
        'updated_at'=>'更新时间'
    ];
    protected $needPri = [];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    //public $timestamps = false;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';’

    public function downloadsRecords() {
        return $this->hasMany('App/Models/DownloadsRecords', 'file_id', 'id');
    }
}
