<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\BmmcService;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;
class ManageAppController extends BaseController
{

    /**
     * @name  APP信息管理-列表
     * @param app_type    信息类别 1：白皮书（App） 2:新闻（App） 3:特别关乎
     * @param app_tittle  文章标题
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/3
     */
    public function index ( Request $request )
    {
        //页码数据
        $page_size = (int)$request->input('page_size', 10);
        $page = (int)$request->input('page');
        if ($page < 1) {
            $page = 1;
        }
        $offset = ($request->input('page', 1) - 1) * $page_size;
        $Db = Db::table('manageapp');
        if ($request->filled('app_type')) {
            $Db = $Db->where('app_type', (int)$request->input('app_type'));
        }
        if ($request->filled('app_tittle')) {
            $Db = $Db->where('app_tittle', 'like', '%' . $request->input('app_tittle') . '%');
        }
       /* $session = $request->get('session_token');
        if($session['admin_groupnew']!=7){
            $Db = $Db->where('company_id',$session['company_id']);
        }*/
        $count = $Db->count();
        $list = $Db->select('app_id', 'app_tittle', 'app_time', 'app_cracter', 'app_type', 'app_sort')->orderBy('app_id', 'desc')->offset($offset)->limit($page_size)->get();

        $all_button = BmmcService::whereButton($request->input('token'), $request->input('Pri_id'));
        $export = BmmcService::getTopButton('addManage', '', $all_button);
        $data['button_top'] = $export['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $export['button_search'] ?? [];//搜索栏按钮
        if ($list->isEmpty()) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        } else {
            $list = $list->toArray();
            foreach ($list as $k => $v) {
                $buttonData = [];
                $buttonData[] = 'editManage';
                $button = BmmcService::getListButton($buttonData, $all_button);
                $list[$k]['button_one'] = $button['button_one'] ?? [];
                $list[$k]['button_two'] = $button['button_two'] ?? [];
                $list[$k]['button_three'] = $button['button_three'] ?? [];
            }
            $data['page'] = ['page' => $page, 'page_size' => $page_size, 'count' => $count,'allPage' => ceil($count/$page_size)];
            $data['list'] = $list;
            return $this->success('获取成功',$data);exit;
        }
    }

    /**
     * @name 添加
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2021/9/3
     */
    public function addManage(Request $request){
        $type = (int)$request->input('type',1);
        //白皮书只能有一个所以我需要查，是否数据库内有白皮书
        $res1 = Db::table('manageapp')->where('app_type',1)->first();
        if($type==1){
            if($res1){
                $pb = 1;//存在白皮书
            }else{
                $pb = 2;
            }
            return $this->success('获取成功',['pb'=>$pb]);exit;
        }else{
            //执行添加
            $input = $request->only('app_type','app_tittle','app_sort','app_describe','app_content');
            $checkKey = CommonService::checkKey(['app_type','app_tittle','app_sort','app_describe','app_content'],$input);
            if($checkKey['code']!=1){
                return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
            }
            //$image = $request->input('image');//前端上传Oss后的链接

            $poss = [];
            $poss['app_type'] = (int)$request->input('app_type');
            $poss['app_tittle'] = $request->input('app_tittle');
            $poss['app_sort'] = (int)$request->input('app_sort');
            $poss['app_describe'] = $request->input('app_describe');
            $poss['app_content'] = $request->input('app_content');

            if($res1 && $poss['app_type']==1){
                return $this->error('白皮书已存在', ErrorInc::MYSQL_FAILED);exit;
            }
            $poss['app_pic'] = 'http://img.sudianwang.com/SDKB/Uploads/APP_xinw/5ff2de2ce11fc.jpeg';
            $poss['app_cracter'] = $request->get('session_token')['admin_acc'];
            $poss['app_time'] = date('Y-m-d H:i:s');
            $res = Db::table('manageapp')->insert($poss);
            if($res){
                return $this->success('添加成功');exit;
            }else{
                return $this->error('添加失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }
    }

    /**
     * @name 编辑
     * @param type 1:获取信息 2: 执行编辑
     * @param app_id 数据ID
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du
     * @date 2021/9/3
     */
    public function editManage(Request $request){
        $type = (int)$request->input('type',1);
        //白皮书只能有一个所以我需要查，是否数据库内有白皮书
        $res1 = Db::table('manageapp')->where('app_type',1)->first();
        $id = intval($request->input('app_id',0));
        $data = Db::table('manageapp')->where('app_id',$id)->first();
        if(!$data){
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
        if($type==1){
            $data['app_pic'] = $data['app_pic'];
            if($res1){
                $pb = 1;//存在白皮书
            }else{
                $pb = 2;//不存在
            }
            if($data['app_type'] == 1){
                $pb = 2;
            }
            $data['pb'] = $pb;
            return $this->success('获取成功',$data);
        }else{
            //执行编辑
            if(!$request->filled('app_type') || !$request->filled('app_tittle') || !$request->filled('app_sort') || !$request->filled('app_describe') || !$request->filled('app_content')){
                return $this->error('缺少参数', ErrorInc::FAILED_PARAM);exit;
            }
            $poss = [];
            $poss['app_type'] = (int)$request->input('app_type');
            $poss['app_tittle'] = $request->input('app_tittle');
            $poss['app_sort'] = (int)$request->input('app_sort');
            $poss['app_describe'] = $request->input('app_describe');
            $poss['app_content'] = $request->input('app_content');
            if($res1 && $poss['app_type']==1){
                return $this->error('白皮书已存在', ErrorInc::MYSQL_FAILED);exit;
            }

            $poss['app_cracter'] = $request->get('session_token')['admin_acc'];
            $res = Db::table('manageapp')->where('app_id',$id)->update($poss);
            if($res){
                return $this->success('编辑成功');exit;
            }else{
                return $this->error('编辑失败', ErrorInc::MYSQL_FAILED);exit;
            }

        }

    }


}
