<?php

/**
 * 服务商签约价管理服务
 * 服务商签约价
 * @author lixiaolin
 * @Date: 2021/7/22
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\GhPrice;
use BlueCity\Core\Service\Service;


class SupplierPriceService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new GhPrice();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public static function search_s($param, $columns = array('*'), $page = 1, $pageSize = 20,$session='')
    {
        $Db = GhPrice::leftJoin('pj_goods', 'pj_goods.pg_id', '=', 'gh_price.goods_id')
            ->leftJoin('admin', 'admin.id', '=', 'gh_price.ser_id');
        $Db = $Db->where("is_delect", '1');
        if (!empty($param['version'])) {//商品编号
            $Db = $Db->where("pg_goodsname", 'like','%'.$param['version'].'%');
        }
        if (!empty($param['brand_name'])) {//商品品牌
            $Db = $Db->where("brand_name", $param['brand_name']);
        }
        if (!empty($param['gh_price_name'])) { //操作人
            $Db = $Db->where("gh_price_name", $param['gh_price_name']);
        }
        if (!empty($param['company_id'])) { //公司名称
            $Db = $Db->where("ser_id", (int)$param['company_id']);
        }
        if (!empty($param['create_time'])) { //开始时间
            $time = date('Y-m-d H:i:s', strtotime($param['create_time']));
            $Db = $Db->where("create_time", ">=", $time);
        }
        if (!empty($param['end_time'])) { //结束时间
            $time = date('Y-m-d H:i:s', strtotime($param['end_time']));
            $Db = $Db->where("create_time", '<=', $time);
        }

      if ($session['admin_groupnew'] != 7){//管理员可以看全部 && $session['admin_groupnew'] != 8
            $Db = $Db->where("gh_price.company_id",$session['company_id']);
        }

        $count = $Db->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $Db->select('gh_price.id AS id', 'gh_price.gh_price_name AS gh_price_name', 'gh_price.goods_id AS goods_id', 'gh_price.ser_id AS ser_id', 'gh_price.remarks', 'gh_price.create_time AS create_time', 'supply_price', 'brand_name', 'pj_goods.pg_series AS pg_series', 'pj_goods.version AS version', 'company_name')
                ->orderBy('gh_price.id', 'DESC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $Db->select('gh_price.id AS id', 'gh_price.gh_price_name AS gh_price_name', 'gh_price.goods_id AS goods_id', 'gh_price.ser_id AS ser_id', 'gh_price.remarks', 'gh_price.create_time AS create_time', 'supply_price', 'brand_name', 'pj_goods.pg_series AS pg_series', 'pj_goods.version AS version', 'company_name')
                ->orderBy('gh_price.id', 'DESC')
                ->limit($pageSize)
                ->get();
        }
        return ['list' => $list, 'totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list'];
        //按钮-添加
        $all_button = BmmcService::wherebutton($token, $priID);
        $addPt = BmmcService::getTopButton('addGhprice', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮

        if (!$list->isEmpty()) {
            $list = $list->toArray();
            foreach ($list as $kl => $vl) {
                if ($vl["ser_id"] == 0) {
                    $list[$kl]["company_name"] = "统一价格";
                }
                if ($vl['pg_series'] == "") {
                    $list[$kl]['type'] = $vl['version'];
                } else {
                    $list[$kl]['type'] = $vl['pg_series'] . '-' . $vl['version'];
                }

                $button = BmmcService::getListButton(['editGhprice, delGhPrice'], $all_button);//编辑，删除按钮
                $list[$kl]['button_one'] = $button['button_one'] ?? [];
                $list[$kl]['button_two'] = $button['button_two'] ?? [];
                $list[$kl]['button_three'] = $button['button_three'] ?? [];
            }
            $data['list'] = $list;
        }

        return $data;
    }

    public static function getPrice($id)
    {
        $res = GhPrice::where('gh_price.id', $id)
            ->leftJoin('pj_goods', 'pj_goods.pg_id', '=', 'gh_price.goods_id')
            ->leftJoin('admin', 'admin.id', '=', 'gh_price.ser_id')
            ->select('gh_price.id', 'gh_price.goods_id', 'gh_price.ser_id', 'remarks', 'supply_price', 'company_name', 'brand_name', 'pg_series', 'version')
            ->first()
            ->toArray();
        if ($res['pg_series'] == "") {
            $res['goods_number'] = $res['brand_name'] . '-' . $res['version'];
        } else {
            $res['goods_number'] = $res['brand_name'] . '-' . $res['pg_series'] . '-' . $res['version'];
        }

        return $res;
    }

    /**
     * 检查系统是不是已经存在这个价格设置
     *
     * @param $supplierID
     * @param $goodsID
     * @return mixed
     */
    public static function checkExistPrice($supplierID, $goodsID,$company_id)
    {
        $exist = GhPrice::where('goods_id', $goodsID)
            ->where('ser_id', $supplierID)
            ->where('company_id', $company_id)
            ->exists();

        if ($exist) {
            return true;
        }

        return false;
    }
    /**
     * 获取服务商的指定商品签约价
     *
     * @param int $supplierID 用户id
     * @param int $goodsID 商品id
     * @param array $select 待查询字段
     * @param int $p_id 待查询字段
     * @return mixed
     */
    public static function findPrice($supplierID, $goodsID , $select = [],$p_id)
    {
        $pt_id_arr = PlatformService::getPtIdByPtType();
        $type = 'first';
        if(in_array($p_id, $pt_id_arr)){
            $db = new GhXPrice();
        }else {
            $db = new GhPrice();
        }
        if(count($select) == '1'){
            $type = 'value';
        }
        $exist = CommonService::getMysqlData($db, ['goods_id'=>$goodsID,'ser_id'=>$supplierID],$select,['id'=>'DESC'],$type);
        if ($exist) {
            return $exist;
        } else {
            $db = new GhPrice();
            $exist = CommonService::getMysqlData($db, ['goods_id'=>$goodsID,'ser_id'=>0],$select,['id'=>'DESC'],$type);
            return $exist;
        }

        return false;
    }
}
