<?php
namespace App\Http\Controllers\DataSyn;
use App\Http\Controllers\BaseController;
use App\Services\BangdingService;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Models\PjGoods;
use DB;
class BangdingController extends BaseController
{

/**|---------------------------------------------------------------------------------
 * @name  非京东商品绑定 >> 列表页
 * @param pt_id       平台id
 * @param goods_name  商品名称
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 11:48
 * |---------------------------------------------------------------------------------
*/
	public function index(Request $request){
        $input = $request->all();
        $session = $request->get('session_token');
        $list = BangdingService::getList($input,$session);
        if($list['list']){
            return $this->success('获取成功', $list); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
        }
	}

/**|---------------------------------------------------------------------------------
 * @name  添加
 * @param pt_id     平台id
 * @param pt_goods  平台商品名称
 * @param goods_id  商品id
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 14:18
 * |---------------------------------------------------------------------------------
*/
	public function goodsAdd(Request $request){
        $input = $request->only('pt_id','goods_id','pt_goods');
        $checkKey = CommonService::checkKey(['pt_id','goods_id','pt_goods'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }

        $pt_id = (int)$request->input('pt_id');
		$goods_id = (int)$request->input('goods_id');
		$tg_tname = $request->input('pt_goods');
		if($goods_id>0 && $pt_id>0){
			$good_id = PjGoods::where(["pg_id"=>$goods_id])->value('pg_id');
			if($good_id){
				if($pt_id==77){
					$goods = Db::table("th_goods");
				}else if($pt_id==88){
					$goods = Db::table("tm_goods");
				}else if($pt_id==44){
					$goods = Db::table("jd_goods");
				}else{
                    return $this->error('未知匹配平台', ErrorInc::FAILED_PARAM, []);exit;
				}
				$poss['tg_gid'] = $good_id;
				$poss['tg_tname'] = $this->restrict($tg_tname);
				$poss['tg_name'] = $request->get('session_token')['admin_acc'];
				$res = $goods->insert($poss);
				if($res){
                    $content = $poss['tg_gid'].'-'.$poss['tg_tname'].'-'.$poss['tg_name'];
				    $this->insertingLog("添加，","",$content,"非京东商品绑定",$request->ip(), $request->get('session_token')['admin_acc']);
                    return $this->success('添加绑定成功'); exit;
                }else{
                    return $this->error('添加绑定失败', ErrorInc::DATA_EMPTY);exit;
                }
			}else{
                return $this->error('未找到该系统商品', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }

	}

	//去除空格
	public function restrict($str){
		$is_str = array(" ","　","\t","\n","\r","	");
		$is_str_er = array("","","","","","");
		return str_replace($is_str,$is_str_er,$str);
	}


/**|---------------------------------------------------------------------------------
 * @name  编辑
 * @param id        数据id
 * @param pt_id     平台id
 * @param goods_id  商品id
 * @retrun \Illuminate\Http\JsonResponse /multitype:array
 * @author du 2021/8/23 14:11
 * |---------------------------------------------------------------------------------
*/
	public function goodsEdit(Request $request){
        if (!$request->filled('pt_id')||!$request->filled('goods_id')||!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
		$goods_id = (int)$request->input('goods_id');
		$good_id = PjGoods::where(["pg_id"=>$goods_id])->value('pg_id');
		if($good_id){
			$id = (int)$request->input('id');
			$pt_id = (int)$request->input('pt_id',77);
	        switch ($pt_id) {
	        	case 44:
	        		$Db = Db::table('jd_goods');
	        		break;
	        	case 88:
	        		$Db = Db::table('tm_goods');
	        		break;
	        	default:
	        		$Db = Db::table('th_goods');
	        		break;
	        }
	        $res = $Db->where(['tg_id'=>$id])->update(['tg_gid'=>$good_id]);
	        if($res){
                $session = $request->get('session_token');
                $content = "编辑，编辑人：".$session['admin_acc'].",内容(商品id)：".$goods_id;
                $this->insertingLog("编辑，","",$content,"非京东商品绑定",$request->ip(), $session['admin_acc']);
                return $this->success('编辑成功'); exit;
            }else{
                return $this->error('编辑失败', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('未找到该系统商品', ErrorInc::DATA_EMPTY);exit;
        }
	}




}
