<?php

/**
|--------------------------------------------------------------------------
 * 售后服务
|--------------------------------------------------------------------------
| 售后服务处理逻辑
 * @author DouBin
 * @Date: 2021/08/05
 * @Time: 上午 10:16
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Http\Controllers\BaseController;
use App\Models\SettlementList;
use App\Models\StatementsList;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use App\Models\SettlementMoney;
use DB;
use phpDocumentor\Reflection\Types\Self_;

class SettlementService extends Service
{
//    private static $instance;
    private $modelMain = null;

    public function __construct()
    {
        if (!$this->modelMain) $this->modelMain = new SettlementList();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }


    public static function getSettled($order_num) {
        return SettlementList::where('order_num',$order_num)->where('wat_num','!=','')->first();
    }

    public static function getOneByMsgID($msg_id) {
        return SettlementList::where('msg_id', $msg_id)->select('id','ser_id')->first();
    }

    public static function deleteMoney($sem_slid) {
        return SettlementMoney::where('sem_slid', $sem_slid)->delete();
    }

    public static function insertMoney($money) {
        return SettlementMoney::insert($money);
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取列表信息
     * @param array $input 请求参数
     * @param array $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/3 18:10
     * |---------------------------------------------------------------------------------
    */
    public static function getList ( $input , $session ){
        if(!isset($input['state'])){
            return ['Data' => '', 'ErrorMessage' => '查询状态必传', 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }
        //判定查询状态是否在查询范围内
        if(!in_array($input['state'],[0,1,2,10,20,30,31,40,63])){
            return ['Data' => '', 'ErrorMessage' => '参数错误', 'ErrorCode' => ErrorInc::FAILED_PARAM];
        }
        /*---------------------------------------------拼接订单列表查询条件开始-------------------------------------------*/
        $where = [];
        if (!$input['source_type'] || $input['source_type']!=1) {
            $commonwhere = self::getCommonWhere($session);
            if($commonwhere) {
                foreach ($commonwhere as $k => $v) {
                    $where[$k] = $v;
                }
            }
        }else{
            if (!isset($input['wat_num'])){
                return ['Data' => '', 'ErrorMessage' => '缺少结算单号', 'ErrorCode' => ErrorInc::FAILED_PARAM];
            }
            $statements = StatementsListService::getStatementsListBy('stl_wat', $input['wat_num'],['stl_category','stl_type']);
            $stl_type = $statements['stl_type'];
            $stl_category = $statements['stl_category'];
        }
        $statuswhere = self::getStatusWhere($input['state']);
        foreach( $statuswhere as $k => $v ){
            $where[$k] = $v;
        }

        if (isset($input['mouth_pay'])){
            if($input['state']==2&&$input['mouth_pay']==2) {
            }else{
                $where['mouth_pay'] = $input['mouth_pay'];
            }
        }

        if (isset($input['p_id'])){
            $where['p_id'] = $input['p_id'];
        }
        if (isset($input['ser_id'])){
            $where['ser_id_searchin'] = $input['ser_id'];
        }
        if (isset($input['shr_name'])){
            $where['shr_name_rlike'] = $input['shr_name'];
        }
        if (isset($input['shr_phone'])){
            $where['shr_phone_rlike'] = $input['shr_phone'];
        }
        if (isset($input['order_num'])){
            $where['order_num_rlike'] = $input['order_num'];
        }
        if (isset($input['wat_num'])){
            $where['wat_num_rlike'] = $input['wat_num'];
        }
        if (isset($input['list_id'])){
            $where['list_id_rlike'] = $input['list_id'];
        }

        //订单状态
        if (isset($input['list_service_type'])){
            $where['list_service_type'] = $input['list_service_type'];
        }
        /*---------------------------------------------拼接订单列表查询条件结束-------------------------------------------*/
        $db = new SettlementList();
        $db = $db->leftJoin('user','user.id','=','settlement_list.customer_id');
        //if($input['state'] == 2){
        $db = $db->leftJoin('admin','admin.id','=','settlement_list.ser_id');
       // }



        $where = CommonService::jointWhere($where);
        $page_size = $input['page_size']??10;

       // echo $where;exit;

       // DB::connection()->enableQueryLog();#开启执行日志
        $paginate = $db->whereRaw($where)->select('settlement_list.*','shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress','mouth_pay');
        if (isset($input['source_type']) && $input['source_type']==1 && $stl_category!=3){
            $paginate = $paginate->orderBy("all_price",'ASC');
        }
        $paginate = $paginate->orderBy('create_time','ASC')->paginate($page_size);
       // print_r(DB::getQueryLog());

        $is_excel = $input['is_excel']??'0';
        if ($is_excel == 1) {

        }else{
            $data['showcount'] = self::getStatusBar($session);//获取操作权限可展示订单状态栏
                $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
            if (!$input['source_type'] || $input['source_type']!=1) {
                $export = BmmcService::getTopButton('export', 'creactSettle', $all_button);
            }else{
                if($stl_type =='4'){
                    $export = BmmcService::getTopButton('', 'suppleSubmits', $all_button);
                }
                if($stl_type =='5'){
                    $export = BmmcService::getTopButton('', 'submit_mers', $all_button);
                }
            }

            $data['list_service_name'] = OrderService::getOrderStatusName(false);
            $data['mouth_pays'] = ServiceProviderService::getMouthPay();

            $data['button_top'] = $export['button_top']??[];//顶部按钮
            $data['button_search'] = $export['button_search']??[];//搜索栏按钮
            $list = CommonService::dataToArray($paginate->items());
            if($list) {
                $list = self::jointListData($input,$session,$list,$all_button);//获取列表信息明细说明
                $data['list'] = $list;
            }else{
                $data['list'] = [];
            }
            $data['page'] = [
                'count' => $paginate->total(),
                'page' => $paginate->currentPage(),
                'page_size' => $page_size,
                'allPage' => $paginate->lastPage()
            ];
            return ['Data' => $data, 'ErrorMessage' => '参数错误', 'ErrorCode' => 1];
        }
    }

    /**
     * 拼接列表数据
     * @param string $session 用户信息
     * @param array $input 请求数据
     * @param array $list 订单数据
     * @param array $all_button 按钮信息
     * @return /multitype:array
     * @author dou 2021年9月4日
     */
    public static function jointListData ( $input , $session , $list , $all_button ){
        /*-------------------------------------------------获取列表中平台信息开始-----------------------------------------*/
        $p_id = array_column($list, 'p_id');
        $p_id = array_unique($p_id);
        $pt_name = PlatformService::getAll(true,'id');
        /*-------------------------------------------------获取列表中平台信息结束-----------------------------------------*/
        /*-------------------------------------------------获取列表中门店信息开始-----------------------------------------*/
        $ser_id = array_column($list, 'ser_id');
        $ser_id = array_unique($ser_id);
        $company_name = AdminsService::getAdmins(['id_searchin'=>$ser_id],['id','company_name'],['id'=>'ASC']);
        $company_name = CommonService::jointArrayKey($company_name, 'id');
        /*-------------------------------------------------获取列表中门店信息结束-----------------------------------------*/
        $goodpic = PjBrandsService::getAllPic('name');//获取商品品牌图片 放在此处减少循环调取次数
        $list_service_name = OrderService::getOrderStatusName();
        $sett_status_name = self::getSettStatus();
        $get_mouth_pays = ServiceProviderService::getMouthPay(true);
        foreach($list as $k => $v){
            $list[$k]['mouth_pay_name'] = $get_mouth_pays[$v['mouth_pay']];
            /*---------------------------------------------拼接列表需要展示按钮开始---------------------------------------*/
            $buttonData = [];
            $buttonData[] = 'remarks';
            if (($v['sett_status'] == 1) && ($v['locked']==1)){
                $buttonData[] ='EditEntry';//审核
            }
            if (!$input['source_type'] || $input['source_type']!=1){
                $buttonData[] = 'editReceipts';
                if (($v['sett_status'] == 63) && ($v['locked']==1) && ($v['mouth_pay'] == 2)){
                    $buttonData[] = 'EditEntry1';//编辑
                }
                if ($v['sett_status'] == 63){//审核驳回
                    $buttonData[] = 'shut_down';
                }
                if (($v['sett_status'] == 1) || ($v['sett_status']==10)){//作废
                    $buttonData[] = 'editInvalid';
                }
                if($v['sett_status'] == 40){
                    $buttonData[] = 'deeditInvalid';//恢复
                }
            }else{
                if (($v['sett_status'] == 63) && ($v['locked']==1)){
                    $buttonData[] = 'EditEntry1';//编辑
                }
            }
            $button = BmmcService::getListButton($buttonData,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];
            /*---------------------------------------------拼接列表需要展示按钮结束---------------------------------------*/
            $list[$k]['company_name'] = $company_name[$v['ser_id']]['company_name']??'未匹配';
            $list[$k]['pt_name'] = $pt_name[$v['p_id']]['pt_name']??'未匹配';
            $list[$k]['sett_status_name'] = $sett_status_name[$v['sett_status']]??'待确定';
            $list[$k]['list_service_name'] = $list_service_name[$v['list_service_type']]??'待确定';
            /*---------------------------------------获取订单商品明细信息开始---------------------------------------------*/
            $orderMsg = OrderService::getOrderMsg('',$goodpic,$v['msg_id']);
            $list[$k]['appoint_code'] = $orderMsg['appoint_code'];
            $list[$k]['send_sms'] = $orderMsg['send_sms'];
            $list[$k]['orderMsgArr'] = $orderMsg;
            /*---------------------------------------获取订单商品明细信息结束---------------------------------------------*/
        }
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取类表状态数量
     * @param int $status 结算单状态
     * @param array $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/4 12:04
     * |---------------------------------------------------------------------------------
    */
    public static function getStatusNum ( $status , $session ){
        if(in_array($status,[2,63,10])){
            $db = new SettlementList();
            if($status == 2){
                $db = $db->leftJoin('admin','admin.id','=','settlement_list.ser_id');
            }
            $where = [];
            $commonwhere = self::getCommonWhere($session);
            if($commonwhere){
                foreach( $commonwhere as $k => $v ){
                    $where[$k] = $v;
                }
            }
            $statuswhere = self::getStatusWhere($status);
            foreach( $statuswhere as $k => $v ){
                $where[$k] = $v;
            }
            $num = CommonService::getMysqlData($db,$where,[],[],'count');
            $num = $num??'0';
            return $num;
        }else{
            return '--';
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取操作权限可展示结算单状态栏信息
     * @param array $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/4 13:58
     * |---------------------------------------------------------------------------------
     */
    public static function getStatusBar ( $session , $type = ''){

        $showcount = [
            ['show_name'=>"未审核",'shownum'=>'--','status'=>1],
            ['show_name'=>"零散未审核",'shownum'=>'--','status'=>2],
            ['show_name'=>"已审核",'shownum'=>'--','status'=>63],
            ['show_name'=>"待确认账单",'shownum'=>'--','status'=>10],
            ['show_name'=>"待结算账单",'shownum'=>'--','status'=>20],
          //  ['show_name'=>"未安装预结算",'shownum'=>'--','status'=>31],
            ['show_name'=>"已结算",'shownum'=>'--','status'=>30],
            //['show_name'=>"作废订单",'shownum'=>'--','status'=>40]
        ];

        if( $type == '1'){
            foreach( $showcount as $k => $v ){
                $showcount[$k]['shownum'] = self::getStatusNum($v['status'],$session);
            }
        }
        return $showcount;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取公用查询条件
     * @param array $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/4 12:26
     * |---------------------------------------------------------------------------------
    */
    public static function getCommonWhere ( $session ){
        if($session['admin_groupnew']==2){
            $where['ser_id'] = $session['id'];
        }
        if ($session['admin_groupnew'] != 7){//管理员可以看全部
            $where['gone_settlement_list.company_id'] = $session['company_id'];
        }
        if(!in_array($session['admin_groupnew'],[7,8])){
            $where['p_id_searchin'] = $session['admin_pt_id'];
        }

        return $where;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取状态查询条件
     * @param string $status 查询状态
     * @retrun /multitype:array
     * @author dou 2021/9/4 12:37
     * |---------------------------------------------------------------------------------
    */
    public static function getStatusWhere ( $status ){
        $where = [];
        switch ( $status ){
            case 1:
                $where['sett_status'] = 1;
                break;
            case 2:
                $where['sett_status'] = 1;
                $where['mouth_pay'] = 2;
                break;
            case 10:
                $where['sett_status'] = 10;
                break;
            case 20:
                $where['sett_status'] = 20;
                break;
            case 30:
                $where['sett_status'] = 30;
                break;
            case 31:
                $where['sett_status'] = 30;
                $where['list_service_type'] = 30;
                break;
            case 40:
                $where['sett_status'] = 40;
                break;
            case 63:
                $where['sett_status'] = 63;
                break;
            default:
                ;
                break;
        }
        return $where;
    }

    /**|---------------------------------------------------------------------------------
     * @name 根据指定条件获取结算单数据
     * @param string $key 键
     * @param string $value 值
     * @param array $select 待查询参数
     * @param string $type 待查询参数
     * @retrun multitype:array
     * @author dou 2021/8/9 23:21
     * |---------------------------------------------------------------------------------
    */
    public static function getSettlementListBy ( $key , $value , $select = [] , $type = 'get' ){
        $db = new SettlementList();
        if(in_array($key, ['id','list_id'])){
            $type = 'first';
        }
        if( $type == 'first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, [$key=>$value],$select,[],$type);
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算单金额
     * @param array $params 查询条件
     * @param array $select 待查询参数
     * @param string $type 待查询参数
     * @retrun /multitype:array
     * @author dou 2021/9/3 10:00
     * |---------------------------------------------------------------------------------
    */
    public static function getSettlementMoney ( $params , $select = [] , $type = 'get' ){
        $db = new SettlementMoney();
        if( $type == 'first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, $params,$select,[],$type);
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 根据条件获取结算单信息
     * @param array $params 查询条件
     * @param array $select 待查询参数
     * @param string $type 查询类型
     * @retrun /multitype:array
     * @author dou 2021/9/2 19:38
     * |---------------------------------------------------------------------------------
    */
    public static function getSettlementList ( $params , $select = [] , $type = 'get' ){
        $db = new SettlementList();
        if( $type == 'first' && count($select) == 1){
            $type = 'value';
        }
        $list = CommonService::getMysqlData($db, $params,$select,[],$type);
        return $list;
    }
     /**|---------------------------------------------------------------------------------
      * @name 获取金额详情
      * @param array/string $id 数据id
      * @param string $list_service_type 结算单状态
      * @retrun  /multitype:array
      * @author dou 2021/8/6 11:54
      * |---------------------------------------------------------------------------------
     */
    public static function getPriceById ( $id , $list_service_type = '' ){
        $db = new SettlementMoney();
        if(is_array($id)){
            $where['sem_slid_searchin'] = $id;
        }else{
            $where['sem_slid'] = $id;
            if($list_service_type == '55'){
                $where['sem_type'] = 4;
            }
            if($list_service_type != '55' && $list_service_type){
                $where['sem_type_noteq'] = 4;
            }
        }
        $lable = LabtypeService::labelList();
        $lable = CommonService::jointArrayKey($lable,'sety_id');
        $list = CommonService::getMysqlData($db,$where,['sem_id','sem_slid','sem_price','sem_type'],['sem_id'=>'ASC']);
        foreach($list as $k => $v){
            $list[$k]['sem_name'] = $lable[$v['sem_type']]['sety_name']??"未确认";
        }
        if(is_array($id)){
            $list = CommonService::jointArrayKey($list,'sem_slid',2);
        }else{
            if($list) {
                $all_price = array_column($list, 'sem_price');
                $list['all_price'] = sprintf('%.2f',array_sum($all_price));
            }
        }
        return $list;
    }

    /**
     *
     * @param  $sem_slid
     * @param  $sem_synum
     * @param  $sem_price
     * @param  $sem_creacter
     * @param  $sem_type
     * @return /multitype:array
     * @author du 2021年7月31日下午1:57:45
     */
    public static function createSettMoney($sem_slid,$sem_synum,$sem_price,$sem_creacter,$sem_type){
    	$money['sem_slid'] = $sem_slid;
    	$money['sem_synum'] = $sem_synum;
    	$money['sem_price'] =  (double)$sem_price;
    	$money['sem_creacter'] = $sem_creacter;
    	$money['sem_type'] = $sem_type;
    	$money['add_time'] = date("Y-m-d H:i:s");

    	$res = SettlementMoney::insert($money);
    	return $res;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算状态
     * @retrun /multitype:array
     * @author dou 2021/9/4 16:08
     * |---------------------------------------------------------------------------------
    */
    public static function getSettStatus (  ){
        return array('1'=>'未审核','10'=>'未结算','20'=>'结算中','30'=>'已完成','40'=>'已作废','50'=>'已追回');
    }

    /**|---------------------------------------------------------------------------------
     * @name 删除结算单标签
     * @param string $input 请求参数
     * @param string $ip 操作人ip
     * @param string $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/4 18:07
     * |---------------------------------------------------------------------------------
    */
    public static function deletPrice ( $input , $ip ,$session ){
        if(isset($input['sem_slid']) && isset($input['sem_type'])){
            $money = self::getSettlementMoney(['sem_type'=>$input['sem_type'],'sem_slid'=>$input['sem_slid']],['sem_price'],'first');
            if($money!==null){
                DB::beginTransaction(); //开启事务
                try{
                    $SettlementList = self::getSettlementListBy('id', $input['sem_slid'], ['wat_num', 'all_price','list_id','sys_num']);
                    $res=SettlementMoney::where(['sem_type'=>$input['sem_type'],'sem_slid'=>$input['sem_slid']])->delete();
                    if($money == 0){
                        $ree = 1;
                        $rea = 1;
                    }else {
                        $wat_num = $SettlementList['wat_num'];
                        $all_price = $SettlementList['all_price'];
                        $poss['all_price'] = $all_price - $money;
                        $stl_money = StatementsListService::getStatementsListBy('stl_wat', $wat_num, ['stl_money']);
                        if ($stl_money) {
                            $possa['stl_money'] = sprintf("%.2f", $stl_money - $money);
                            $ree = StatementsList::where('stl_wat', $wat_num)->update($possa);
                        } else {
                            $ree = 1;
                        }
                        $rea = SettlementList::where('id', $input['sem_slid'])->update($poss);
                    }
                    if($res && $rea && $ree){
                        DB::commit();//提交
                        $BaseController = new BaseController();
                        $Lab = LabtypeService::getLable('sety_id',$input['sem_type']);
                        $Lab = $Lab[0]['sety_name']??$input['sem_type'];
                        $avtion = FunctionsService::getFunctionsBy('function_id', $input['Pri_id'], ['function_name']);
                        $centent = '';
                        if($wat_num){
                            $centent .= '结算单：'.$wat_num.',';
                        }
                        $centent .= '标签:'.$Lab."(".$SettlementList['list_id'].")(".$money.")";
                        $BaseController->insertingLog('删除明细金额，',$SettlementList['sys_num'],$centent,$avtion,$ip,$session['admin_acc']);//日志
                        return ['Data' => [], 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
                    }else{
                        DB::rollback();//回滚
                        return ['Data' => [], 'ErrorMessage' => '操作失败', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
                    }

                }catch(\Exception $e){
                    DB::rollback();//回滚
                    return ['Data' => [], 'ErrorMessage' => $e->getMessage(), 'ErrorCode' => ErrorInc::SERVER_FAILED];
                }
            }else{
                return ['Data' => [], 'ErrorMessage' => '无数据', 'ErrorCode' => ErrorInc::DATA_EMPTY];
            }
        }else{
            return ['Data' => [], 'ErrorMessage' => '缺少参数', 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加结算单明细金额
     * @param string $input 请求参数
     * @param string $ip 操作人ip
     * @param string $session 操作人信息
     * @retrun /multitype:array
     * @author dou 2021/9/7 11:56
     * |---------------------------------------------------------------------------------
    */
    public static function insertPrice ( $input , $ip ,$session ){
        $checkKey=CommonService::checkKey(['money_data', 'sem_slid', 'sem_synum'],$input,['money_data'=>'新增标签']);
        if($checkKey['code']!=1){
            return ['Data' => [], 'ErrorMessage' => '参数'.$checkKey['data'].'未填写,或值为空', 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }
        $money_data=$input['money_data'];
        $SettlementList = self::getSettlementListBy('id', $input['sem_slid'], ['wat_num', 'all_price','list_id','sys_num','sett_status']);
        $BaseController = new BaseController();
        $avtion = FunctionsService::getFunctionsBy('function_id', $input['Pri_id'], ['function_name']);
        foreach( $money_data as $k => $v ){
            $centent = '';
            if($SettlementList['wat_num']){
                $centent .= '结算单：'.$SettlementList['wat_num'].',';
            }
            if($v['sem_type']=='1'){
                $sem_price=$v['sem_price'];
            }
            $res=SettlementMoney::whereRaw("sem_slid='".$input['sem_slid']."' and sem_type='".$v['sem_type']."'")->value('sem_price');
            //新接口编辑已经分离，改判定避免数据异常
            if($res!==null){
                $poss[$k]['sem_price']=sprintf("%.2f",$v['sem_price']);
                $rea=SettlementMoney::whereRaw("sem_slid='".$input['sem_slid']."' and sem_type='".$v['sem_type']."'")->update($poss[$k]);
                if($rea){
                    $centent .= "编辑".$v['sety_name'].'金额：'.$res.'->'.$v['sem_price']."(".$SettlementList['list_id'].")";
                    $BaseController->insertingLog('编辑金额，',$input['sem_synum'],$centent,$avtion,$ip,$session['admin_acc']);//日志
                }
            }else{
                $rea = self::createSettMoney($input['sem_slid'], $input['sem_synum'], sprintf("%.2f",$v['sem_price']), $session['admin_acc'], $v['sem_type']);
                if($rea){
                    $centent .= "添加".$v['sety_name'].'金额：'.$v['sem_price']."(".$SettlementList['list_id'].")";
                    $BaseController->insertingLog('添加金额，',$input['sem_synum'],$centent,$avtion,$ip,$session['admin_acc']);//日志
                }
            }
        }
        $rae=SettlementMoney::whereRaw("sem_slid='".$input['sem_slid']."'")->sum('sem_price');

        if($rae==$input['all_price']){
            if(isset($sem_price)) {
                $posa['order_price'] = $sem_price;
                SettlementList::whereRaw("id='" . $input['sem_slid'] . "'")->update($posa);
            }
            $post['all_price']=$input['all_price'];
            if($SettlementList['sett_status']!=63) {
                $posa['sett_status'] = 63;
                SettlementList::where('id', $input['sem_slid'])->update($posa);
            }
            $centent = '';
            if($SettlementList['wat_num']){
                $centent .= '结算单：'.$SettlementList['wat_num'].',';
            }
            if($SettlementList['all_price']==$input['all_price']){
                $centent .= "编辑总金额成功：".$input['all_price']."(".$SettlementList['list_id'].")";
                $BaseController->insertingLog('编辑金额，',$input['sem_synum'],$centent,$avtion,$ip,$session['admin_acc']);//日志
                return ['Data' => [], 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
            }else{
                $money=SettlementList::whereRaw("id='".$input['sem_slid']."'")->update($post);
                if($money){
                    $centent .= "编辑总金额成功：".$SettlementList['all_price'].'->'.$input['all_price']."(".$SettlementList['list_id'].")";
                    if($SettlementList['wat_num']) {
                        $all_price1 = SettlementList::whereRaw("wat_num='" . $SettlementList['wat_num'] . "' and list_service_type!=55")->sum('all_price');
                        $all_price2 = SettlementList::whereRaw("wat_num='" . $SettlementList['wat_num'] . "' and list_service_type=55")->sum('subsidy_money');
                        $possa['stl_money'] = sprintf("%.2f", $all_price1 + $all_price2);
                        StatementsList::whereRaw("stl_wat='" . $SettlementList['wat_num'] . "'")->update($possa);
                    }
                    $BaseController->insertingLog('编辑金额，',$input['sem_synum'],$centent,'月结报表',$avtion,$ip,$session['admin_acc']);//日志
                    return ['Data' => [], 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
                }else{
                    return ['Data' => [], 'ErrorMessage' => '总金额计算错误', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
                }
            }
        }else{
            return ['Data' => [], 'ErrorMessage' => '总金额计算错误', 'ErrorCode' => ErrorInc::REQUEST_FORBIDDEN];
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 编辑结算单标签金额
     * @param string $input 请求参数
     * @param string $ip 操作人ip
     * @param string $session 操作人信息
     * @retrun  /multitype:array
     * @author dou 2021/9/7 17:02
     * |---------------------------------------------------------------------------------
    */
    public static function updatePrice ( $input , $ip ,$session ){
        $checkKey=CommonService::checkKey(['sem_id', 'sem_price', 'sem_slid','sety_name'],$input);
        if($checkKey['code']!=1){
            return ['Data' => [], 'ErrorMessage' => '参数'.$checkKey['data'].'未填写,或值为空', 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }
        $price = self::getSettlementMoney(['sem_id'=>$input['sem_id']],['sem_price'],'first');
        $SettlementList = self::getSettlementListBy('id', $input['sem_slid'], ['wat_num', 'all_price','list_id','sys_num']);
        DB::beginTransaction(); //开启事务
        $result = SettlementMoney::where('sem_id',$input['sem_id'])->update(['sem_price' => $input['sem_price']]);
        $all_money = SettlementMoney::where('sem_slid',$input['sem_slid'])->sum('sem_price');
        $results = SettlementList::where('id',$input['sem_slid'])->update(['all_price' => $all_money]);
        if ($result && $results) {
            DB::commit();
            $centent = '';
            if($SettlementList['wat_num']){
                $centent .= '结算单：'.$SettlementList['wat_num'].',';
                $all_price1 = SettlementList::whereRaw("wat_num='" . $SettlementList['wat_num'] . "' and list_service_type!=55")->sum('all_price');
                $all_price2 = SettlementList::whereRaw("wat_num='" . $SettlementList['wat_num'] . "' and list_service_type=55")->sum('subsidy_money');
                $possa['stl_money'] = sprintf("%.2f", $all_price1 + $all_price2);
                StatementsList::whereRaw("stl_wat='" . $SettlementList['wat_num'] . "'")->update($possa);
            }
            $avtion = FunctionsService::getFunctionsBy('function_id', $input['Pri_id'], ['function_name']);
            $BaseController = new BaseController();
            $centent .="标签名称:".$input['sety_name'].",金额：".$price."->".$input['sem_price']."(".$SettlementList['list_id'].")";
            $BaseController->insertingLog('编辑金额，',$SettlementList['sys_num'],$centent,$avtion,$ip,$session['admin_acc']);//日志
            return ['Data' => [], 'ErrorMessage' => '操作成功', 'ErrorCode' => 1];
        } else {
            DB::rollback();
            return ['Data' => [], 'ErrorMessage' => '操作失败', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
        }
    }
}
