<?php
namespace App\Http\Controllers\Orders;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Services\OrderService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Models\SerInfor;
use App\Services\SerInforService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\CommonService;
use App\Models\Admin;
/**
 * @name 催单管理
 * Class SerInforController
 * @package App\Http\Controllers\Orders
 */
class SerInforController extends BaseController
{

	/**
	 * @name 列表
     * @param sin_state 分类状态 1:未处理; 2:已处理; 3:已审核
     * @param sys_num   系统单号
     * @param order_num 平台单号
     * @param p_id       平台名称(ID)
     * @param order_status 订单状态 1:新订单; 5:处理中; 10:可派单; 20:已派单; 30:安装中; 34:待完成; 40:已完成; 50:已撤销;
     * @param admin_id  经手人员(id)
     * @param start_time 开始时间
     * @param end_time   结束时间
     * @param shr_name   客户姓名
     * @param shr_phone  客户电话
     * @param shr_sheng  省
     * @param shr_shi    市
	 * @param Request $request
	 * @return \BlueCity\Core\Controllers\mixed
	 * @author du 2021年8月7日下午3:43:31
	 */
    public function index (Request $request)
    {
        if (!in_array($request->input('sin_state'),[0,1,2,3])){
        	return $this->error('参数错误sin_state', ErrorInc::FAILED_PARAM);exit;
        }
        $input = $request->all();
   		$list = SerInforService::getSerList($input,$request->get('session_token'));
        //导出 start
        /*if ($input['is_excel'] == 1) {
            $sqls = $list['sqls'];
            $excel = new CommonController();
            return $excel->getExcelOut($input['Pri_id'], $sqls, $request->get('session_token'));
        }
        unset($list['sqls']);*/
        //导出 end
    	if($list['list']){
	    	return $this->success('获取成功', $list); exit;
    	}else{
	    	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}

    }



    /**|---------------------------------------------------------------------------------
     * @name 处理催单获取标
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * |---------------------------------------------------------------------------------
     */
 /*    public function labtype (Request $request)
    {
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        $list = SetmoneyType::whereRaw("lt_parent_id=79 and FIND_IN_SET(".$admin_groupnew.",lt_group)")->select('sety_name','sety_id')->get();
        if (!$list->isEmpty()){
            return response()->json(['data'=>$list->toArray(),'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['data'=>'','ErrorCode'=>2,'ErrorMessage'=>'暂无标签']);exit;
        }

    } */


    /**
     * @name 催单处理
     * @param sin_id  数据id
     * @param sety_id 标签
     * @param sin_centent  备注内容
     * @param sys_num  系统单号
     * @param order_num 平台单号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月7日下午4:15:22
     */
    public function rOrder (Request $request)
    {
        $session_token = $request->get('session_token');
        if(!$request->filled('sety_id')||!$request->filled('sin_id')){
        	return $this->error('参数错误无sety_id或无sin_id', ErrorInc::FAILED_PARAM);exit;
        }
        $data['sin_bid'] = $request->input('sety_id');

        $poss['sin_centent'] = $request->input('sin_centent');
        $rest = CommonService::accMe($request->input('sys_num'),'催单管理',"催单管理，".$poss['sin_centent'],$request->input('order_num'),'2',$session_token['admin_groupnew'],$session_token['admin_acc'],$session_token['id']);

        $data['sin_state'] = 2;
        $data['sin_lastime'] = date('Y-m-d H:i:s');
        $data['sin_dealtime'] = date('Y-m-d H:i:s');
        $data['sin_dealer'] = $session_token['admin_name'];
        $data['sin_centent'] = $request->input('sin_centent');
        $res = SerInfor::where(['sin_id'=>$request->input('sin_id'),'sin_sysnum'=>$request->input('sys_num')])->update($data);
        if($res){
            $this->insertingLog('催单处理，',$request->input('sys_num'),'订单('.$request->input('order_num').')','催单管理',$request->ip(),$session_token['admin_acc']);//日志
            $this->operatingTime($request->input('order_num'),'催单管理时间',date("Y-m-d H:i:s"),$request->input('note_centent'),$request->input('order_num'),$session_token['admin_acc']);//订单操作时间
            return $this->success('处理成功',$data);exit;
        }else{
        	return $this->error('处理失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name 审核订单
     * @param id 数据id号
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月7日下午4:23:24
     */
    public function reminder (Request $request)
    {
        if (!$request->filled('sin_id')){
           return $this->error('参数错误无sin_id', ErrorInc::FAILED_PARAM);exit;
        }
        $db = new SerInfor();
        $params = ['sin_id'=>$request->input('sin_id')];
        $select = ['sin_state','sin_sysnum'];
        $sin = CommonService::getMysqlData($db, $params,$select,[],'first');
        if($sin['sin_state'] == 2){
            $id = SerInfor::where('sin_id',$request->input('sin_id'))->update(['sin_state'=>3]);
            if($id){
                $this->insertingLog("审核，",$sin['sin_sysnum'],"审核催单","催单管理",$request->ip(),$request->get('session_token')['admin_acc']);
                return $this->success('审核成功');exit;
            }else{
            	return $this->error('审核失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
        	return $this->error('该订单状态错误，请核实', ErrorInc::MYSQL_FAILED);exit;
        }
    }


    /**
     * @name  催单排行
     * @param array dateTime 时间
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月7日下午5:13:23
     */
    public function reminderSort (Request $request)
    {
        //$time = [date('Y-m-d H:i:s').' 00:00:00', date('Y-m-d H:i:s').'23:59:59'];
        if ($request->filled('dateTime')) {
            $datetime = $request->input('dateTime');
            $datetime = [$datetime[0].' 00:00:00', $datetime[1].' 23:59:59'];
        } else {
            $datetime = [date('Y-m-d').' 00:00:00', date('Y-m-d').' 23:59:59'];
        }
        $session = $request->get('session_token');
        if ($session['admin_groupnew'] != 7){//管理员可以看全部
            $list = SerInfor::whereBetween('sin_creactime',$datetime)->selectRaw("count(sin_id) as num, sin_serid")->groupBy('sin_serid')->where('company_id',$session['company_id'])->orderBy('num','DESC')->get();
        }else{
            $list = SerInfor::whereBetween('sin_creactime',$datetime)->selectRaw("count(sin_id) as num, sin_serid")->groupBy('sin_serid')->orderBy('num','DESC')->get();//->limit(50)
        }

        if (!$list->isEmpty()) {
            $list = $list->toArray();
            $Admins = Admin::where('admin_groupnew',2)->pluck('company_name','id')->toArray();
            foreach ($list as $k => $v) {
                if (isset($Admins[$v['sin_serid']])) {
                    $list[$k]['company_name'] = $Admins[$v['sin_serid']];
                }
            }
            return $this->success('获取成功',$list);exit;
        } else {
        	return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
            exit;
        }

    }

    /**
     * @name 快捷催单
     * @param Request $request
     * @return array|int[]
     * @author du
     * @date 2022/1/4
     */
    public function  fastRemind(Request $request){
        $input = $request->all();
        $orderInfo = OrderService::getOrderBy('order_num', $input['order_num'],['sys_num','ser_id']);
        if(empty($orderInfo)){
            return $this->error('订单不存在', ErrorInc::MYSQL_FAILED);exit;
        }
        $input['sys_num'] = $orderInfo['sys_num'];
        $input['ser_id'] = $orderInfo['ser_id']??0;
        $input['reminder'] = 1;
        $session = $request->get("session_token");
        $ip = $request->ip();
        $data = SerInforService::remind($input, $session, $ip);
        return $data;
    }

    /**
     * @name 获取催单信息
     * @param Request $request
     * @return array
     * @author du
     * @date 2022/1/4
     */
    public function getRemindInfo(Request $request){
        $orderInfo = OrderService::getOrderBy('order_num', $request->input('order_num'),['sys_num','lock_type','order_status']);
        if(empty($orderInfo)){
            return $this->error('订单不存在', ErrorInc::MYSQL_FAILED); exit;
            //$this->error('订单不存在', ErrorInc::MYSQL_FAILED);exit;
        }
        if($orderInfo['order_status']<20){
            return $this->error('未派单不可催单', ErrorInc::MYSQL_FAILED); exit;
            //$this->error('订单不存在', ErrorInc::MYSQL_FAILED);exit;
        }
        $data = SerInforService::remindInfo($orderInfo['sys_num']);
        $Data['list'] = $data['Data'];
        $Data['lock_type'] = $orderInfo['lock_type'];
        if($orderInfo['lock_type']==2){
            $Data['msg'] = '此单已锁定，请确认是否继续催单';
        }else{
            $Data['msg'] = '';
        }
        $data['Data'] = $Data;
        return $data;
    }

    /**
     * @param Request $request
     * @return array|string|string[]
     * @author du
     * @date 2022/2/11
     */
    public function sendSmsSerInfoModel(Request $request){
        $input = $request->all();
        $session = $request->get("session_token");
        $ret = CommonService::sendMsgCommonModel($input, $session);
        return $ret;
    }

}
