<?php
/**
 * F6索赔服务
 * @author dong 2022年2月9日11:42:08
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use BlueCity\Core\Service\Service;
use App\Models\F6ClaimList;
class F6ClaimService extends Service{

    /**
	 * 添加F6索赔
	 * @return boolean
	 * @author dong 2022年2月9日13:42:46
	 */
    public static function insertData ($data){
        $add_data = [];
        $add_data['order_id'] = $data['order_id'];   //属性名
        $add_data['goods_name'] = implode(',',$data['goods_name']);   //商品名称
        $add_data['p_id'] = $data['p_id'];   //平台id
        $add_data['label'] = implode(',',$data['label']);   //标签
        $add_data['remark'] = $data['remark'];   //索赔备注
        $add_data['claim_amount'] = $data['claim_amount'];   //索赔金额
        $add_data['result_state'] = 1;   //状态新申请
        $add_data['create_time'] = date('Y-m-d H:i:s');   //添加时间
        $res = F6ClaimList::insert($add_data);
   	    return $res;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取列表顶部状态
     * @param string $group 操作人权限
     * @param string $admin_pt_id 可操作平台信息
     * @param string $type 是否查询数据量1是
     * @retrun /multitype:array
     * @author dou 2022/2/11 11:25
     * |---------------------------------------------------------------------------------
    */
    public static function getResultStatusBar ( $type = '2' ){
                $showcount = [
                    ['showname' => "全部", 'shownum' => '--','status'=>0],
                    ['showname' => "新申请", 'shownum' => '--','status'=>1],
                    ['showname' => "已开票", 'shownum' => '--','status'=>2],
                    ['showname' => "已打款", 'shownum' => '--','status'=>3],
                    ['showname' => "已撤销", 'shownum' => '--','status'=>4]
                ];
                if( $type == '1'){
                    foreach( $showcount as $k => $v ){
                        $showcount[$k]['shownum'] = self::getResultStatusNum($v['status']);
                    }
                }
                return $showcount;
            }
            /**|---------------------------------------------------------------------------------
             * @name 获取指定状态订单数量
             * @param string $status 状态栏参数
             * @retrun /multitype:array
             * @author dou 2022/2/11 11:32
             * |---------------------------------------------------------------------------------
            */
            public static function getResultStatusNum ( $status){
                if(in_array($status,[1,2,3,4])){
                    $db = new F6ClaimList;
                    $num = CommonService::getMysqlData($db,['result_state'=>$status],[],[],'count');
                    $num = $num??'0';
                    return $num;
                }else{
                    return '--';
                }
            }

}
