<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
class OrderNormal extends Model
{
    //指定表名
    protected $table ='order_normal';//已安装表 模型
    // 拒绝添加的字段
    protected $guarded = [];
    public $timestamps=false;


    /**|---------------------------------------------------------------------------------
     * @name  模型及搜索条件
     * @param $ser_id      服务商id
     * @param $date_time   时间
     * @param $brand_name  商品品牌
     * @param $p_id        平台id
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    private function sql ($ser_id,$date_time,$brand_name,$p_id)
    {
        $info = Self::when($ser_id,function($query)use($ser_id){
            $query->where('ser_id',$ser_id);
        })->when($brand_name,function ($query)use($brand_name){
            $query->where('brand_name',$brand_name);
        })->when($date_time,function($query)use($date_time){
            $query->whereBetween('order_time',[$date_time[0]." 00:00:00",$date_time[1]." 23:59:59"]);
        })->when($p_id,function($query)use($p_id){
            $query->where('p_id',$p_id);
        });
        return $info;
    }



    //数据罗盘已安装订单
    /**|---------------------------------------------------------------------------------
     * @name   已完成订单（单号）
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function ordernum($param)
    {
        //$a = Temporary::pluck('serial_number')->toArray();

        //$install_id = $param['install_id']??"";
        /*if (empty($param['date_time'])){
            return response()->json(['Data' => '', 'ErrorCode' => 3, 'ErrorMessage' => '请选择下单时间']);
            exit;
        }*/
        $p_id = $param['p_id']??"";
        $ser_id = $param['ser_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;


        $count = $this->sql($ser_id,$date_time,$brand_name,$p_id)->count();//总数

        //->whereIn('order_state',['34,40'])
        $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->orderBy('order_time','DESC')->offset($offset)->limit($page_size)->get();


        $header = ["平台","平台单号","工单号","下单时间","派单时间","响应时效","安装时效","品牌","产品线","型号","数量"];
        $data['header'] = $header;
        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k => $v){
                if ($v['order_type'] == 1){
                    $v['order_type_name'] = "普通";
                }elseif ($v['order_type'] == 10){
                    $v['order_type_name'] = "夜间";
                }elseif ($v['order_type'] == 15){
                    $v['order_type_name'] = "40分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "60分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "90分钟";
                }elseif ($v['order_type'] == 30){
                    $v['order_type_name'] = "120分钟";
                }
                //接单时效
                if (!empty($v['acceptance_time']) && !empty($v['order_time']) && $v['acceptance_time'] != "0000-00-00 00:00:00" && $v['order_time'] != "0000-00-00 00:00:00"){
                    $list[$k]['xy_time'] = $this->Compute_Time($v['acceptance_time'],$v['order_time']);
                }else{
                    $list[$k]['xy_time'] = "";
                }

                //完成时效
                if (!empty($v['acceptance_time']) && !empty($v['end_time']) && $v['acceptance_time'] != "0000-00-00 00:00:00" && $v['end_time'] != "0000-00-00 00:00:00"){
                    $list[$k]['az_time'] = $this->Compute_Time($v['end_time'],$v['acceptance_time']);
                }else{
                    $list[$k]['az_time'] = "";
                }

            }
            $data['list'] = $list;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);
        }else{
            return response()->json(['Data'=>$data,'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }

    }



    /**|---------------------------------------------------------------------------------
     * @name  已完成订单（地址）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function province_model ($param)
    {

        $p_id = $param['p_id']??"";
        //$live_name = $param['live_name']??"";
        $shr_sheng = $param['shr_sheng']??"";
        $shr_shi = $param['shr_shi']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $ser_id = $param['ser_id']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;

        if ($shr_sheng!=''){
            if($shr_shi=='' && !in_array($shr_sheng,["北京","北京市","天津","天津市","上海","上海市","重庆","重庆市"])){
                $sums = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->sum('goods_num');
                $list_two = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->groupBy('shr_shi')->selectRaw("shr_shi as area,count('id') as num")->get();
                $count = $list_two->count();
                $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng',$shr_sheng)->groupBy('shr_shi')->orderBy('num','DESC')->orderBy('shr_sheng','ASC')->selectRaw("shr_shi as area,count('id') as num")->offset($offset)->limit($page_size)->get();
            }else{
                $sums = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->sum('goods_num');

                $list_two = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->selectRaw("shr_xian as area,count('id') as num")->groupBy('shr_xian')->orderBy('num','DESC')->get();

                $count = $list_two->count();
                $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where(['shr_sheng'=>$shr_sheng,'shr_shi'=>$shr_shi])->selectRaw("shr_xian as area,count('id') as num")->groupBy('shr_xian')->orderBy('num','DESC')->orderBy('shr_sheng','ASC')->offset($offset)->limit($page_size)->get();
            }

        }else{

            $sums = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->sum('goods_num');
            $list_two = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->groupBy('shr_sheng')->orderBy('num','DESC')->orderBy('shr_sheng','ASC')->selectRaw("shr_sheng as area,count('id') as num")->get();
            $count = $list_two->count();

            $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->where('shr_sheng','!=','')->groupBy('shr_sheng')->orderBy('num','DESC')->orderBy('shr_sheng','ASC')->selectRaw("shr_sheng as area,count('id') as num")->offset($offset)->limit($page_size)->get();


        }

        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                $list[$k]['round'] = round($v['num']/$sums*100,2);
                $list[$k]['index'] = $offset+$k+1;
            }
            $list_two = $list_two->toArray();
            foreach ($list_two as $ks=>$vs){
                $list_two[$ks]['round'] = round($vs['num']/$sums*100,2);
            }
            $data['list'] = $list;
            $data['list_two'] = $list_two;
            $data['page'] = [
                'sum' => $sums,
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }

    }



    /**|---------------------------------------------------------------------------------
     * @name  已完成订单（服务商）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function ser_model ($param)
    {
        $p_id = $param['p_id']??"";//平台id
        $date_time = $param['date_time']??[];//时间
        $brand_name = $param['brand_name']??"";//品牌名称
        $ser_id = $param['ser_id']??"";//服务商id
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        //$info =$this->sql($ser_id,$date_time,$brand_name,$p_id);
        $serid = Admin::pluck('company_name','id')->toArray();
        $sums = $this->sql($ser_id,$date_time,$brand_name,$p_id)->sum('goods_num');
        $list_two = $this->sql($ser_id,$date_time,$brand_name,$p_id)->selectRaw("ser_id,count('id') as num")->groupBy('ser_id')->get();
        $count = $list_two->count();
        $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->groupBy('ser_id')->orderBy('num','DESC')->orderBy('ser_id','ASC')->selectRaw("ser_id,count('id') as num")->offset($offset)->limit($page_size)->get();


        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                $list[$k]['company_name'] = $serid[$v['ser_id']];
                $list[$k]['round'] = round($v['num']/$sums*100,2);
                $list[$k]['index'] = $offset+$k+1;
                $chart[$k]['company_name'] = $serid[$v['ser_id']];
                $chart[$k]['num'] = $v['num'];
            }
            /*$list_two = $list_two->toArray();
            foreach ($list_two as $ks => $vs){
                $chart[$ks]['company_name'] = $serid[$vs['ser_id']];
                $chart[$ks]['num'] = $vs['num'];
            }*/
            $data['list'] = $list;
            $data['chart'] = $chart;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  已完成订单（平台）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function pt_model ($param)
    {
        $p_id = $param['p_id']??"";//平台id
        $date_time = $param['date_time']??[];//时间
        $brand_name = $param['brand_name']??"";//品牌名称
        $ser_id = $param['ser_id']??"";//门店id
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;

        //$serid = Admin::pluck('company_name','id')->toArray();
        $sums = $this->sql($ser_id,$date_time,$brand_name,$p_id)->sum('goods_num');
        $list_two = $this->sql($ser_id,$date_time,$brand_name,$p_id)->groupBy('p_id')->orderBy('num','DESC')->orderBy('p_id','ASC')->selectRaw("p_id,pt_name,count('id') as num")->get();
        $count = $list_two->count();

        $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->groupBy('p_id')->orderBy('num','DESC')->orderBy('p_id','ASC')->selectRaw("p_id,pt_name,count('id') as num")->offset($offset)->limit($page_size)->get();

        //$list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->groupBy("p_id")->selectRaw("id,p_id,pt_name,count('id') as num")->get();


        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                $list[$k]['round'] = round($v['num']/$sums*100,2);
                $chart[$k]['pt_name'] = $v['pt_name'];
                $chart[$k]['num'] = $v['num'];
                $list[$k]['index'] = $offset+$k+1;
            }
            /*$list_two = $list_two->toArray();
            foreach ($list_two as $ks => $vs){
                $chart[$ks]['pt_name'] = $vs['pt_name'];
                $chart[$ks]['num'] = $vs['num'];
            }*/
            $data['list'] = $list;
            $data['chart'] = $chart;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);exit;
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    /**|---------------------------------------------------------------------------------
     * @name  已完成订单（详情）
     * @param $param
     * @return \Illuminate\Http\JsonResponse
     * @author he <2019>
     * |---------------------------------------------------------------------------------
     */
    public function detail_model ($param)
    {
        $p_id = $param['p_id']??"";
        $date_time = $param['date_time']??[];
        $brand_name = $param['brand_name']??"";
        $ser_id = $param['ser_id']??"";
        $page = $param['page']?? 1;
        $page_size = $param['page_size']?? 10;
        if ($page < 1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $info =$this->sql($ser_id,$date_time,$brand_name,$p_id);

        $count = $this->sql($ser_id,$date_time,$brand_name,$p_id)->count();//总数
        $list = $this->sql($ser_id,$date_time,$brand_name,$p_id)->orderBy('order_time','DESC')->offset($offset)->limit($page_size)->get();
        $serid = Admin::pluck('company_name','id')->toArray();
        $certification = Certification::where('certification_num','!=',null)->pluck('certification_num','ser_id')->toArray();
        if (!$list->isEmpty()){
            $list = $list->toArray();
            foreach ($list as $k => $v){
                if ($v['order_type'] == 1){
                    $v['order_type_name'] = "普通";
                }elseif ($v['order_type'] == 10){
                    $v['order_type_name'] = "夜间";
                }elseif ($v['order_type'] == 15){
                    $v['order_type_name'] = "40分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "60分钟";
                }elseif ($v['order_type'] == 20){
                    $v['order_type_name'] = "90分钟";
                }elseif ($v['order_type'] == 30){
                    $v['order_type_name'] = "120分钟";
                }
                if (empty($v['pg_series'])){
                    $list[$k]['goods_information'] = $v['brand_name'].'-'.$v['version'];
                }else{
                    $list[$k]['goods_information'] = $v['brand_name'].'-'.$v['pg_series'].'-'.$v['version'];
                }
                $list[$k]['user_information'] = $v['shr_sheng'].$v['shr_shi'].$v['shr_xian'];

                if (isset($serid[$v['ser_id']])){
                    $list[$k]['company_name'] = $serid[$v['ser_id']];
                }else{
                    $list[$k]['company_name'] = "暂无";
                }
                if(isset($certification[$v['ser_id']])){
                    $list[$k]['certification_num'] = $certification[$v['ser_id']];
                }else{
                    $list[$k]['certification_num'] = "";
                }
                //接单时效
                if (!empty($v['acceptance_time']) && !empty($v['order_time'])){
                    $list[$k]['xy_time'] = $this->Compute_Time($v['acceptance_time'],$v['order_time']);
                }else{
                    $list[$k]['xy_time'] = "";
                }

                //完成时效
                if (!empty($v['acceptance_time']) && !empty($v['end_time']) && $v['acceptance_time'] != "0000-00-00 00:00:00" && $v['end_time'] != "0000-00-00 00:00:00"){
                    $list[$k]['az_time'] = $this->Compute_Time($v['end_time'],$v['acceptance_time']);
                }else{
                    $list[$k]['az_time'] = "";
                }

            }
            $data['list'] = $list;
            $data['page'] = [
                'count' => $count,
                'page'  => $page,
                'page_size' => $page_size,
                'allPage'  => ceil($count/$page_size)
            ];
            return response()->json(['Data'=>$data,'ErrorCode'=>1,'ErrorMessage'=>'成功']);
        }else{
            return response()->json(['Data'=>[],'ErrorCode'=>2,'ErrorMessage'=>'暂无数据']);
        }
    }



    //计算时间差
    private function Compute_Time($begin_time,$end_time){
        if($begin_time < $end_time){
            $starttime = $begin_time;
            $endtime = $end_time;
        }else{
            $starttime = $end_time;
            $endtime = $begin_time;
        }
        //计算天数
        $timediff = strtotime($endtime)-strtotime($starttime);
        $days = intval($timediff/86400);
        //计算小时数
        $remain = $timediff%86400;
        $hours = intval($remain/3600);
        //计算分钟数
        $remain = $remain%3600;
        $mins = intval($remain/60);
        //计算秒数
        $secs = $remain%60;
        //$res = array("day" => $days,"hour" => $hours,"min" => $mins,"sec" => $secs);
        $res = $days.'天'.$hours.'时'.$mins.'分'.$secs.'秒';
        return $res;
    }

}
