<?php

namespace App\Http\Requests\Validators\Api\MobileWeb;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 移动端-账单列表
class ServiceEvaluationValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return false;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'admin_id.required' => '请输入服务商id',
            'admin_id.integer' => '参数错误',
            'type.required' => '请输入type值',
            'type.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'admin_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in([1, 2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
