<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Models\Aftercust;
use App\Models\OrderAfter;
use App\Models\OrderAftertrack;
use App\Models\OrderList;
use App\Models\Refund;
use App\Models\SendGoods;
use App\Services\BmmcService;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;
use App\Models\SerInfor;
class TipsController extends BaseController
{

    /**
     * @name  消息提醒
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/10
     */
    public function index(Request $request){
        if($request->get('session_token')['admin_groupnew'] == 2 || $request->get('session_token')['admin_groupnew'] == 3){
            $orderList = OrderList::where('stauas',20)->where('ser_id',$request->get('session_token')['id'])->get();
            if(count($orderList)>0) {
                $list[0]['msg'] = "您有新工单未领取";
                $list[0]['count'] = count($orderList);
                $list[0]['orderList'] = $orderList;
                $list[0]['url'] = 'Ordersystem/OrderList';
            }else{
                $list = [];
            }
            return $this->success('获取成功', $list); exit;
        }
        $date = time();
        $time = mktime(17,0,0,date('m'),date('d'),date('Y'));
        $eight =  $date -'28800';
        $eight = date('Y-m-d H:i:s',$eight);
        $twelve =  $date -'43200';
        $twelve = date('Y-m-d H:i:s',$twelve);
        $sendtime =  $date -'86400';
        $sendtime = date('Y-m-d H:i:s',$sendtime);
        $sertime =  $date -'1200';
        $admin_pt_id = $request->get('session_token')['admin_pt_id'];
        $sertime = date('Y-m-d H:i:s',$sertime);
        $looktime = $date -'3600';
        $looktime = date('Y-m-d H:i:s',$looktime);
        $where = "sin_type=1 AND gone_orders.reminder=1 AND gone_orders.is_delete=2 and gone_orders.p_id in (".$admin_pt_id.")";
        $wxnum = Db::table('ser_master')->where('follow','5')->count();
        CommonService::startmysql();
        $aftertrack = OrderAftertrack::where("oat_state",1)->where('oat_looktime','<',$looktime)->count();
        $aftercust = Aftercust::where('afc_state','1')->count();
        if($date <= $time){
            $refund = Refund::where('created_at','<=',$eight )->where('state','0')->count();
            $Aftersale = OrderAfter::where('create_time','<=',$twelve )->where('status','1')->count();
            $sendorders = SendGoods::where('time','<=',$sendtime )->where('type','<=','2')->count();
            $Db = SerInfor::join('orders','orders.sys_num','=','ser_infor.sin_sysnum')->leftJoin('user','user.id','=','orders.customer_id')->whereRaw($where);
            if($request->get('session_token')['admin_groupnew']!=7){
                $Db =  $Db->where('orders.company_id',$request->get('session_token')['company_id']);
            }
            $ser_infor = $Db->where('sin_state','1')->where('orders.order_status','<',34)->count();
        }else{
            $refund = Refund::where('state','0')->count();
            $Aftersale = OrderAfter::where('status','1')->count();
            $sendorders = SendGoods::where('time','<=',$sendtime )->where('type','<=','2')->count();
            $Db = SerInfor::join('orders','orders.sys_num','=','ser_infor.sin_sysnum')->leftJoin('user','user.id','=','orders.customer_id')->whereRaw($where);
            if($request->get('session_token')['admin_groupnew']!=7){
                $Db =  $Db->where('orders.company_id',$request->get('session_token')['company_id']);
            }
            $ser_infor = $Db->where('sin_state','1')->where('orders.order_status','<',34)->count();
        }
        $massage_power = $request->input('massage_power');
        $function = explode(',',$massage_power);
        $list = array();
        $num = 0;
        foreach ($function as $key => $value) {
            if($function[$key] == 1 && $Aftersale != 0){
                $list[$num]['msg'] = "你有新的售后单未处理";
                $list[$num]['count'] = $Aftersale;
                $list[$num]['url'] = 'AftersaleService/AftersaleOrder';
                $num++;
            }
            if($function[$key] == 2 && $refund != 0){
                $list[$num]['msg'] = "你有新的退款单未处理";
                $list[$num]['count'] = $refund;
                $list[$num]['url'] = 'Ordersystem/refund';
                $num++;
            }
            if($function[$key] == 3 && $aftercust != 0){
                $list[$num]['msg'] = "你有新的电话沟通单未处理";
                $list[$num]['count'] = $aftercust;
                $list[$num]['url'] = 'Ordersystem/aftercust';
                $num++;
            }
            if($function[$key] == 4 && $sendorders != 0){
                $list[$num]['msg'] = "你有新的发货单未处理";
                $list[$num]['count'] = $sendorders;
                $list[$num]['url'] = 'Ordersystem/SendGoods';
                $num++;
            }
            if($function[$key] == 5 && $ser_infor != 0){
                $list[$num]['msg'] = "你有新的催单未处理";
                $list[$num]['count'] =$ser_infor;
                $list[$num]['url'] = 'Ordersystem/SerInfor';
                $num++;
            }
            if($function[$key] == 6 && $wxnum != 0){
                $list[$num]['msg'] ="你有新的微信绑定消息未同步";
                $list[$num]['count'] =$wxnum;
                $list[$num]['url'] ='Basicdata/WxBinding';
                $num++;
            }
            if($function[$key] == 7 && $aftertrack != 0){
                $list[$num]['msg'] ="您有售后追踪将到期";
                $list[$num]['count'] =$aftertrack;
                $list[$num]['url'] ='AftersaleOrder/searchAftertrack';
                $num++;
            }
        }
        if($list){
            return $this->success('获取成功', $list); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**
     * @name  消息提醒列表
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function msgIndex(Request $request){
        $Db = Db::table('department');
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        $Db = $Db->leftjoin('massage_power','massage_power.admin_groupnew','=','department.id');
        if( $admin_groupnew != 7 ){
            $Db = $Db->whereRaw(" FIND_IN_SET (".$admin_groupnew.",bmmc_pids)");
        }
        $list = $Db->where('massage_power.admin_groupnew','!=','2')->select('massage_power.bmmc_name','massage_power.admin_name','massage_power.admin_groupnew','massage_power.id','massage_power.function','massage_power.time')->get()->toArray();

        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('updateUser,addUser','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮

        foreach($list as $k=>$v){
            $buttonData = [];
            $function = explode(',',$list[$k]['function']);
            $function_a = array();
            foreach ($function as $key => $value) {
                if($function[$key] == 1){
                    $function_a['0']['name'] = "售后服务";
                    $function_a['0']['id'] = "1";
                }
                if($function[$key]  == 2){
                    $function_a['1']['name'] = "退款管理";
                    $function_a['1']['id'] = "2";
                }
                if($function[$key]  == 3){
                    $function_a['2']['name'] = "电话沟通";
                    $function_a['2']['id'] = "3";
                }
                if($function[$key]  == 4){
                    $function_a['3']['name'] = "处理发货";
                    $function_a['3']['id'] = "4";
                }
                if($function[$key]  == 5){
                    $function_a['4']['name'] = "处理催单";
                    $function_a['4']['id'] = "5";
                }
                if($function[$key]  == 6){
                    $function_a['5']['name'] = "微信绑定";
                    $function_a['5']['id'] = "6";
                }
                if($function[$key]  == 7){
                    $function_a['5']['name'] = "售后追踪";
                    $function_a['5']['id'] = "7";
                }
            }
            $function_a = CommonService::resetListKey($function_a);
            $list[$k]['function'] = $function_a;

            $buttonData[] = 'reset,updateOne';
            $button = BmmcService::getListButton($buttonData,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];

        }
        $data['list'] = $list;
        if($data){
            return $this->success('获取成功', $data); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**
     * @name 获取用户
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function addUser(Request $request){
        $Db = Db::table('department');
        $Db = $Db->where('enable','1');
        $admin_groupnew = $request->get('session_token')['admin_groupnew'];
        if($request->get('session_token')['admin_groupnew']==7){
            $department = $Db->leftjoin('admin', 'admin.admin_groupnew', '=', 'department.id')->where('admin.admin_groupnew', '!=', '2')->select('bmmc_name', 'admin_name', 'admin_groupnew', 'admin.id')->get()->toArray();
        }else {
            $department = $Db->leftjoin('admin', 'admin.admin_groupnew', '=', 'department.id')->whereRaw(" FIND_IN_SET (" . $admin_groupnew . ",bmmc_pids)")->where('admin.admin_groupnew', '!=', '2')->select('bmmc_name', 'admin_name', 'admin_groupnew', 'admin.id')->get()->toArray();
        }
        $massage_power = Db::table('massage_power')->select('bmmc_name','admin_name','admin_groupnew','id')->get()->toArray();
        foreach($department as $k=>$v) if(in_array($v, $massage_power)) unset($department[$k]);
        $department = array_values($department);
        if($department){
            return $this->success('获取成功',$department);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
    }

    /**
     * @name  获取消息通知类型
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/10
     */
    public function messageName(Request $request){
        $res['function']['0'] = array('function'=>'1','name'=>'售后服务');
        $res['function']['1'] = array('function'=>'2','name'=>'退款管理');
        $res['function']['2'] = array('function'=>'3','name'=>'电话沟通');
        $res['function']['3'] = array('function'=>'4','name'=>'处理发货');
        $res['function']['4'] = array('function'=>'5','name'=>'处理催单');
        $res['function']['5'] = array('function'=>'6','name'=>'微信绑定');
        $res['function']['6'] = array('function'=>'7','name'=>'售后追踪');
        return $this->success('获取成功',$res);exit;
    }

    /**
     * @name 执行添加
     * @param adminData array [bmmc_name,admin_name,admin_groupnew,id]
     * @param newData array[bmmc_name,admin_name(ID),admin_groupnew]
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function addUserDo(Request $request){
        if(!$request->filled('adminData')||!$request->filled('newData')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $user = $request->input('adminData');
        $level = $request->input('newData');
        $function = implode(',',$level);
        foreach ($user as $key => $value) {
            $user[$key]['function'] = $function;
            $user[$key]['time'] = date('Y-m-d H:i:s');
        }
        $massage_power = Db::table('massage_power')->insert($user);
        if($massage_power){
            return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  单个编辑用户
     * @param newData  权限array[bmmc_name,admin_name(ID),admin_groupnew]
     * @param id       用户id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function updateUser(Request $request){
        if(!$request->filled('id')||!$request->filled('newData')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $user = intval($request->input('id'));
        $level = $request->input('newData');
        $function = implode(',',$level);
        $update['function'] = $function;
        $massage_power = Db::table('massage_power')->where('id',$user)->update($update);
        if($massage_power){
            return $this->success('单个编辑成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  重置用户
     * @param id       用户id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function reset(Request $request){
        if(!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $user = intval($request->input('id'));
        $update['function'] = "";
        $massage_power = Db::table('massage_power')->where('id',$user)->update($update);
        if($massage_power){
            return $this->success('重置成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  多个编辑用户
     * @param array newData [bmmc_name,admin_name(ID),admin_groupnew]
     * @param array  list_id 用户id组
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/11
     */
    public function updateUserDo(Request $request){
        if(!$request->filled('list_id')||!$request->filled('newData')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $user = $request->input('list_id');
        $newData = $request->input('newData');
        $function['function'] = implode(',',$newData);
        foreach ($user as $key => $value){
            $massage_power = Db::table('massage_power')->where('id',$user[$key])->update($function);
        }
        if($massage_power){
            return $this->success('编辑成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }


}
