<?php
/**
 * 文件名称（自动拒单）
 * 文件简单描述（权限基础操作权限）
 * @author DouBin
 * @Date: 2024/8/7
 * @Time: 11:46
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\Api;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Orders\AotuorderController;
use App\Http\Controllers\Orders\OrderListController;
use App\Models\OrderList;
use App\Services\CommonService;
use Illuminate\Http\Request;
use DB;


class SynOrderRejectedController extends BaseController
{
    public function rejectedOrder ( ){
        if('08:30:00'<date("H:i:s") && '18:00:00'>date("H:i:s")){
            $time_start = date("Y-m-d H:i:s", strtotime(" -15 minute" . date("Y-m-d H:i:s")));
            $list = OrderList::where('stauas', '20')->where('ol_distype', '>', 1)->where('ol_distype', 2)->whereIn('company_id', [12, 14])->where('create_time', '<', $time_start)->select('id', 'order_num', 'sys_num', 'serial_number')->limit(10)->get();
            $list = CommonService::dataToArray($list);
            $id = [];
            $num = 0;
            $data = [];
            if (!empty($list)) {
                $OrderListController = new OrderListController();
                $Autom = new AotuorderController();
                foreach ($list as $k => $v) {
                    if (!empty($id) && in_array($v['id'], $id)) {

                    } else {
                        $db = new OrderList;
                        $params = ['sys_num' => $v['sys_num']];
                        $select = ['order_num', 'sys_num', 'serial_number', 'stauas', 'ser_id', 'p_id', 'order_goods_id', 'store_type', 'ol_dispamount', 'customer_id'];
                        $orderBy = ['stauas' => 'DESC'];
                        $orderListArrs = CommonService::getMysqlData($db, $params, $select, $orderBy);
                        if (!$orderListArrs) {
                            $data[$num]['order_num'] = $v['order_num'];
                            $data[$num]['content'] = '数据异常';
                            $num++;
                        } else {
                            $serial_number = array_column($orderListArrs, 'serial_number');
                            $stauas = array_column($orderListArrs, 'stauas');
                            $orderListArr = $orderListArrs[0];
                            $hasPositive = array_filter($stauas, function ($value) {
                                return $value > 20;
                            });
                            if (count($hasPositive) > 0) {
                                $data[$num]['order_num'] = $v['order_num'];
                                $data[$num]['content'] = '存在接单数据';
                                $num++;
                                OrderList::where('id', $v['id'])->update(['ol_distype' => 0]);
                            } else {
                                $rest = CommonService::accMe($v['sys_num'], '系统拒单', "拒单，超十五分钟未结单", $v['serial_number'] . "等", '1', 8, '系统录入', '1133');//添加备注
                                $input['or_centent'] = '超过15分钟未结单';
                                $input['or_show'] = '1';
                                $input['sys_num'] = $v['sys_num'];
                                $input['setmoney_type'] = 30;
                                $input['note_content'] = '超时未接单';
                                $input['type'] = 2;
                                $ret = $OrderListController->refuseOrderOne($serial_number, $orderListArr, $input, '系统录入', $v['id'], '127.0.0.1');
                                if ($ret == 2) {
                                    $data[$num]['order_num'] = $v['order_num'];
                                    $data[$num]['content'] = '操作成功';
                                    $weixin['ser_id'] = $orderListArr['ser_id'];
                                    $weixin['order_num'] = $orderListArr['order_num'];
                                    $weixin['goods_name'] = '超时未接单';//$v['goods_name'];
                                    $weixin['serial_number'] = $orderListArr['serial_number'];
                                    CommonService::requestPost('http://zptzchat.bluearp.com/m/index.php/BindingAccount/push_order_rejected', $weixin);
                                    $info = $Autom->Distrib($v['sys_num'], '127.0.0.1');
                                    $num++;
                                } else {
                                    if (is_array($ret)) {
                                        $data[$num]['order_num'] = $v['order_num'];
                                        $data[$num]['content'] = '操作失败：' . $ret['ErrorMessage'] . "(" . $ret['ErrorCode'] . ")";
                                        $num++;
                                    } else {
                                        $data[$num]['order_num'] = $v['order_num'];
                                        $data[$num]['content'] = '操作失败：';
                                        $num++;
                                    }
                                }
                            }
                        }
                    }
                }
                CommonService::addLog('自动拒单', json_encode($data, JSON_UNESCAPED_UNICODE), '', 'rejectedOrder');
            } else {
                CommonService::addLog('自动拒单', '无数据', '', 'rejectedOrder');
            }
        }else {
            CommonService::addLog('自动拒单', '非指定时间段08:30:00-18:00:00', '','rejectedOrder');
        }
    }
}
