<?php

namespace App\Exports;

class ServiceProviderExport extends Export
{
    protected $sheetName; //sheet title
    protected $data;
    protected $headings;

    protected $columnWidth = [];//设置列宽       key：列  value:宽
    protected $rowHeight = [];  //设置行高       key：行  value:高
    protected $mergeCells = []; //合并单元格    value:A1:K8
    protected $font = [];       //设置字体       key：A1:K8  value:Arial
    protected $fontSize = [];       //设置字体大小       key：A1:K8  value:11
    protected $bold = [];       //设置粗体       key：A1:K8  value:true
    protected $background = []; //设置背景颜色    key：A1:K8  value:#F0F0F0F
    protected $vertical = [];   //设置定位       key：A1:K8  value:center
    protected $borders = []; //设置边框颜色  key：A1:K8  value:#000000
    // 设置需要从库中检索出的字段
    protected static $columns = [
        'id'=>'【序号(不可更改)】',
        'admin_acc'=>'【登录名】',
        'admin_name'=>'【用户名/负责人】',
        'service_area'=>'【服务中心地区】',
        'service_per'=>'【服务中心负责人】',
        'service_name'=>'【服务中心名称】',
        'accountname'=>'【账户名】',
        'opeaccline'=>'【开户行】',
        'account'=>'【账户】',
        'type'=>'【结算类型】',
        'invoice'=>'【发票(0不能开1增票2普票)】',
        'admin_province'=>'【服务区域(省)】',
        'admin_city'=>'【服务区域(市)】'
    ];

    public function __construct($data, $headings = [], $sheetName = '服务商列表')
    {
        parent::__construct($data, $headings, $sheetName);
    }

    // headings方法,提供文件头部信息内容
    public function defineHeader($columns)
    {
        $headers = [];
        foreach ($columns as $key => $column) {
            if ($this->columns[$column]) {
                $headers[$column] = $this->columns[$column];
            }
        }

        $this->headings = $headers;
    }
    //业务代码
    public function createData()
    {
        $tmp = $this->data;
        $data = [];
        foreach ($tmp as $key=>$value) {
            $row = [];
            foreach ($this->headings as $k=>$val) {
                $row[$k] = $value[$k];
            }
            $data[] = $row;
        }
        $this->data = collect($data)->toArray();
    }

}
