<?php
/**
 * 类别服务
 * @author du 2021年7月23日上午9:40:36
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use BlueCity\Core\Service\Service;
use App\Models\GoodsSeries;

class GoodsSeriesService extends Service{


	/**
	 * 获取系列列表
	 * @param int $gs_bid　品牌ＩＤ
	 * @param int $cd_id　品类ＩＤ
	 * @return multitype:
	 * @author du 2021年7月27日下午4:09:36
	 */
	public static function getall($gs_bid,$cd_id,$ids=[],$key='')
	{

		$data = [];
		if(!is_array($ids)){
			return $data;
		}
		$list = RedisService::redisGet('gseriesList'.$gs_bid.$cd_id);
		if ($list) {

			$data = CommonService::filterIds($ids,$list,'gs_id');
		} else {

			$list = GoodsSeries::where('gs_state',1)->where('gs_bid',$gs_bid)->where('cd_id',$cd_id)->select('gs_id','gs_series','gs_brandname')->orderBy('gs_id','DESC')->get();
			$data = CommonService::filterIds($ids,$list,'gs_id');
			RedisService::redisSet('gseriesList'.$gs_bid.$cd_id, $list);
		}
		if($key){

			$data = CommonService::jointArrayKey($data,$key);
		}
		return $data;
	}



}
