<?php
/**
 * 订单接口
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Repository\Interfaces;

use Closure;

interface OrderInterface
{
    /**
     * 根据条件获取订单列表
     * @param array $params
     * @return array|false
     */
    public function getOrders($params);

    /**
     * 根据订单ID获取订单详细内容
     * @param int $orderId 订单ID
     * @return array|false
     */
    public function getOrderByID($orderId);

    /**
     * 根据订单编号获取订单详细内容
     * @param int $orderNO 订单NO
     * @return array|false
     */
    public function getOrderByNO($orderNO);

    /**
     * 创建新订单
     * @param mixed $data 订单数据
     * @param Closure $callBack 订单生成后续操作
     * @return mixed 订单id或者生成失败false
     */
    public function create($data, Closure $callBack);

    /**
     * 更新订单详细内容
     * @param int $orderID 订单id
     * @param array $data 订单数据
     * @param Closure $callBack 订单生成后续操作
     * @return bool
     */
    public function update($orderID, $data, Closure $callBack);

    /**
     * 对订单进行操作动作
     * @param string $event 进行的操作
     * @param int $orderID 操作订单id
     * @param array $data 订单数据
     * @param Closure $callBack 订单生成后续操作123
     * @return bool
     */
    public function event($event, $orderID, $data, Closure $callBack);

    /**
     * 取消订单
     * @param int $orderID 订单id
     * @param Closure $callBack 订单取消后续操作
     * @return bool 是否成功
     */
    public function cancel($orderID, Closure $callBack);

    /**
     * 检测订单是否处于允许编辑状态
     * @param int $orderID 订单id
     *
     * @return bool 是/否允许
     */
    public function editable($orderID);
}
