<?php
/**
 * 文件名称（开户行号管理）
 * 文件简单描述（管理门店结算的使用到的开户行的银行编号）
 * @author DouBin
 * @Date: 2022/6/7
 * @Time: 18:17
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Models\AdminKhaccount;
use BlueCity\Core\Service\Service;
use BlueCity\Core\Inc\ErrorInc;
use DB;

class KhAccountService extends Service{
    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param array $input
     * @param array $session
     * @retrun /multitype:array
     * @author dou 2022/6/7 18:23
     * |---------------------------------------------------------------------------------
    */
    public static function getList($input,$session){
        $db = new AdminKhaccount();
        if(in_array($input['state'],[1,2])){
            $where['aka_type'] = $input['state'];
        }
        if(isset($input['aka_account'])){
            $where['aka_account_rlike'] = $input['aka_account'];
        }
        if(isset($input['aka_name'])){
            $where['aka_name_like'] = $input['aka_name'];
        }
        $page_size = $input['page_size']??10;
        if($where){
            $where = CommonService::jointWhere($where);
            $db = $db->whereRaw($where);
        }
        $paginate = $db->orderBy('aka_id','DESC')->paginate($page_size);
        $data['show_Menu'] = [
            ['show_name'=>"全部",'status'=>'0','show_num'=>'--'],
            ['show_name'=>"启用",'status'=>'1','show_num'=>'--'],
            ['show_name'=>"停用",'status'=>'2','show_num'=>'--']
        ];
        $all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
        $export = BmmcService::getTopButton('addEntry','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮
        $list = CommonService::dataToArray($paginate->items());
        if($list){
            $list = self::getButtonDatas($all_button, $list);
            $data['list'] = $list;
            $data['page'] = [
                'count' => $paginate->total(),
                'page'=>$paginate->currentPage(),
                'page_size'=>$page_size,
                'allPage'=>$paginate->lastPage()
            ];
        }else{
            $data['list'] = [];
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * 获取按钮和数据
     * @param array $all_button
     * @param array $list
     * @return string
     * @author dou 2022/6/7 18:59
     * |---------------------------------------------------------------------------------
    */
    public static function getButtonDatas($all_button,$list){
        $akaTypeName = self::getAkaTypeName(true);
        foreach ($list as $k => $v){
            $button = [];
            $list[$k]['akaTypeName'] = $akaTypeName[$v['aka_type']]??'未定义';
            $button[] = 'editEntry';
            $button = BmmcService::getListButton($button,$all_button);
            $list[$k]['button_one'] = $button['button_one']??[];
            $list[$k]['button_two'] = $button['button_two']??[];
            $list[$k]['button_three'] = $button['button_three']??[];
        }
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取开户行信息
     * @retrun /multitype:array
     * @author dou 2022/6/8 15:34
     * |---------------------------------------------------------------------------------
    */
    public static function getKhAccount ( ){
        $db = new AdminKhaccount();
        $list = CommonService::getMysqlData($db, ['aka_type'=>1],['aka_account','aka_name'],['aka_id'=>'asc']);
        if($list){
            foreach($list as $k => $v){
                $list[$k]['show_name'] = $v['aka_name']."(".$v['aka_account'].")";
            }
        }
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 数据类型
     * @param string $type 数据展示类型
     * @retrun /multitype:array
     * @author dou 2022/6/7 19:00
     * |---------------------------------------------------------------------------------
    */
    public static function getAkaTypeName ( $type = false ){
        $data = [['type'=>1,'name'=>'启用','color'=>''],['type'=>2,'name'=>'停用','color'=>'red']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }
}
