<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::group(['prefix' => 'interface', 'namespace' => 'Api'], function () {//外部接口文件
    Route::post('order/store', 'OrdersController@store'); //订单新增
    Route::post('order/shippingCancel', 'OrdersController@shippingCancel'); //发货取消
    Route::post('order/state', 'OrdersController@state'); //变更状态
    Route::post('order/shipping', 'OrdersController@shipping'); //已发货
    Route::post('order/update', 'OrdersController@update'); //变更信息
    Route::post('order/retrieve', 'OrdersController@retrieve'); //回收成功
    Route::post('order/show', 'OrdersController@show'); //订单详情查看
    Route::post('order/cancel', 'OrdersController@cancel'); //订单取消

    Route::post('order/synRemark', 'OrdersController@synRemark');//库房备注同步
    Route::post('order/getAfterSalesSite', 'OrdersController@getAfterSalesSite');//位置同步
    Route::post('order/getAfterSalesLabs', 'OrdersController@getAfterSalesLabs');//获取标签同步
    Route::post('order/addAfterSales', 'OrdersController@addAfterSales');//添加售后同步
    Route::post('order/getAfterSalesType', 'OrdersController@getAfterSalesType');//获取类型
    Route::post('order/getAfterSalesDetail', 'OrdersController@getAfterSalesDetail');//售后数据展示
    Route::post('order/refundGoods', 'OrdersController@refundGoods');// 退款锁定同步
    Route::post('order/getImgContent', 'OrdersController@getImgContent');//获取售后图文
    Route::post('order/getRefund', 'OrdersController@getRefund');//获取退款
    Route::post('order/updateGood', 'OrdersController@updateGood');//编辑商品信息

    Route::post('order/getPicByRefundId', 'OrdersController@getPicByRefundId');//du add 2022-3-1 获取退款凭证
    Route::post('order/addTmBound', 'OrdersController@addTmBound');//dou add 2022-05-11 添加sku绑定
    Route::post('order/addTmBound', 'OrdersController@addTmBound');//dou add 2022-05-11 添加sku绑定



});

/*Route::group(['prefix' => 'Admin', 'middleware' => 'requestpc','namespace' => 'Admin'], function () {//Admin文件
//    Route::resource('gateway', 'GateWayController', ['as' => 'gateway']);//api权限
    Route::post('salesPrice/index', 'SalesPriceController@index'); //自有平台销售价管理
    Route::post('salesPrice/create', 'SalesPriceController@create'); //自有平台销售价创建界面参数
    Route::post('salesPrice/store', 'SalesPriceController@store'); //自有平台销售价新增
    Route::post('salesPrice/show', 'SalesPriceController@show'); //自有平台销售价详情
    Route::post('salesPrice/edit', 'SalesPriceController@edit'); //自有平台销售价修改界面参数
    Route::post('salesPrice/update', 'SalesPriceController@update'); //自有平台销售价更新数据
    Route::post('salesPrice/delete', 'SalesPriceController@destroy'); //自有平台销售价删除

});*/
Route::group(['prefix' => 'service', 'middleware' => 'requestpc', 'namespace' => 'Service'], function () { //仓库管理
    Route::post('Warehouse/index', 'WarehouseController@index'); //仓库列表
    Route::post('Warehouse/addGoodsNum', 'WarehouseController@addGoodsNum'); //仓库列表
    Route::post('Warehouse/wareGoods', 'WarehouseController@wareGoods'); //仓库商品列表
    Route::post('Warehouse/wareGoodsRecord', 'WarehouseController@wareGoodsRecord'); //仓库商品出入库列表
});
Route::group(['prefix' => 'service', 'namespace' => 'Service'], function () { //服务商类
    Route::post('Pay/notify', 'PayController@notify');//微信支付回调
    Route::any('Pay/aliPayNotify', 'PayController@aliPayNotify');//支付宝支付回调
});
Route::group(['prefix' => 'service', 'middleware' => 'requestpc', 'namespace' => 'Service'], function () { //服务商类
    Route::post('serviceProvider/index', 'ServiceProviderController@index'); //服务供应商管理
    Route::post('serviceProvider/export', 'ServiceProviderController@export'); //服务供应商导出
    Route::get('serviceProvider/downloadFields', 'ServiceProviderController@downloadFields'); //暂时没用
    Route::post('serviceProvider/create', 'ServiceProviderController@create'); //服务供应商创建界面参数
    Route::post('serviceProvider/store', 'ServiceProviderController@store'); //服务供应商新增
    Route::post('serviceProvider/show', 'ServiceProviderController@show'); //服务供应商详情
    Route::post('serviceProvider/edit', 'ServiceProviderController@edit'); //服务供应商修改界面参数
    Route::post('serviceProvider/update', 'ServiceProviderController@update'); //服务供应商更新数据
    Route::post('serviceProvider/delete', 'ServiceProviderController@destroy'); //服务供应商删除
    Route::post('serviceProvider/jingwei', 'ServiceProviderController@jingwei'); //经纬度获取
    Route::post('serviceProvider/bindRadius', 'ServiceProviderController@bindRadius'); //绑定服务区域
    Route::post('serviceProvider/editServicePassword', 'ServiceProviderController@editServicePassword');//修改密码
    Route::post('serviceProvider/getAccountList', 'ServiceProviderController@getAccountList');//查看结算信息
    Route::post('serviceProvider/addOtherAccount', 'ServiceProviderController@addOtherAccount');//添加门店结算账号
    Route::post('serviceProvider/editOtherAccount', 'ServiceProviderController@editOtherAccount');//编辑门店结算账号
    Route::post('serviceProvider/getSettleData', 'ServiceProviderController@getSettleData');//
    Route::post('serviceProvider/addKhAccount', 'ServiceProviderController@addKhAccount');//添加开户行信息

    Route::post('Pay/index', 'PayController@index');//充值扣款记录
    Route::post('Pay/getClientType', 'PayController@getClientType');//获取客户类型
    Route::post('Pay/getPrice', 'PayController@getPrice');//充值获取金额
    Route::post('Pay/getAdminRecharge', 'PayController@getAdminRecharge');//充值获取金额
    Route::post('Pay/recharge', 'PayController@recharge');//充值
    Route::post('Pay/wxpay', 'PayController@wxpay');//微信支付
    Route::post('Pay/aliPay', 'PayController@aliPay');//支付宝支付
    Route::post('Pay/getOrderState', 'PayController@getOrderState');//支付宝支付

    Route::post('activity/AdvanceEnd', 'ActivityController@AdvanceEnd', ['as' => 'activity.end']); //服务供应商活动立即结束
    Route::post('activity/index', 'ActivityController@index'); //服务供应商活动管理管理
//    Route::post('activity/create', 'ActivityController@create'); //服务供应商活动创建界面参数
    Route::post('activity/store', 'ActivityController@store'); //服务供应商活动新增
    Route::post('activity/show', 'ActivityController@show'); //服务供应商活动详情
//    Route::post('activity/edit', 'ActivityController@edit'); //服务供应商活动修改界面参数
    Route::post('activity/update', 'ActivityController@update'); //服务供应商活动更新数据
    Route::post('activity/delete', 'ActivityController@destroy'); //服务供应商活动删除

    Route::post('supplierPrice/index', 'SupplierPriceController@index'); //服务供货价管理(服务商签约价)
    Route::post('supplierPrice/store', 'SupplierPriceController@store'); //服务供货价新增
    Route::post('supplierPrice/edit', 'SupplierPriceController@edit'); //服务供货价修改界面参数
    Route::post('supplierPrice/update', 'SupplierPriceController@update'); //服务供货价更新数据
    Route::post('supplierPrice/delete', 'SupplierPriceController@destroy'); //服务供货价删除

   //du 2022-4-19
    Route::post('supplierXPrice/index', 'SupplierXPriceController@index'); //分销供货价管理
    Route::post('supplierXPrice/store', 'SupplierXPriceController@store'); //分销供货价新增
    Route::post('supplierXPrice/edit', 'SupplierXPriceController@edit'); //分销供货价修改界面参数
    Route::post('supplierXPrice/update', 'SupplierXPriceController@update'); //分销供货价更新数据



    Route::post('setMoneyType/index', 'SetMoneyTypeController@index'); //奖惩金额管理
    Route::post('setMoneyType/store', 'SetMoneyTypeController@store'); //奖惩金额新增
    Route::post('setMoneyType/update', 'SetMoneyTypeController@update'); //奖惩金额更新数据
//    Route::post('setMoneyType/delete', 'SetMoneyTypeController@destroy'); //奖惩金额删除

    Route::resource('contracts', 'ContractsController', ['as' => 'contracts']); //供应商签约管理

    Route::post('subsidy/index', 'SubsidyController@index'); //服务商补贴管理
    Route::post('subsidy/store', 'SubsidyController@store'); //服务商补贴新增
//    Route::post('subsidy/edit', 'SubsidyController@edit'); //服务商补贴修改界面参数
    Route::post('subsidy/update', 'SubsidyController@update'); //服务商补贴更新数据
    Route::post('subsidy/delete', 'SubsidyController@destroy'); //服务商补贴删除
    Route::post('subsidy/Switch', 'SubsidyController@releaseSwitch'); //服务商补贴指定开启关闭
    Route::post('subsidy/SwitchAll', 'SubsidyController@switchAll'); //服务商补贴全停全开启

    Route::post('Negotiated/index', 'NegotiatedController@index'); //协商价格列表
    Route::post('Negotiated/negotiated_deal', 'NegotiatedController@negotiated_deal'); //协商价格审核申请
    Route::post('Negotiated/negotiated_delete', 'NegotiatedController@negotiated_delete'); //协商价格驳回申请
    Route::post('Negotiated/sync_state', 'NegotiatedController@sync_state'); //同步协商价格对应订单信息（状态）
//    Route::post('Negotiated/export', 'NegotiatedController@export'); //协商价格导出数据
});
Route::group(['prefix' => 'platform','middleware' => 'requestpc','namespace' => 'Platform'], function () {//平台类
    Route::post('platform', 'PlatformController@index'); //平台管理
    Route::post('platform/create', 'PlatformController@create'); //平台新增界面
    Route::post('platform/store', 'PlatformController@store'); //平台新增
    Route::post('platform/edit', 'PlatformController@edit'); //平台修改界面
    Route::post('platform/update', 'PlatformController@update'); //平台更新数据
    Route::post('platform/delete', 'PlatformController@destroy'); //平台删除

    Route::post('platform/template', 'PlatformController@template'); //短信模板 2022-4-28
    Route::post('platform/prerecharge', 'PlatformController@prerecharge');//预充值 2022-4-28



    Route::post('platformPrice/index', 'PlatformPriceController@index'); //平台签约售价管理(平台签约价)
    Route::post('platformPrice/store', 'PlatformPriceController@store'); //平台签约售价新增
//    Route::post('platformPrice/edit', 'PlatformPriceController@edit'); //平台签约售价修改界面
    Route::post('platformPrice/update', 'PlatformPriceController@update'); //平台签约售价更新数据
    Route::post('platformPrice/delete', 'PlatformPriceController@destroy'); //平台签约售价删除
    Route::post('platformPrice/setPtPrice', 'PlatformPriceController@setPtPrice'); //停用启用

});

Route::group(['prefix' => 'helps', 'middleware' => 'requestpc','namespace' => 'Helps'], function () {
    Route::resource('subjects', 'SubjectsController', ['as' => 'subjects']); //答题管理
    Route::resource('answer', 'AnswerController', ['as' => 'answer']); //答案管理
});

Route::group(['prefix' => 'Financial', 'middleware' => 'requestpc','namespace' => 'Financial'], function () {
    Route::post('invoiceNum/index', 'InvoiceNumController@index'); //发票号管理
    Route::post('invoiceNum/store', 'InvoiceNumController@store'); //发票号新增
    Route::post('invoiceNum/edit', 'InvoiceNumController@edit'); //发票号修改界面
    Route::post('invoiceNum/update', 'InvoiceNumController@update'); //发票号更新数据
    Route::post('invoiceNum/delete', 'InvoiceNumController@destroy'); //发票号删除
    Route::post('invoiceNum/handleInvoice', 'InvoiceNumController@handleInvoice'); //处理发票号[作废]
    Route::post('invoiceNum/handleInvoiceH', 'InvoiceNumController@handleInvoiceH'); //处理发票号[恢复]
    Route::post('invoiceNum/export', 'InvoiceNumController@export', ['as' => 'invoiceNum.export']); //发票号导出

    Route::post('invoiceTable/index', 'InvoiceTableController@index'); //发票管理
    Route::post('invoiceTable/restentry', 'InvoiceTableController@restentry'); //发票重置
    Route::post('invoiceTable/store', 'InvoiceTableController@store'); //发票新增
    Route::post('invoiceTable/edit', 'InvoiceTableController@edit'); //发票修改界面
    Route::post('invoiceTable/update', 'InvoiceTableController@update'); //发票更新数据
    Route::post('invoiceTable/delete', 'InvoiceTableController@destroy'); //发票删除
    Route::post('invoiceTable/Urgency','InvoiceTableController@Urgency');//发票加急

});
Route::group(['prefix' => 'orders', 'middleware' => 'requestpc','namespace' => 'Orders'], function () {
    Route::post('aftercust/export', 'AfterCustController@export', ['as' => 'aftercust.export']); //电话沟通下载
    Route::post('aftercust/downloadFields', 'AfterCustController@downloadFields', ['as' => 'aftercust.downloadFields']); //电话沟通下载选项
    Route::post('aftercust/index','AfterCustController@index');//列表
    Route::post('aftercust/Deals','AfterCustController@Deals');//处理订单
    Route::post('aftercust/Audits','AfterCustController@Audits');//审核订单
    Route::post('aftercust/updatedata','AfterCustController@updatedata');//更新数据(2019-08-22)
    Route::post('aftercust/refundprocc','AfterCustController@refundprocc');//退款处理(2019/09/26)
    Route::post('aftercust/updatecl', 'AfterCustController@updatecl');//更新处理
});
//供应链、门店推送
Route::group(['namespace' => 'Supplychain', 'prefix' => 'supplychain'], function () {

    Route::post('SupplyMz/get_user', 'SupplyMzchainController@get_user');
    Route::post('SupplyMz/get_supply_chain', 'SupplyMzchainController@get_supply_chain');
    Route::post('SupplyMz/get_damaged', 'SupplyMzchainController@get_damaged');
    //同步技师
    Route::post('SupplyMz/sync_install_persion', 'SupplyMzchainController@sync_install_persion');

    //残损抵扣
    Route::post('SupplyMz/sync_get_damaged', 'SupplyMzchainController@syncGetDamaged');

    //同步接单、拒单
    Route::post('SupplyMz/sync_receipt_status', 'SupplyMzchainController@sync_receipt_status');
    //半径改单审核
    Route::post('SupplyMz/edit_order_examine', 'SupplyMzchainController@edit_order_examine');
    //同步技师状态
    Route::post('SupplyMz/sync_technician_status', 'SupplyMzchainController@sync_technician_status');

    //绑定门店地址同步
    Route::post('SupplyMz/sync_binding_stores', 'SupplyMzchainController@sync_binding_stores');
    Route::post('SupplyMz/lockorder', 'SupplyMzchainController@lockOrder');//半径锁定订单

    Route::post('SupplyMz/undoive', 'SupplyMzchainController@undoIve');//半径锁定订单恢复
    Route::post('SupplyMz/searchLable', 'SupplyMzchainController@searchLable');//获取标签
    Route::post('SupplyMz/addDayTime', 'SupplyMzchainController@addDayTime');//预约时间
    Route::post('SupplyMz/installLine', 'SupplyMzchainController@installLine');//技师操作记录
    Route::post('SupplyMz/rushOrder', 'SupplyMzchainController@rushOrder');//催单反馈
    Route::post('SupplyMz/feedSales', 'SupplyMzchainController@feedSales');//售后反馈
    Route::post('SupplyMz/immedAfter', 'SupplyMzchainController@immedAfter');//售后立即处理
    Route::post('SupplyMz/operation', 'SupplyMzchainController@operation');//驳回账单
    Route::post('SupplyMz/dealWith', 'SupplyMzchainController@dealWith');//账单处理
    Route::post('SupplyMz/afterDayTime', 'SupplyMzchainController@afterDayTime');//售后预约时间

});
Route::group(
['namespace' => 'User'], function () {//User文件
	#登录
	Route::group(['prefix' => 'user', 'middleware' => 'requestpc'], function () {
		Route::post('login', 'LoginController@login');    //登录
		Route::post('phoneAccount', 'LoginController@phoneAccount');    //获取手机对应账号
		Route::post('logout', 'LoginController@logout');    //退出
		Route::post('jurisdiction', 'LoginController@jurisdiction');//权限控制
	});
	#权限管理
	Route::group(['prefix' => 'functions', 'middleware' => 'requestpc'], function () {
		Route::post('index','FunctionsController@index');                //列表页
        Route::post('addLM','FunctionsController@addLM');                //添加栏目
        Route::post('addEntry','FunctionsController@addEntry');          //添加管理
        Route::post('addAction','FunctionsController@addAction');        //添加动作
        Route::post('editAction','FunctionsController@editAction');        //编辑动作
        Route::post('editFuncName','FunctionsController@EditFuncName');        //编辑栏目/模块管理名称
        Route::post('getParent','FunctionsController@getParent');        //获取父类栏目
        Route::post('getmanagement','FunctionsController@getmanagement');//获取父类管理名称
        Route::post('delEntry','FunctionsController@delEntry');          //删除
	});
	#系统设置 >> 人员管理(dou)
    Route::group(['prefix'=>'admins','middleware'=>'requestpc'], function (){
        Route::post('index','AdminsController@index');//列表
        Route::post('addAdminShow','AdminsController@addAdminShow');//添加展示数据
        Route::post('addAdmins','AdminsController@addAdmins');//添加成员
        Route::post('editAdmins','AdminsController@editAdmins');//编辑成员信息
        Route::post('beforEdit','AdminsController@beforEdit');//获取编辑前数据
    });
    #系统设置 >> 部门管理(dou)
    Route::group(['prefix'=>'bmmc','middleware'=>'requestpc'], function (){

        Route::post('index','BmmcController@index');                  //列表页
        Route::post('addEntry','BmmcController@addEntry');            //添加部门
        Route::post('getJurisdiction','BmmcController@getJurisdiction');
        Route::post('getSysFunctions','BmmcController@getSysFunctions');//获取权限
        Route::post('editEntry','BmmcController@editEntry');//编辑
        Route::post('savePower','BmmcController@savePower');//保存权限

    });

    #个人资料修改 du
    Route::group(['prefix'=>'My','middleware'=>'requestpc'],function(){

        Route::post('personal','MyInfoController@personal');         //个人资料修改

    });


});
Route::group(
	['namespace' => 'Common'], function () {//Common文件
		#通用
		Route::group(['prefix' => 'common', 'middleware' => 'requestpc'], function () {
			Route::post('phoneCode', 'CommonController@phoneCode');    //发送验证码
			Route::post('getBrand', 'CommonController@getBrand');    //获取商品品牌
			Route::post('getPt', 'CommonController@getPt');    //获取平台
			Route::post('getAdmins', 'CommonController@getAdmins');    //获取用户信息
            Route::post('getCompany', 'CommonController@getCompany');    //获取公司-门店运营商
            Route::post('getDistributor', 'CommonController@getDistributor');    //获取经销商
            Route::post('getGoods', 'CommonController@getGoods');    //获取用户信息
            Route::post('getAdminDetail', 'CommonController@getAdminDetail');    //获取用户信息详情
            Route::post('addRemarks', 'CommonController@addRemarks');    //添加备注
            Route::post('getRemarks', 'CommonController@getRemarks');    //获取备注
            Route::post('editRemarks', 'CommonController@editRemarks');    //编辑备注
            Route::post('setTrack', 'CommonController@setTrack');    //订单追踪
            Route::post('getService','CommonController@getService');//获取派单推荐服务商信息
            Route::post('getCarInfor','CommonController@getCarInfor');//获取车型信息列表
            Route::post('getWarehouse','CommonController@getWarehouse');//获取仓库
            Route::post('getOrderType', 'CommonController@getOrderType');//订单加急类型
            Route::post('getVersion', 'CommonController@getVersion');//获取当前版本号
            Route::post('getSystemTime', 'CommonController@getSystemTime');//获取当前系统年月
            Route::post('getExcelModel', 'CommonController@getExcelModel');//获取表格模板
            Route::post('getRefundApplyType', 'CommonController@getRefundApplyType');//获取表格模板
            Route::post('getRemarksDetail', 'CommonController@getRemarksDetail');    //获取备注详情

			//du add
        	Route::post('getBmmc','CommonController@getBmmc');              //获取所属部门（针对其它接口搜索）
        	Route::post('getLable','CommonController@getLable');              //获取标签
			Route::post('getCategory', 'CommonController@getCategory'); //获取品类
			Route::post('getGoodsSeries', 'CommonController@getGoodsSeries'); //获取品类
			Route::post('getInstallPerson', 'CommonController@getInstallPerson'); //获取品类
            Route::post('getSubsidyPrice', 'CommonController@getSubsidyPrice'); //获取退款申请类型

            Route::post('getOrderStatusName', 'CommonController@getOrderStatusName');//获取订单状态名

            Route::post('getServeicMode', 'CommonController@getServeicMode');//获取服务方式

            Route::post('getAccountname', 'CommonController@getAccountname');//搜索账户名
            Route::post('getWarehouseNum', 'CommonController@getWarehouseNum');//获取商品库存
            Route::post('getKhAccount', 'CommonController@getKhAccount');//获取开户行号信息
            Route::post('searchCzrz', 'CommonController@searchCzrz');//获取开户行号信息
            Route::post('getCompanyList', 'CommonController@getCompanyList');//获取公司信息


		});

		Route::group(['prefix' => 'categoryDetail', 'middleware' => 'requestpc'], function () {
			//du add
			Route::post('index', 'CategoryDetailController@index');//类目列表
			Route::post('addCategoryName', 'CategoryDetailController@addCategoryName');//添加类目
			Route::post('editCategoryName', 'CategoryDetailController@editCategoryName');//编辑类目
			Route::post('editCategoryNameDelFlag','CategoryDetailController@editCategoryNameDelFlag');//编辑类目启用停用
			Route::post('addCategoryDetali', 'CategoryDetailController@addCategoryDetali');//添加品类
			Route::post('categoryDetaliList', 'CategoryDetailController@categoryDetaliList');//品类列表
			Route::post('editTegoryDetali', 'CategoryDetailController@editTegoryDetali');//编辑品类
			Route::post('editTegoryDetaliDelfalg', 'CategoryDetailController@editTegoryDetaliDelfalg');//编辑品类启用停用
			Route::post('cdSearchList','CategoryDetailController@cdSearchList');//获取品类
			Route::post('cnListSearch', 'CategoryDetailController@cnListSearch');//获取搜索类目
		});

		//du
		Route::group(['prefix' => 'goodsBrand', 'middleware' => 'requestpc'], function () {
			Route::post('index','GoodsBrandController@index');    //品牌列表
			Route::post('addGoodsBrand','GoodsBrandController@addGoodsBrand');//添加品牌
			Route::post('editGoodsBrand','GoodsBrandController@editGoodsBrand');//编辑品牌
			Route::post('editGoodsBrandDelFlag','GoodsBrandController@editGoodsBrandDelFlag');//品牌停用启用
			Route::post('gbSearchList','GoodsBrandController@gbSearchList');//获取品牌列表搜索用

		});

    //du 服务方式管理
    Route::group(['prefix' => 'serviceMode', 'middleware' => 'requestpc'], function () {
        Route::post('index','ServiceModeController@index');    //品牌列表
        Route::post('addMode','ServiceModeController@addMode');//添加品牌
        Route::post('editMode','ServiceModeController@editMode');//编辑品牌
        Route::post('editModeDelfalg','ServiceModeController@editModeDelfalg');//品牌停用启用
    });

    //du 公司管理
    Route::group(['prefix' => 'company', 'middleware' => 'requestpc'], function () {
        Route::post('index','CompanyController@index');    //列表
        Route::post('addCom','CompanyController@addCom');//添加
        Route::post('editCom','CompanyController@editCom');//编辑
    });


		//du
		Route::group(['prefix' => 'goodsSeries', 'middleware' => 'requestpc'], function () {
			Route::post('index','GoodsSeriesController@index');    //系列列表
			Route::post('addGoodsSeries','GoodsSeriesController@addGoodsSeries');//添加系列
			Route::post('editGoodsSeries','GoodsSeriesController@editGoodsSeries');//编辑系列
			Route::post('editaddGoodsSeriesDel','GoodsSeriesController@editaddGoodsSeriesDel');//系列停用启用
			Route::post('gseriesListSearch','GoodsSeriesController@gseriesListSearch');//获取系列列表搜索用

			Route::post('getGoodsSerieByCdId','GoodsSeriesController@getGoodsSerieByCdId');//根据某一品类获取系列列表数据

		});
		//du
		Route::group(['prefix' => 'goods', 'middleware' => 'requestpc'], function () {
			Route::post('index','GoodsController@index');    //商品列表
			Route::post('addGoods','GoodsController@addGoods');//添加商品
			Route::post('editGoods','GoodsController@editGoods');//编辑商品
			Route::post('editGoodsDel','GoodsController@editGoodsDel');//编辑停用启用
			Route::post('getGoodsAttributeLast','GoodsController@getGoodsAttributeLast');//获取最后一条商品属性
		});
		//du
		Route::group(['prefix' => 'labtype', 'middleware' => 'requestpc'], function () {
			Route::post('index','LabtypeController@index');    //商品列表
			Route::post('getInfo','LabtypeController@getInfo');//获取显示范围
			Route::post('addLab','LabtypeController@addLab');//添加标签
			Route::post('editLab','LabtypeController@editLab');//编辑标签
			Route::post('infoTree','LabtypeController@infoTree');//获取标签列表
			Route::post('editLabByGroup','LabtypeController@editLabByGroup');//根据部门编辑标签
			Route::post('getBmmcLab','LabtypeController@getBmmcLab');//获取部门标签
		});

		#售后与服务 >> 标签记录 du
		Route::group(['prefix'=>'afterSale','middleware'=>'requestpc'], function(){
			Route::post('index','AfterSaleController@index');//列表
			Route::post('chuliOrder','AfterSaleController@chuliOrder');//处理标签
		});
//版本日志　du
    Route::group(['prefix' => 'version', 'middleware' => 'requestpc'], function () {
        Route::post('index', 'VersionController@index');//日志数据
        Route::post('addEntry', 'VersionController@addEntry');//添加日志
        Route::post('editEntry', 'VersionController@editEntry');//编辑日志展示
        Route::post('editEntryDo', 'VersionController@editEntryDo');//编辑日志处理
    });

    //开户行行号管理
    Route::group(['prefix' => 'KhAccount', 'middleware' => 'requestpc'], function () {
        Route::post('index','KhAccountController@index');    //品牌列表
        Route::post('addEntry','KhAccountController@addEntry');//添加开户行信息
        Route::post('editEntry','KhAccountController@editEntry');//编辑开户行信息

    });

});

//技师管理 du
Route::group(['namespace' => 'InstallPerson'], function () {
	Route::group(['prefix' => 'installperson', 'middleware' => 'requestpc'], function () {
		Route::post('index', 'InstallPersonController@index');    //技师列表
		Route::post('addInstallPerson','InstallPersonController@addInstallPerson'); //添加
		Route::post('editInstallPerson','InstallPersonController@editInstallPerson'); //编辑
		Route::post('lookPassword', 'InstallPersonController@lookPassword');//查看密码
		Route::post('ipSearchList', 'InstallPersonController@ipSearchList');//获取搜索技师列表
		Route::post('onCompany','InstallPersonController@onCompany');//检测门店是否已绑定
		Route::post('resetPassword','InstallPersonController@resetPassword');//重置密码
		Route::post('installBranch','InstallPersonController@installBranch');//添加下属技师
		Route::post('delInstallPerson','InstallPersonController@delInstallPerson');//删除
	});
});

//预备注　 du
Route::group(
['namespace' => 'RemarkNotes'], function () {
	Route::group(['prefix' => 'noteList', 'middleware' => 'requestpc'], function () {
		Route::post('index', 'NoteListController@index');//列表
        Route::post('open', 'NoteListController@open');//开发
        Route::post('noOpen', 'NoteListController@noOpen');//不开放
        Route::post('addNote', 'NoteListController@addNote');//停用、启用
        Route::post('tbType', 'NoteListController@tbType');//同步操作
        Route::post('typeDo', 'NoteListController@typeDo');//处理操作
        Route::post('synData', 'NoteListController@synData');//同步订单信息
        Route::post('selectTb', 'NoteListController@selectTb');//批量同步选择
        Route::post('searchpic', 'NoteListController@searchpic');//同步订单查询信息
     	Route::post('qualityAssurance', 'NoteListController@qualityAssurance'); //申请售后（新）

     	Route::post('getSelectType', 'NoteListController@getSelectType'); //获取类型
     	Route::post('show', 'NoteListController@show'); //回复前展示信息
     	Route::post('reply', 'NoteListController@reply'); //咨询回复
     	Route::post('updateStatus', 'NoteListController@updateStatus');//确认解决 更新为已处理
        Route::post('replyDatas', 'NoteListController@replyDatas');//
        Route::post('pgNumber', 'NoteListController@pgNumber');//获取申请售后的必要参数
	});
});

//订单系统 >> 派工单列表 du
Route::group(
['namespace' => 'Orders'], function () {

Route::group(['prefix'=>'orderlist','middleware'=>'requestpc'], function(){
	Route::post('index','OrderListController@index');//列表
	Route::post('getInstallPerson','OrderListController@getInstallPerson');//接单（获取技师）
	Route::post('getOrder','OrderListController@getOrder');//接单（动作）
	Route::post('labtype','OrderListController@labtype');//拒单（获取标签）
	Route::post('refuseOrder','OrderListController@refuseOrder');//拒单
	Route::post('transferPersonnel','OrderListController@transferPersonnel');//转单（获取安装人员）
	Route::post('transferOrder','OrderListController@transferOrder');//转单（动作）
	Route::post('rejectedPending','OrderListController@rejectedPending');//驳回至待完成
	Route::post('completeBohui','OrderListController@completeBohui');//驳回至安装中
	Route::post('OrderInformation','OrderListController@OrderInformation');//派单信息
	Route::post('negprice','OrderListController@negprice');//协商价格
	Route::post('feedbackrefer','OrderListController@feedbackrefer');//任务反馈
	Route::post('completeApply','OrderListController@completeApply');//完成申请
	Route::post('auditpic','OrderListController@auditpic');//图片审核信息展示(按钮)
	Route::post('searhData','OrderListController@searhData');//获取订单详情
	Route::post('addNote','OrderListController@addNote');//备注
	Route::post('logIve','OrderListController@logIve');//获取反馈日志
	Route::post('appointment','OrderListController@appointment');//预约时间
	Route::post('editHeadPhone','OrderListController@editHeadPhone');//修改负责人电话

	Route::post('getOrderPrice','OrderListController@getOrderPrice');//订单金额
	Route::post('getDetails', 'OrderListController@getDetails');//获取列表 分类数据
    Route::post('ordersDispatchDatas', 'OrderListController@ordersDispatchDatas');//派单数据统计
    Route::post('delayStatus', 'OrderListController@delayStatus');//更新延期审图 延期结算
    Route::post('returnDelayStatus', 'OrderListController@returnDelayStatus');//恢复正常（将延期审图 延期结算）
    Route::post('getDelayStatusName', 'OrderListController@getDelayStatusName');//获取延期状态名
    Route::post('sendSmsOrderListModel', 'OrderListController@sendSmsOrderListModel');//发送短信
    Route::post('updateManhourfee', 'OrderListController@updateManhourfee');//修改工时费 2022-3-21
    Route::post('patchGetOrder', 'OrderListController@patchGetOrder');//批量接单 2022-3-23
    Route::post('sendAgain', 'OrderListController@sendAgain');//指派门店 2024-09-19
	});

#订单系统 >> 备注导入
    Route::group(['prefix'=>'importNotes','middleware'=>'requestpc'], function (){
        Route::post('index','ImportNotesController@index');//导入的备注列表
        Route::post('importNote','ImportNotesController@importNote');//导入
        Route::post('synNotes','ImportNotesController@synNotes');//同步备注
        Route::post('updateNoteSlove','ImportNotesController@updateNoteSlove');//更新为已解决

    });

	#订单系统 >> 添加订单
    Route::group(['prefix'=>'orderadd','middleware'=>'requestpc'], function (){
        Route::post('beforAddOrder','OrderaddController@beforAddOrder');//添加订单展示数据
        Route::post('validationOrderNum','OrderaddController@validationOrderNum');//验证订单单号
        Route::post('add_order','OrderaddController@add_order');//添加订单
        Route::post('mate','OrderaddController@mate');//添加订单(返回选中的商品)
        Route::post('getOldpt','OrderaddController@getOldpt');//最近添加订单的平台、服务类型
        Route::post('getDataUser','OrderaddController@getDataUser');//最近添加订单的平台、服务类型

    });
    #订单系统 >> 订单管理
    Route::group(['prefix'=>'orders','middleware'=>'requestpc'],function(){
        Route::post('index','OrdersController@index');//首页
        Route::post('getNote', 'OrdersController@getNote');//获取备注 分类信息
        Route::post('pgNumber', 'OrdersController@pgNumber');//获取申请售后的必要参数
        Route::post('qualityAssurance','OrdersController@qualityAssurance');//申请售后
        Route::post('addWorkOrder','OrdersController@addWorkOrder');//我要派单
        Route::post('qualityEvaluate','OrdersController@qualityEvaluate');//评价标签保存
        Route::post('sendGoods', 'OrdersController@sendGoods');//添加发货
        Route::post('selectSendGoods', 'OrdersController@selectSendGoods');//筛选可发货商品
        Route::post('orderAllCheck','OrdersController@orderAllCheck');//派单前获取多次下单记录
        Route::post('lockOrder','OrdersController@lockOrder');//订单锁定（动作）
        Route::post('undoIve','OrdersController@undoIve');//锁定处理（恢复、撤销）
        Route::post('confirmReplacement','OrdersController@confirmReplacement');//换货
        Route::post('editAddress','OrdersController@editAddress');//派单-编辑地址
        Route::post('changePt','OrdersController@changePt');//更换平台
        Route::post('delayOrder','OrdersController@delayOrder');//订单延期*
        Route::post('orderUrgent','OrdersController@orderUrgent');//订单加急
        Route::post('reminderInfo','OrdersController@reminderInfo');//我要催单（弹出）
        Route::post('reminder','OrdersController@reminder');//催单
        Route::post('changeOrder','OrdersController@changeOrder');//更换单号
        Route::post('afterCusmer','OrdersController@afterCusmer');//电话沟通
        Route::post('autoOrder','OrdersController@autoOrder');//自动派单
        Route::post('negotiated','OrdersController@negotiated');//申请协商价格
        Route::post('refundGoods','OrdersController@refundGoods');//退款锁定获取商品
        Route::post('getSupply','OrdersController@getSupply');//协商价格获取原结算金额
        Route::post('beforAddTickt','OrdersController@beforAddTickt');//申请罚单前获取单号
        Route::post('applicatIonfines','OrdersController@applicatIonfines');//申请罚款
        Route::post('electronicInvoice','OrdersController@electronicInvoice');//电子发票
        Route::post('editPrice','OrdersController@editPrice');//编辑协商价格
        Route::post('feedbackLog','OrdersController@feedbackLog');//反馈日志（全部状态中）
        Route::post('salePhoto', 'OrdersController@salePhoto');//售后图片
        Route::post('searchRele','OrdersController@searchRele');//获取订单关联信息
        Route::post('getDetail','OrdersController@getDetail');//订单详情
        Route::post('getChildgoods','OrdersController@getChildgoods');//派单获取服务商品
        Route::post('dealActivity','OrdersController@dealActivity');//活动处理
        Route::post('sysZhipeiOrder','OrdersController@sysZhipeiOrder');//同步智配仓库服务单信息

        //du add
        Route::post('addServiceScore','OrdersController@addServiceScore');//添加技术服务评分
        Route::post('delServiceScore','OrdersController@delServiceScore');//删除技术服务评分
        Route::post('getServiceScoreLabs','OrdersController@getServiceScoreLabs');//获取选中标签ID

        Route::post('userCarInfo', 'OrdersController@userCarInfo');//用户车型 新增2022-2-21
        Route::post('fastAddOrderBefor', 'OrdersController@fastAddOrderBefor');//添加订单前数据 新增2022-3-7
        Route::post('validationOrderNum', 'OrdersController@validationOrderNum');//验证平台单号是否存在 新增2022-3-7
        Route::post('mate','OrdersController@mate');//添加订单(返回选中的商品) 新增2022-3-7
        Route::post('fastAddOrder','OrdersController@fastAddOrder');//快捷填单 新增2022-3-7
        Route::post('dealTimeOut','OrdersController@dealTimeOut');//超时处理
        //dong
        Route::post('addF6Claim','OrdersController@addF6Claim');//添加F6索赔
    });
    #售后与服务 >> 售后列表
    Route::group(['prefix'=>'AftersaleOrder','middleware'=>'requestpc'], function(){
        Route::post('index','AftersaleOrderController@index');//列表
        Route::post('sysOtherInfor','AftersaleOrderController@sysOtherInfor');//异步同步售后列表信息
        Route::post('getclassFly','AftersaleOrderController@getclassFly');//获取分类数量
        Route::post('AfterReminder','AftersaleOrderController@AfterReminder');//售后催单
        Route::post('AfterTransfer','AftersaleOrderController@AfterTransfer');//售后移交
        Route::post('quality_bohuis','AftersaleOrderController@quality_bohuis');//驳回售后申请-
        Route::post('quality_complete','AftersaleOrderController@quality_complete');//撤销售后-
        Route::post('quality','AftersaleOrderController@quality');//申请售后完成-
        Route::post('finish_quality','AftersaleOrderController@finish_quality');//完成申请售后
        Route::post('lookpics','AftersaleOrderController@lookpics');//查看售后图片-
        Route::post('handle_ive','AftersaleOrderController@handle_ive');//订单处理-
        Route::post('looktime_sumb','AftersaleOrderController@looktime_sumb');//追踪时间-
        Route::post('setclassify','AftersaleOrderController@setclassify');//设定分类
        Route::post('addclassify','AftersaleOrderController@addclassify');//售后分类
        Route::post('edit_classify','AftersaleOrderController@edit_classify');//启用、停用分类
        Route::post('afterClassify','AftersaleOrderController@afterClassify');//售后分类
        Route::post('afterPush','AftersaleOrderController@afterPush');//售后推送（售后催单）
        Route::post('apply_acc','AftersaleOrderController@apply_acc');//申请协助
        Route::post('view_voucher','AftersaleOrderController@view_voucher');//查看售后凭证(2019/09/30)
        Route::post('appoint_time','AftersaleOrderController@appointTime');//预约时间
        Route::post('get_lab','AftersaleOrderController@getLab');//标签
        Route::post('setapplytype', 'AftersaleOrderController@setApplyType');//编辑申诉类型
        Route::post('Customer', 'AftersaleOrderController@Customer');//客服介入
        Route::post('returnHandle', 'AftersaleOrderController@returnHandle');//返回处理中
        Route::post('beforDealAfter', 'AftersaleOrderController@beforDealAfter');//获取车膜售后信息
        Route::post('getAfterRecord', 'AftersaleOrderController@getAfterRecord');//获取车膜售后处理记录
        Route::post('dealSolarFilmDetail', 'AftersaleOrderController@dealSolarFilmDetail');//售后车膜处理
        Route::post('getSolarFilmGoods', 'AftersaleOrderController@getSolarFilmGoods');//获取车膜售后补发商品

        Route::post('getId', 'AftersaleOrderController@getId');//用户领取

        Route::post('pgNumber', 'AftersaleOrderController@pgNumber');//获取申请售后的必要参数
        Route::post('fastAfterOrder', 'AftersaleOrderController@fastAfterOrder');//便捷售后
        Route::post('getImgContent', 'AftersaleOrderController@getImgContent');//获取图文
        Route::post('editImgContent', 'AftersaleOrderController@editImgContent');//编辑图文

        Route::post('moveGetId', 'AftersaleOrderController@moveGetId');//移交领取人
        Route::post('sendSmsAfterModel', 'AftersaleOrderController@sendSmsAfterModel');//
        Route::post('searchAftertrack', 'AftersaleOrderController@searchAftertrack');//售后追踪列表
        Route::post('dealAftertrack', 'AftersaleOrderController@dealAftertrack');//处理追踪订单
    });

    #订单系统 >> 催单管理(du)
    Route::group(['prefix'=>'serInfo','middleware'=>'requestpc'], function (){
    	Route::post('index','SerInforController@index');//列表
    	//Route::post('labtype','SerInforController@labtype');//获取标签
    	Route::post('rOrder','SerInforController@rOrder');//催单处理
    	Route::post('reminder','SerInforController@reminder');//催单处理
    	Route::post('reminderSort','SerInforController@reminderSort');//催单处理
        Route::post('fastRemind','SerInforController@fastRemind');//便捷催单
        Route::post('getRemindInfo','SerInforController@getRemindInfo');//获取催单信息
        Route::post('sendSmsSerInfoModel','SerInforController@sendSmsSerInfoModel');//发送短信

    });
    #订单系统 >> 京东会员信息同步
    Route::group(['prefix' => 'sysjduserdata','middleware' => 'requestpc'], function () {
        Route::post('index', 'SysJdUserDataController@index');//列表页
        Route::post('uploadExcelImport', 'SysJdUserDataController@uploadExcelImport');//导入表格
        Route::post('sysData', 'SysJdUserDataController@sysData');//同步客户信息
    });
    #订单系统 >> 订单导入
    Route::group(['prefix' => 'BulkImport','middleware' => 'requestpc'], function () {
        Route::post('index', 'BulkImportController@index');//列表页
        Route::post('uploadExcelImport', 'BulkImportController@uploadExcelImport');//导入表格
        Route::post('sysData', 'BulkImportController@sysData');//同步客户信息
    });
    #订单系统 >> 罚单管理(du)

    Route::group(['prefix'=>'ticketlist','middleware'=>'requestpc'], function (){
    	Route::post('index','TicketListController@index');//列表
    	Route::post('searchRele','TicketListController@searchRele');//获取订单关联信息
    	Route::post('beforAddEntry','TicketListController@beforAddEntry');//添加罚单(生成处罚单号)
    	Route::post('addList','TicketListController@addList');//添加罚单(动作)
    	Route::post('editEntry','TicketListController@editEntry');//编辑罚款金额
    	Route::post('repeal','TicketListController@repeal');//撤销
    	Route::post('toExamine','TicketListController@toExamine');//审核
    	Route::post('toAppeal','TicketListController@toAppeal');//申诉
    	Route::post('toDetails','TicketListController@toDetails');//审核，申诉获取订单信息
    	Route::post('view_attachments','TicketListController@viewAttachments');//查看附件
    	//Route::post('ticket_label','TicketListController@ticketLabel');//罚单标签
    	Route::post('executed','TicketListController@executed');//执行
        Route::post('unsetTicket','TicketListController@unsetTicket');//撤消

    });

    #订单系统 >> 退款管理(du)
    Route::group(['prefix'=>'refund','middleware'=>'requestpc'], function(){
    	Route::post('index','RefundController@index');
    	Route::post('telephone','RefundController@telephone');//发起电话沟通
    	Route::post('applyRefund','RefundController@applyRefund');//审核
    	Route::post('applyReject','RefundController@applyReject');//驳回订单
    	Route::post('manualSync','RefundController@manualSync');//数据同步
    	Route::post('urgent','RefundController@urgent');//加急
    	Route::post('editLabel', 'RefundController@editLabel');//编辑退款原因
    	Route::post('editGetlabel', 'RefundController@editGetlabel');//编辑标签
    	Route::post('editGetlabelDo', 'RefundController@editGetlabelDo');//编辑标签处理
    	Route::post('searchSernum', 'RefundController@searchSernum');//获取工单号
        Route::post('refundGoods', 'RefundController@refundGoods');//退款锁定商品展示
        Route::post('fastRefund', 'RefundController@fastRefund');//便捷退款
        Route::post('sysWarehouseRefund', 'RefundController@sysWarehouseRefund');//同步退款
        Route::post('sendSmsRefundModel', 'RefundController@sendSmsRefundModel');//发短信
        Route::post('SendGoodsStaue', 'RefundController@SendGoodsStaue');//异步获取发货状态
        Route::post('fastAddOrder', 'RefundController@fastAddOrder');//便捷填单

        Route::post('getOrderPrices', 'RefundController@getOrderPrices');//异步获取下单金额
        Route::post('getAuditLable', 'RefundController@getAuditLable');//获取完成标签类型

    });


   #订单系统 >> 平台评价 du
   Route::group(['prefix'=>'evaluation','middleware'=>'requestpc'], function(){
   	Route::post('index','EvaluationFormController@index');//列表页
   	Route::post('importEvaluation','EvaluationFormController@importEvaluation');
   	Route::post('syncEvaluation','EvaluationFormController@syncEvaluation');
   	Route::post('labEvaluation','EvaluationFormController@labEvaluation');//评价类型
   	Route::post('listEvaluation','EvaluationFormController@listEvaluation');//详情
   	Route::post('explainEvaluation','EvaluationFormController@explainEvaluation');//解释
   	Route::post('appealEvaluation','EvaluationFormController@appealEvaluation');//申诉
   	Route::post('toExamine','EvaluationFormController@toExamine');//审核
   	Route::post('businessDeal','EvaluationFormController@businessDeal');//商家处理
   	Route::post('cancle','EvaluationFormController@cancle');//商家处理
   	Route::post('evaluateLabe','EvaluationFormController@evaluateLabe');//获取标签
    Route::post('fastEvaluate','EvaluationFormController@fastEvaluate');   //便捷评价
       Route::post('newToWait','EvaluationFormController@newToWait');  //更新为待处理
       Route::post('matchNewToFinish','EvaluationFormController@matchNewToFinish');//批量更新为完成

    });

    #订单系统 >> 商品发货管理
  Route::group(['prefix'=>'sendGoods','middleware'=>'requestpc'], function(){
   	Route::post('index', 'SendGoodsController@index');//发货列表
   	Route::post('seePicture', 'SendGoodsController@seePicture');//查看图片
   	Route::post('sendGoodsDo', 'SendGoodsController@sendGoodsDo');//发货处理
   	Route::post('addPhoto', 'SendGoodsController@addPhoto');//处理图片
   	Route::post('reject', 'SendGoodsController@reject');//驳回操作
   	Route::post('editAdress', 'SendGoodsController@editAdress');//获取编辑地址
   	Route::post('editAdressDo', 'SendGoodsController@editAdressDo');//编辑操作　
   	Route::post('recoverGoods', 'SendGoodsController@recoverGoods');//获取商品
   	Route::post('recoverDo', 'SendGoodsController@recoverDo');//追回处理
   	Route::post('getRejectGoods', 'SendGoodsController@getRejectGoods');//获取驳回商品
    Route::post('auditSend', 'SendGoodsController@auditSend');//车膜发货单审核
      Route::post('editCourier', 'SendGoodsController@editCourier');  //编辑快递信息

      Route::post('getOrderSendInfo', 'SendGoodsController@getOrderSendInfo');  //获取添加前数据
      Route::post('addOrder', 'SendGoodsController@addOrder');//添加订单
      Route::post('mate', 'SendGoodsController@mate');//


    });

    #订单系统 >> 回收商品管理
    Route::group(['prefix'=>'RecycleOrder','middleware'=>'requestpc'],function(){
        Route::post('index','RecycleOrderController@index');         //列表
        Route::post('rejectedData','RecycleOrderController@rejectedData');         //驳回
        Route::post('restoreData','RecycleOrderController@restoreData');         //恢复
        Route::post('dealData','RecycleOrderController@dealData');         //处理回收单
        Route::post('editCourier','RecycleOrderController@editCourier');//编辑快递信息
        Route::post('editPrice','RecycleOrderController@editPrice');//编辑回收金额

    });
    #订单系统 >> 京仓回收管理
    Route::group(['prefix'=>'RecycleJdOrder','middleware'=>'requestpc'],function(){
        Route::post('index','RecycleJdOrderController@index');         //列表
        Route::post('importJdRefundOrder','RecycleJdOrderController@importJdRefundOrder');   //导入
        Route::post('cynRecycleOrder','RecycleJdOrderController@cynRecycleOrder');// 同步回收单

    });
    //

    #订单系统 >> 风帆
    Route::group(['prefix' => 'fengfan', 'middleware' => 'requestpc'], function () {
        Route::post('index', 'FengfanController@index');//列表
        Route::post('uploadFile', 'FengfanController@uploadFile');//导入excel
        Route::post('editType', 'FengfanController@editType');//处理
        Route::post('selectEditData', 'FengfanController@selectEditData');//处理查询数据
    });

});



//消息管理　 du
Route::group(
['namespace' => 'Sms'], function () {
    Route::group(['prefix' => 'smsHistory', 'middleware' => 'requestpc'], function () {
        Route::post('sendList', 'SmsHistoryController@sendList'); //发送列表 index
        Route::post('index', 'SmsHistoryController@index');     //回复列表　list
        Route::post('afterList', 'SmsHistoryController@afterList');     //列表页
        Route::post('remove', 'SmsHistoryController@remove');     //列表页
        Route::post('addSms', 'SmsHistoryController@addSms');     //添加短信
        Route::post('editSms', 'SmsHistoryController@editSms');     //编辑短信
        Route::post('sendSms', 'SmsHistoryController@sendSms');     //发送短信
        Route::post('orderList', 'SmsHistoryController@orderList');     //同步订单列表
        Route::post('orderDo', 'SmsHistoryController@orderDo');     //同步订单操作
        Route::post('getReSmsByphone', 'SmsHistoryController@getReSmsByphone');//getReSmsByphone
        Route::post('resetSendsms', 'SmsHistoryController@resetSendsms');//重发短信
    });
});



//数据同步　 du
Route::group(
['namespace' => 'DataSyn'], function () {
	//京东自营同步
    Route::group(['prefix'=>'JdSynchronous','middleware'=>'requestpc'],function(){
        Route::post('index','JdSynchronousController@index');              //列表
        Route::post('recovery','JdSynchronousController@recovery');        //恢复
        Route::post('fillBill','JdSynchronousController@fillBill');        //填单-
        Route::post('delParameter','JdSynchronousController@delParameter');//删除-
        Route::post('binding','JdSynchronousController@binding');          //绑定
		Route::post('editAdress','JdSynchronousController@editAdress');    //编辑地址
        Route::post('addRemarks','JdSynchronousController@addRemarks');    //添加备注-
    });
    //京东商品绑定
    Route::group(['prefix'=>'JdGoodsBind','middleware'=>'requestpc'],function(){
        Route::post('index','JdBoundController@index');              //列表
        Route::post('addBound','JdBoundController@addBound');        //添加
        Route::post('editBound','JdBoundController@editBound');        //编辑
        Route::post('deleteBound','JdBoundController@deleteBound');//删除-

    });
    //非京东商品绑定
    Route::group(['prefix'=>'bangding','middleware'=>'requestpc'],function(){
        Route::post('index','BangdingController@index');    //列表
        Route::post('goodsAdd','BangdingController@goodsAdd');      //添加
        Route::post('goodsEdit','BangdingController@goodsEdit');    //编辑

    });

});



//导出　du
Route::group(
    ['namespace' => 'ExcelInfo'], function () {

        Route::group(['prefix' => 'excel', 'middleware' => 'requestpc'], function () {
            Route::post('index', 'ExcelListController@index');//列表
            Route::any('addDownloudnum', 'ExcelListController@addDownloudnum');//下载次数
            Route::post('execExcelOut', 'ExceloutController@execExcelOut');//执行
    });

    #导出权限
    Route::group(['prefix' => 'excelpermiss', 'middleware' => 'requestpc'], function () {
        Route::post('excelActions', 'ExcelpermissController@excelActions');//获取控制器名称
        Route::post('excelFields', 'ExcelpermissController@excelFields');//获取字段数据
        Route::post('excelAdd', 'ExcelpermissController@excelAdd');//添加
        Route::post('index', 'ExcelpermissController@index');//列表
        Route::post('excelEdit', 'ExcelpermissController@excelEdit');//编辑
        Route::post('excelDel', 'ExcelpermissController@excelDel');//删除
    });

});

Route::group(
    ['namespace' => 'DatasBase'],function(){
    #基础数据 >> 自动派单绑定服务商
        Route::group(['prefix'=>'bserviss','middleware'=>'requestpc'], function (){
            Route::post('index', 'BservissController@index');//列表
            Route::post('set_status', 'BservissController@set_status');//设置状态-
            Route::post('set_time', 'BservissController@set_time');//设置派单时间-
            Route::post('DelEntry', 'BservissController@DelEntry');//删除
            Route::post('search_brand', 'BservissController@search_brand');//获取可操作品牌
            Route::post('search_company', 'BservissController@search_company');//获取服务商
            Route::post('search_xian', 'BservissController@search_xian');//获取包含区域
            Route::post('search_shi', 'BservissController@search_shi');//获取城市
            Route::post('EditEntry', 'BservissController@EditEntry');//编辑-
            Route::post('AddEntry', 'BservissController@AddEntry');//添加-
            Route::post('searchService', 'BservissController@searchService');
            Route::post('region', 'BservissController@region');

        });

    #基础数据 >> 门店绑定服务商
    Route::group(['prefix'=>'bservistore', 'middleware'=>'requestpc'],function(){
        Route::post('index','BserviStoreController@index');//列表页
        Route::post('insert','BserviStoreController@insert');//添加
        Route::post('edit','BserviStoreController@edit');//编辑
        Route::post('examine','BserviStoreController@examine');//审核
        Route::post('reject','BserviStoreController@reject');//编辑
        Route::post('befor_edit','BserviStoreController@befor_edit');//编辑前获取数据
        Route::post('befor_serachxian','BserviStoreController@befor_serachxian');//编辑前获选中区域
        Route::post('reset','BserviStoreController@reset');//重置
        Route::post('bslog_list','BserviStoreController@bslog_list');//审核记录
        Route::post('get_xian','BserviStoreController@get_xian');//查找市下的县
        Route::post('updateShengBySid','BserviStoreController@updateShengBySid');//
        Route::post('getAdressBySid', 'BserviStoreController@getAdressBySid');//获取地址
        Route::post('bind_del', 'BserviStoreController@bind_del');//删除地址
    });

    //门店区域管理
    Route::group(['prefix'=>'usermap','middleware'=>'requestpc'], function(){
        Route::post('maplist','MassifController@maplist');  // 渲染页面
        Route::post('addmap','MassifController@addmap');    // 添加数据
        Route::post('editmap','MassifController@editmap');  // 编辑数据
        Route::post('delmap','MassifController@delmap');    // 删除数据
        Route::post('block_map','MassifController@block_map'); //展示区域块
        Route::post('Toexaminmap','MassifController@Toexaminmap');//地图审核

    });

#基础数据 >> 地域管理
    Route::group(['prefix'=>'Region','middleware'=>'requestpc'],function(){
        Route::post('addRegion','RegionController@addRegion');   //添加
        Route::post('index','RegionController@index');           //列表
        Route::post('editRegion','RegionController@editRegion'); //编辑
       // Route::post('OutExcel','RegionController@OutExcel');     //导出
    });

#车型纠错
    Route::group(['prefix'=>'correct','middleware'=>'requestpc'],function(){

        Route::post('index','CarcorrectController@index');//列表
        Route::post('audit','CarcorrectController@audit');//列表
    });

    #自动派单区域
    Route::group(['prefix'=>'disarea','middleware'=>'requestpc'], function (){

        Route::post('index', 'DisareaController@index');//编辑展示
        Route::post('search_list', 'DisareaController@search_list');//列表
        Route::post('save_state', 'DisareaController@save_state');//编辑数据状态

    });


    #电瓶查询
    Route::group(['prefix'=>'query','middleware'=>'requestpc'],function(){

        Route::post('search_need','QueryBrandController@search_need');//搜问题
        Route::post('search_battery','QueryBrandController@search_battery');//根据车型搜电瓶
        Route::post('good_correct','QueryBrandController@good_correct');//车型匹配商品纠错
    });

    #查询系统 >> 地址查询
    Route::group(['prefix' => 'dress'], function () {
        Route::post('index','SearchDressController@index'); //
    });
    #查询系统 >> 服务商地址查询
    Route::group(['prefix' => 'admindress'], function () {
        Route::post('index','SearchAdminDressController@index'); //
    });
    #基础数据 >> 短信模板
    Route::group(['prefix'=>'sms', 'middleware'=>'requestpc'],function(){
        Route::post('index','SmsTemplateController@index');//列表页
        Route::post('template','SmsTemplateController@template');//获取模板标签
        Route::post('did','SmsTemplateController@did');//获取模板标签
        Route::post('insert','SmsTemplateController@insert');//添加
        Route::post('edit','SmsTemplateController@edit');//编辑
        Route::post('sms_test','SmsTemplateController@sms_test');//测试发送短信
        Route::post('getSmsModel','SmsTemplateController@getSmsModel');//获取模块

    });

    #基础数据 >> APP信息管理
    Route::group(['prefix'=>'Manageapp','middleware'=>'requestpc'],function(){

        Route::post('index','ManageAppController@index');         //列表
        Route::post('addManage','ManageAppController@addManage');           //添加
        Route::post('editManage','ManageAppController@editManage');         //编辑

    });

    #活动系统 >> 活动礼品 du
    Route::group(['prefix'=>'eventgift','middleware'=>'requestpc'], function () {

        Route::post('index','EventGiftController@index'); //列表页
        Route::post('getgift','EventGiftController@getGift'); //获取礼品服务信息
        Route::post('gift_revoke','EventGiftController@giftRevoke');//撤销
        Route::post('gift_handle','EventGiftController@giftHandle');//处理
        Route::post('gift_set','EventGiftController@giftSet');//类型设置
        Route::post('giftAdd','EventGiftController@giftAdd');//添加
        Route::post('gift_import','EventGiftController@giftImport');//添加
        Route::post('event_history','EventGiftController@event_history');//回传记录
        Route::post('sysGoodsCodeName','EventGiftController@sysGoodsCodeName');//批量同步
        Route::post('sysSendGoods','EventGiftController@sysSendGoods');//同步发货单
        Route::post('switchSendType','EventGiftController@switchSendType');//切换发货类型

    });
    #消息提醒
    Route::group(['prefix' => 'tips', 'middleware' => 'requestpc'], function () {
        Route::post('index', 'TipsController@index');//列表
        Route::post('msgIndex', 'TipsController@msgIndex');//消息提醒权限列表
        Route::post('addUser', 'TipsController@addUser');//同步拒单
        Route::post('addUserDo', 'TipsController@addUserDo');//
        Route::post('messageName', 'TipsController@messageName');//手动同步临时表
        Route::post('updateUser', 'TipsController@updateUser');//批量编辑
        Route::post('updateUserDo', 'TipsController@updateUserDo');//批量编辑提交
        Route::post('reset', 'TipsController@reset');//重置
    });

//2022-4-19
    Route::group(['prefix'=>'ptType','middleware'=>'requestpc'],function(){
        Route::post('index','PtTypeController@index');         //列表
        Route::post('addPtType','PtTypeController@addPtType');           //添加
        Route::post('editPtType','PtTypeController@editPtType');         //编辑
    });

//2022-4-20
    Route::group(['prefix'=>'wptprice','middleware'=>'requestpc'],function(){
        Route::post('index','WptpriceController@index');         //列表
        Route::post('addEntry','WptpriceController@addEntry');           //添加
        Route::post('editEntry','WptpriceController@editEntry');         //编辑
        Route::post('delGoodsBrand','WptpriceController@delGoodsBrand'); //删除
        Route::post('goodExcel','WptpriceController@goodExcel');//回传商品价格导入
        Route::post('getBland','WptpriceController@getBland');//下载模板
    });

//2022-6-15
    Route::group(['prefix'=>'ptphistory','middleware'=>'requestpc'],function(){
        Route::post('index','PtPhistoryController@index');//列表
        Route::post('deal','PtPhistoryController@deal');//同步
        Route::post('dealOne','PtPhistoryController@dealOne');//单条同步
        Route::post('getBland','PtPhistoryController@getBland');//下载模板
        Route::post('uploadExcelImport','PtPhistoryController@uploadExcelImport');//回传平台账单数据
    });

//2024-10-17
    Route::group(['prefix'=>'DataStatistics','middleware'=>'requestpc'],function(){
        Route::post('index','DataStatisticsController@index');//列表
    });
});
Route::group(
    ['namespace' => 'Financial'],function(){
        #财务管理 >> 账单报表
        Route::group(['prefix'=>'StatementsList', 'middleware'=>'requestpc'],function(){
            Route::post('index','StatementsListController@index');//列表页
            Route::post('getDetails', 'StatementsListController@getDetails');//获取列表 分类数据
            Route::post('getStoreList', 'StatementsListController@getStoreList');//获取可出账单门店列表
            Route::post('creactSettle', 'StatementsListController@creactSettle');//生成结算单
            Route::post('delEntry', 'StatementsListController@delEntry');//删除结算单
            Route::post('submitMer', 'StatementsListController@submitMer');//提交商家确认
            Route::post('suppleSubmit', 'StatementsListController@suppleSubmit');//提交至待补货
            Route::post('operation', 'StatementsListController@operation');//驳回账单
            Route::post('dealWith', 'StatementsListController@dealWith');//确认账单
            Route::post('search', 'StatementsListController@search');//查看详情
            Route::post('getPriceDetail', 'StatementsListController@getPriceDetail');//获取结算单金额明细
            Route::post('deletPrice', 'StatementsListController@deletPrice');//删除金额标签
            Route::post('insertPrice', 'StatementsListController@insertPrice');//添加标签
            Route::post('updatePrice', 'StatementsListController@updatePrice');//编辑标签
            Route::post('uploadView', 'StatementsListController@uploadView');//获取凭证

            Route::post('billExport', 'StatementsListController@billExport');//单个服务商报表导出

            Route::post('sysRepleni', 'StatementsListController@sysRepleni');//同步账单博世补货
            Route::post('sysSubsidies', 'StatementsListController@sysSubsidies');//同步补货博世补贴金额
        });
        #财务管理 >> 结算单列表
        Route::group(['prefix'=>'settlement', 'middleware'=>'requestpc'],function(){
            Route::post('index','SettlementController@index');//列表页
            Route::post('getDetails','SettlementController@getDetails');//获取列表异步加载信息
            Route::post('getPriceDetail', 'SettlementController@getPriceDetail');//获取结算单金额明细
            Route::post('deletPrice', 'SettlementController@deletPrice');//删除金额标签
            Route::post('insertPrice', 'SettlementController@insertPrice');//添加标签
            Route::post('updatePrice', 'SettlementController@updatePrice');//编辑标签
            Route::post('editReceipts', 'SettlementController@editReceipts');//编辑结算单实收金额
            Route::post('shut_down', 'SettlementController@shut_down');//审核驳回
            Route::post('EditEntry', 'SettlementController@EditEntry');//订单审核
            Route::post('creactSettle', 'SettlementController@creactSettle');//订单审核
        });
        #财务系统 >> 服务中心账目管理(kong)
        Route::group(['prefix'=>'ServiceCenter','middleware'=>'requestpc'], function (){
            Route::post('index', 'ServiceCenterController@index');                  //列表
            Route::post('getNote', 'ServiceCenterController@getNote');    //获取异步加载明细
            Route::post('returnSettle', 'ServiceCenterController@returnSettle');    //退回结算
            Route::post('applyPayment', 'ServiceCenterController@applyPayment');    //申请结款
            Route::post('returnApply', 'ServiceCenterController@returnApply');      //退回申请
            Route::post('badebt', 'ServiceCenterController@badebt');                //坏账
            Route::post('toPendingPaid', 'ServiceCenterController@toPendingPaid');            //退回代付
            Route::post('confirmPayment', 'ServiceCenterController@confirmPayment');//确认付款
            Route::post('dismissAudit', 'ServiceCenterController@dismissAudit');    //驳回审核
            Route::post('searchCanPayment', 'ServiceCenterController@searchCanPayment');    //获取可付款门店名单
            Route::post('ticket', 'ServiceCenterController@ticket');                //重置
            Route::post('auditzd', 'ServiceCenterController@auditzd');//审核
            Route::post('searchCanAuditzd', 'ServiceCenterController@searchCanAuditzd');//获取可审核处理数据
            Route::post('searPrice', 'ServiceCenterController@searPrice');//获取金额详情
            Route::post('editPrice', 'ServiceCenterController@editPrice');//编辑金额详情
            Route::post('invoice', 'ServiceCenterController@invoice');              //查看 或 修改 凭证
            Route::post('collecTickets', 'ServiceCenterController@collecTickets');  //已收票
            Route::post('searchRemaining', 'ServiceCenterController@searchRemaining');  //查询发票余额
            Route::post('search', 'ServiceCenterController@search');  //查询发票余额

            Route::post('InvoiceInfo', 'ServiceCenterController@InvoiceInfo');//发票信息导出 2022-3-15

        });

        #财务系统 >> 第三方结算单
        Route::group(['prefix'=>'SettlementThree','middleware'=>'requestpc'], function (){
            Route::post('index', 'SettlementThreeController@index');                  //列表
            Route::post('examine', 'SettlementThreeController@examine');//审核
            Route::post('editEntry', 'SettlementThreeController@editEntry');//编辑
            Route::post('queryPt', 'SettlementThreeController@queryPt'); //更新数据前获取id
            Route::post('AjaxSQL', 'SettlementThreeController@AjaxSQL'); //更新数据-
            Route::post('search', 'SettlementThreeController@search'); //搜索可结算订单
            Route::post('applicationSub', 'SettlementThreeController@applicationSub'); //申请结算-
        });

        #财务系统 >> 第三方账目管理
        Route::group(['prefix'=>'ptthree','middleware'=>'requestpc'], function (){
            Route::post('index', 'PtThreeController@index');                   //列表
            Route::post('editVoucher', 'PtThreeController@editVoucher');       //查看凭证 或 修改凭证
            Route::post('confirmPayment', 'PtThreeController@confirmPayment'); //确认收款
            Route::post('returnSettle', 'PtThreeController@returnSettle');     //退回结算
            Route::post('lookDetail', 'PtThreeController@lookDetail');     //查看详情；
        });



    #财务系统 >> 申请退/收列表du
    Route::group(['prefix'=>'submitplease','middleware'=>'requestpc'], function (){

        Route::post('index', 'SubmitPleaseController@index');              //列表
        Route::post('addReject', 'SubmitPleaseController@addReject');      //驳回
        Route::post('confirmApply','SubmitPleaseController@confirmApply'); //确认申请
        Route::post('addVoucher','SubmitPleaseController@addVoucher');     //添加凭证
        Route::post('editVoucher','SubmitPleaseController@editVoucher');   //修改凭证
        Route::post('lookVoucher','SubmitPleaseController@lookVoucher');   //查看凭证
        Route::post('editRemark','SubmitPleaseController@editRemark');   //
        Route::post('editBank','SubmitPleaseController@editBank');   //修改账户信息
        Route::post('lookRemark','SubmitPleaseController@lookRemark');   //查看备注
        Route::post('feedbackLog', 'SubmitPleaseController@feedbackLog');   //反馈日志

        Route::post('batchProcessStatus', 'SubmitPleaseController@batchProcessStatus');   //批量处理状态
        Route::post('processStatus', 'SubmitPleaseController@processStatus');   //单条处理状态
        Route::post('rejectStatus', 'SubmitPleaseController@rejectStatus');   //单条驳回状态
        Route::post('getSubmitStaues', 'SubmitPleaseController@getSubmitStaues');   //获取处理状态
        Route::post('getSubmitState', 'SubmitPleaseController@getSubmitState');//获取差额处理类型

        Route::post('editPayType', 'SubmitPleaseController@editPayType');//垫付
        Route::post('applyWaitPay', 'SubmitPleaseController@applyWaitPay');//账务申请待支付
        Route::post('getPayType', 'SubmitPleaseController@getPayType');//获取付款类型

        Route::post('editSubmitMoney', 'SubmitPleaseController@editSubmitMoney');//编辑申请金额
        Route::post('appSubmit', 'SubmitPleaseController@appSubmit');//提交申请
        Route::post('rejSubmit', 'SubmitPleaseController@rejSubmit');//驳回申请
        Route::post('rejPayment', 'SubmitPleaseController@rejPayment');//驳回付款

    });


    }
);
Route::group(
    ['namespace' => 'Api'],function(){
    #平台服务 >> 京东服务单
    Route::group(['prefix'=>'AddServiceOrder'], function (){
        Route::post('add_order', 'AddServiceOrderController@add_order');//添加服务单
    });
    #平台服务 >> 京东服务单
    Route::group(['prefix'=>'ZhiPeiOrder'], function (){
        Route::post('add_order', 'ZhiPeiOrderController@add_order');//添加服务单
    });
    #计算车膜评分 >> 计算车膜评分
    Route::group(['prefix'=>'CountScore'], function (){
        Route::post('service_pointsmonth', 'CountScoreController@service_pointsmonth');//添加服务单
    });
    #平台服务 >> 京东订单
    Route::group(['prefix'=>'AddJdData'], function (){
        Route::post('addRefundData', 'AddJdDataController@addRefundData');//添加京东退款
    });

    #平台服务 >> 京东POP订单
    Route::group(['prefix'=>'synJdPopData'], function (){
        Route::get('addOrderData', 'SynJdPopDataController@addOrderData');//添加京东
        Route::get('decOrder', 'SynJdPopDataController@decOrder');//定时解密
    });
    #平台服务 >> 京东自营订单
    Route::group(['prefix'=>'SynJdSelfData'], function (){
        Route::get('addOrderData', 'SynJdSelfDataController@addOrderData');//添加京东
        Route::get('decOrder', 'SynJdSelfDataController@decOrder');//定时解密
        Route::get('getSelfRefund', 'SynJdSelfDataController@getSelfRefund');//定时解密
    });
    #平台服务 >> 京东自营订单
    Route::group(['prefix'=>'SynJdSelfDataNew'], function (){
        Route::get('addOrderData', 'SynJdSelfDataNewController@addOrderData');//添加京东
        Route::get('decOrder', 'SynJdSelfDataNewController@decOrder');//定时解密
        Route::get('getSelfRefund', 'SynJdSelfDataNewController@getSelfRefund');//定时解密
    });
    #系统任务 >> 自动拒单
    Route::group(['prefix'=>'SynOrderRejected'], function (){
        Route::get('rejectedOrder', 'SynOrderRejectedController@rejectedOrder');//自动拒单
    });
    #系统任务 >> 电话通知
    Route::group(['prefix'=>'SingLeCallByTts'], function (){
        Route::get('getSingleCallByTts', 'SingLeCallByTtsController@getSingleCallByTts');//电话通知
    });
    #系统任务 >> 电话通知
    Route::group(['prefix'=>'getCallByTtsCost'], function (){
        Route::get('getCallByTtsCost', 'SysCallByTtsCostController@getCallByTtsCost');//电弧通知扣费
    });
    //京东定单同步状态
    Route::group(['prefix'=>'jdOrderApi'], function (){
        Route::get('getOrderByJd', 'JdOrderApiController@getOrderByJd');//获取京东社会化门店订单
        Route::get('getOrderCancelAuditList', 'JdOrderApiController@getOrderCancelAuditList');//获取社会化门店获取退款单
        Route::get('getOrderCancelByJd', 'JdOrderApiController@getOrderCancelByJd');//获取社会化门店获取退款单
    });
    #天猫服务单
/*    Route::group(['prefix'=>'tmOrder'], function (){
        Route::post('addOrderByTm', 'AddTmOrderController@addOrderByTm');//添加天猫单
        Route::post('CancelOrder', 'AddTmOrderController@CancelOrder');//天猫取消
    });*/

}
);

//F6门店 dong
Route::group(['namespace' => 'F6Store'],function(){
    #F6门店 >> 门店管理
    Route::group(['prefix'=>'f6Store','middleware'=>'requestpc'], function (){
        Route::post('index', 'F6StoreController@index'); //列表
        Route::post('editEntry', 'F6StoreController@editEntry'); //编辑
        Route::post('importExcel', 'F6StoreController@importExcel'); //导入
    });
    #F6门店 >> 门店属性
    Route::group(['prefix'=>'f6StoreAttr','middleware'=>'requestpc'], function (){
        Route::post('index', 'F6StoreAttrController@index'); //列表
        Route::post('addEntry', 'F6StoreAttrController@addEntry'); //添加
        Route::post('editEntry', 'F6StoreAttrController@editEntry'); //编辑
        Route::post('stateOn', 'F6StoreAttrController@attrState'); //启用
        Route::post('stateOff', 'F6StoreAttrController@attrState'); //停用
        Route::post('delEntry', 'F6StoreAttrController@delEntry'); //删除
    });
    #F6门店 >> 门店订单
    Route::group(['prefix'=>'f6StoreOrder','middleware'=>'requestpc'], function (){
        Route::post('index', 'F6StoreOrderController@index'); //列表
        Route::post('importExcel', 'F6StoreOrderController@importExcel'); //导入
        Route::post('syncOrder', 'F6StoreOrderController@syncOrder'); //同步
        Route::post('resultOrder', 'F6StoreOrderController@resultOrder'); //已解决
    });
});

//F6索赔 dong
Route::group(['namespace' => 'F6Claim'],function(){
    #F6索赔 >> 索赔管理
    Route::group(['prefix'=>'F6Claim','middleware'=>'requestpc'], function (){
        Route::post('index', 'F6ClaimController@index'); //列表
        Route::post('doInvoice', 'F6ClaimController@doInvoice'); //开票
        Route::post('doCollection', 'F6ClaimController@doCollection'); //付款
        Route::post('doCancel', 'F6ClaimController@doCancel'); //撤销
        Route::post('fastAddF6Claim', 'F6ClaimController@fastAddF6Claim'); //便捷索赔
        Route::post('getF6ClaimImage', 'F6ClaimController@getF6ClaimImage'); //查看凭证
        Route::post('getSysNumByOrderNum', 'F6ClaimController@getSysNumByOrderNum');//异步获取系统单号 du 2022-4-12
    });
});
//任务单管理 dong
Route::group(['namespace' => 'OrdersTask'],function(){
    #任务单管理
    Route::group(['prefix'=>'OrdersTask','middleware'=>'requestpc'], function (){
        Route::post('index', 'OrdersTaskController@index'); //列表
        Route::post('importExcel', 'OrdersTaskController@importExcel'); //导入
        Route::post('addEntry', 'OrdersTaskController@addEntry'); //添加
        Route::post('syncOrdersTask', 'OrdersTaskController@syncOrdersTask'); //同步
        Route::post('solveOrdersTask', 'OrdersTaskController@solveOrdersTask'); //已解决
    });
});
//app接口
Route::group(['prefix' => 'RequestApp', 'namespace' => 'AppApi', 'middleware' => 'RequestApp'], function () {//app接口
    Route::post('Json_login', 'InterfaceandroidController@Json_login');
    Route::get('Ceshi',function(){
        return view('ceshi');
    });
    Route::post('curl_basepic', 'InterfaceandroidController@curl_basepic');
//白皮书签署路由
    Route::post('Json_paper', 'InterfaceandroidController@json_paper');
//获取签署内容
    Route::post('Json_papercontent', 'InterfaceandroidController@Json_papercontent');
//修改密码路由
    Route::post('Json_editpass', 'InterfaceandroidController@Json_editpass');
//忘记密码修改密码
    Route::post('Editpass', 'InterfaceandroidController@editpass');
//服务中心信息
    Route::post('Json_admin_show', 'InterfaceandroidController@json_admin_show');
//服务中心修改
    Route::post('Json_admin_edit', 'InterfaceandroidController@json_admin_edit');
//添加安装人
    Route::post('Json_add_install', 'InterfaceandroidController@Json_add_install');
//添加备注
    Route::post('Json_add_message', 'InterfaceandroidController@Json_add_message');
//新闻公告
    Route::post('Json_manageapp', 'InterfaceandroidController@Json_manageapp');
//订单操作（获取安装人员）
    Route::post('Json_personnel', 'InterfaceandroidController@Json_personnel');
//获取当前服务中心下-安装人员列表
    Route::post('Json_install_person','InterfaceandroidController@json_install_person');
//启用、停用，修改，删除安装人员
    Route::post('Json_install_oper', 'InterfaceandroidController@json_install_oper');
//安装人员详情
    Route::post('Json_install_detail', 'InterfaceandroidController@json_install_detail');

//首页订单显示数目
    Route::post('Json_index_num', 'InterfaceandroidController@json_index_num');
//金额明细
    Route::post('json_money_detail', 'InterfaceandroidController@json_money_detail');
//已出账单
    Route::post('Json_order_ybill', 'InterfaceandroidController@json_order_ybill');
//未出账单
    Route::post('Json_order_wbill', 'InterfaceandroidController@Json_order_wbill');

//已出账单详情
    Route::post('Json_ybill_detail', 'InterfaceandroidController@Json_ybill_detail');
//订单列表
    Route::post('Json_order_list', 'InterfaceandroidController@json_order_list');
//订单详情
    Route::post('Json_order_details', 'InterfaceandroidController@json_order_details');
//催单列表
    Route::post('Json_ser_infor', 'InterfaceandroidController@json_ser_infor');
//催单反馈
    Route::post('Json_urge_feedback', 'InterfaceandroidController@json_urge_feedback');
//变更催单查看状态
    Route::post('Json_isread', 'InterfaceandroidController@json_isread');
//营业时间获取
    Route::post('Json_bustime', 'InterfaceandroidController@json_bustime');
    Route::post('Json_mpleInfo', 'InterfaceandroidController@json_mpleinfo');
//服务中心设置的时间
    Route::post('Json_acceptime', 'InterfaceandroidController@json_acceptime');
//绑定别名
    Route::post('Json_setBind', 'InterfaceandroidController@Json_setBind');
//转单操作
    Route::post('Json_transferr_Oper', 'InterfaceandroidController@Json_transferr_Oper');
//预约安装
    Route::post('Json_orderdelay', 'InterfaceandroidController@Json_orderdelay');
//在线状态
    Route::post('Json_installstate', 'InterfaceandroidController@Json_installstate');
//评分列表
    Route::post('Json_score_list', 'InterfaceandroidController@Json_score_list');
//评分详情
    Route::post('Json_score_detail', 'InterfaceandroidController@Json_score_detail');


//覆盖区域
//获取省
    Route::post('Json_search_sheng', 'InterfaceandroidController@Json_search_sheng');
//获取市
    Route::post('Json_search_shi', 'InterfaceandroidController@Json_search_shi');
//获取县
    Route::post('Json_search_xian', 'InterfaceandroidController@Json_search_xian');
//获取地区
    Route::post('Json_search_zhen', 'InterfaceandroidController@Json_search_zhen');
//添加地区
    Route::post('Json_add_area', 'InterfaceandroidController@Json_add_area');
//删除地区
    Route::post('Json_delet_area', 'InterfaceandroidController@Json_delet_area');
//显示覆盖区域
    Route::post('Json_show_area', 'InterfaceandroidController@Json_show_area');

//售后列表
    Route::post('After_list', 'InterfaceandroidController@After_list');

    Route::post('Json_after_deal', 'InterfaceandroidController@Json_after_deal');//售后首次处理

    Route::post('Json_after_lable', 'InterfaceandroidController@Json_after_lable');//获取售后标签

    Route::post('Json_afterdeal_lable', 'InterfaceandroidController@Json_afterdeal_lable');//获取售后处理标签

//查看上传的图片和音频
    Route::post('LookPicOrAudio', 'InterfaceandroidController@LookPicOrAudio');
//发送验证码
    Route::post('Json_verification_code', 'InterfaceandroidController@Json_verification_code');
//意见反馈
    Route::post('Json_opinion_feedback', 'InterfaceandroidController@Json_opinion_feedback');
//技师订单
    Route::post('Linelist', 'InterfaceandroidController@Linelist');
//技师订单详情
    Route::post('Lineinfo', 'InterfaceandroidController@Lineinfo');
//终止或恢复订单
    Route::post('Exitorder', 'InterfaceandroidController@Exitorder');
//技师个人中心
    Route::post('Install_personal', 'InterfaceandroidController@Install_personal');
//技师个人中心修改
    Route::post('install_EditInfo', 'InterfaceandroidController@install_EditInfo')->name('install_EditInfo');
//上传音频
    Route::post('Uploadaudio', 'InterfaceandroidController@Uploadaudio')->name('uploadaudio');
//售后反馈
    Route::post('Json_feedsales', 'InterfaceandroidController@Json_feedsales');
//售后展示
    Route::post('Json_SalesShow', 'InterfaceandroidController@Json_SalesShow');
//获取备注
    Route::post('Json_Gain_Message', 'InterfaceandroidController@Json_Gain_Message');
//接单，拒单
    Route::post('Json_order_oper', 'InterfaceandroidController@Json_order_oper');
//催单反馈
    Route::post('Json_dress_feedback', 'InterfaceandroidController@Json_dress_feedback');
//添加电瓶型号接口
    Route::post('Json_add_version', 'InterfaceandroidController@Json_add_version');
//商品型号选择
    Route::post('Json_good_version', 'InterfaceandroidController@Json_good_version');

//服务中心确认账单金额
    Route::post('Json_business_review', 'InterfaceandroidController@Json_business_review');
//拒单标签获取
    Route::post('Json_refusal_order', 'InterfaceandroidController@Json_refusal_order');
//订单详情 订单记录add_install
    Route::post('Json_order_record', 'InterfaceandroidController@Json_order_record');
//催单标签获取
    Route::post('Json_urge_acquiring', 'InterfaceandroidController@Json_urge_acquiring');
//售后转单
    Route::post('Json_transferr_after', 'InterfaceandroidController@Json_transferr_after');
//技师订单列表催单
    Route::post('Linelist_two', 'InterfaceandroidController@Linelist_two');
//技师订单列表已完成
    Route::post('Linelist_three', 'InterfaceandroidController@Linelist_three');
//技师订单列表（售后）
    Route::post('Linelist_four', 'InterfaceandroidController@Linelist_four');
//获取地址反馈标签
    Route::post('Json_dress_acquiring', 'InterfaceandroidController@Json_dress_acquiring');

    Route::post('install_upload', 'InterfaceandroidController@install_upload')->name('install_upload');
//关闭最新推送消息
    Route::post('Json_push_hide', 'InterfaceandroidController@Json_push_hide');

    Route::post('linerecord', 'InterfaceandroidController@linerecord');
//获取经纬度
    Route::post('jingwei', 'InterfaceandroidController@jingwei');
//展示换货商品
    Route::post('feeedGoods', 'InterfaceandroidController@feeedGoods');
//换商品动作
    Route::post('exchangeGoods', 'InterfaceandroidController@exchangeGoods');
//获取车牌号
    Route::post('pictoplace', 'InterfaceandroidController@pictoplace');
    Route::post('jone', 'InterfaceandroidController@jone');
    Route::post('addjy_order', 'SdapiController@addjy_order');

//核销码
    Route::post('Json_appoint', 'InterfaceandroidController@Json_appoint'); //检验预约码
    Route::post('Json_jy_appoint', 'InterfaceandroidController@Json_jy_appoint');//校验预约码
    Route::post('maptrail', 'InterfaceandroidController@maptrail');//地图轨迹

    Route::post('Json_get_brands', 'InterfaceandroidController@Json_get_brands');//获取品牌


    Route::post('Json_refund_list', 'InterfaceandroidController@Json_refund_list');//退款管理
    Route::post('Json_refund_getlabel', 'InterfaceandroidController@Json_refund_getlabel');//获取标签
    Route::post('Json_refund_pass', 'InterfaceandroidController@Json_refund_pass');//退款通过处理
    Route::post('Json_refund_reject', 'InterfaceandroidController@Json_refund_reject');//退款驳回
    Route::post('Json_refund_detail', 'InterfaceandroidController@Json_refund_detail');//退款详情



    Route::post('Json_ticket_list', 'InterfaceandroidController@Json_ticket_list');//罚单列表
    Route::post('Json_ticket_detail', 'InterfaceandroidController@Json_ticket_detail');//罚单详情
    //罚单申诉
    Route::post('Json_ticket_appeal', 'InterfaceandroidController@Json_ticket_appeal');

    Route::post('Json_ticket_confirm', 'InterfaceandroidController@Json_ticket_confirm');//罚单确认

    //获取罚单备注
    //Route::post('Json_ticket_note', 'InterfaceandroidController@Json_ticket_note');
    //处罚单详情
    //Route::post('Json_punish', 'InterfaceandroidController@Json_punish');


    Route::post('EvaluationFormList', 'InterfaceandroidController@EvaluationFormList');//客户评价列表
    Route::post('EvaluationFormDetail', 'InterfaceandroidController@EvaluationFormDetail');//客户评价详单
    Route::post('EvaluationFormDeal', 'InterfaceandroidController@EvaluationFormDeal');//客户评价处理
    Route::post('EvaluationFormGetLab', 'InterfaceandroidController@EvaluationFormGetLab');//获取申诉标签
    Route::post('EvaluationFormAppeal', 'InterfaceandroidController@EvaluationFormAppeal');//评价申诉
});
Route::group(['prefix' => 'Dou', 'namespace' => 'Dou'], function () {
    Route::any('MyTest/test', 'MyTestController@test'); //测试入口
    Route::any('MyTest/dataApi', 'MyTestController@dataApi'); //测试入口
    Route::any('MyTest/getJdToken', 'MyTestController@getJdToken'); //测试入口
});
// 移动端网页功能
Route::namespace('Api')->group(function () {
    // 技师登录
    Route::post('w1/login', 'MobileWeb\LoginController@login'); //登录
    Route::post('w1/getOpenid', 'MobileWeb\LoginController@getOpenid'); //登录
    // 需要验证
    Route::group(['middleware' => ['WebLogin']], function () {
        Route::post('w1/quit', 'MobileWeb\LoginController@quit'); //退出
        Route::post('w1/updatePassword', 'MobileWeb\LoginController@updatePassword'); //修改密码

        Route::post('w1/OrderList/index', 'MobileWeb\OrderListController@index'); //服务工单列表
        Route::post('w1/OrderList/receiving', 'MobileWeb\OrderListController@receiving'); //接单
        Route::post('w1/OrderList/refuse', 'MobileWeb\OrderListController@refuse'); //拒单
        Route::post('w1/OrderList/transferOfOrder', 'MobileWeb\OrderListController@transferOfOrder'); //改派
        Route::post('w1/OrderList/contact', 'MobileWeb\OrderListController@contact'); //预约
        Route::post('w1/OrderList/lineStart', 'MobileWeb\OrderListController@lineStart'); //出发
        Route::post('w1/OrderList/lineArrive', 'MobileWeb\OrderListController@lineArrive'); //抵达
        Route::post('w1/OrderList/startInstall', 'MobileWeb\OrderListController@startInstall'); //开始安装
        Route::post('w1/OrderList/addPic', 'MobileWeb\OrderListController@addPic'); //上传图片
        Route::post('w1/OrderList/deletPic', 'MobileWeb\OrderListController@deletPic'); //删除图片
        Route::post('w1/OrderList/installFeedback', 'MobileWeb\OrderListController@installFeedback'); //安装反馈
        Route::post('w1/OrderList/inspect', 'MobileWeb\OrderListController@inspect'); //检验
        Route::post('w1/OrderList/info', 'MobileWeb\OrderListController@info'); //详情
        Route::post('w1/OrderList/getInstallPerson', 'MobileWeb\OrderListController@getInstallPerson'); //获取技师
        Route::post('w1/OrderList/getLabel', 'MobileWeb\OrderListController@getLabel'); //获取标签
        Route::post('w1/OrderList/operatingRecord', 'MobileWeb\OrderListController@operatingRecord'); //获取操作记录
        Route::post('w1/OrderList/getFeedback', 'MobileWeb\OrderListController@getFeedback'); //获取安装反馈数据
        Route::post('w1/OrderList/getService', 'MobileWeb\OrderListController@getService'); //获取系统推荐服务商
        Route::post('w1/OrderList/sendAgain', 'MobileWeb\OrderListController@sendAgain'); //指派门店

        Route::post('w1/OrderList/imageFeedback', 'MobileWeb\OrderListController@imageFeedback'); //施工反馈，图片反馈
        Route::post('w1/OrderList/LicenseFeedback', 'MobileWeb\OrderListController@LicenseFeedback'); //施工反馈，车牌反馈


        // 技师管理
        Route::post('w1/Technician/index', 'MobileWeb\TechnicianController@index'); //技师列表
        Route::post('w1/Technician/add', 'MobileWeb\TechnicianController@add'); //技师列表-新增
        Route::post('w1/Technician/changePassword', 'MobileWeb\TechnicianController@changePassword'); //技师列表-修改密码
        Route::post('w1/Technician/delete', 'MobileWeb\TechnicianController@delete'); //删除
        Route::post('w1/Technician/edit', 'MobileWeb\TechnicianController@edit'); //编辑
        Route::post('w1/Technician/addHeadPic', 'MobileWeb\TechnicianController@addHeadPic'); //添加头像图片

        // 账单模块
        Route::post('w1/BillingModule/index', 'MobileWeb\BillingModuleController@index'); //列表
        Route::post('w1/BillingModule/checkVoucher', 'MobileWeb\BillingModuleController@checkVoucher'); //查看凭证
        Route::post('w1/BillingModule/checkInfo', 'MobileWeb\BillingModuleController@checkInfo'); //查看详情
        Route::post('w1/BillingModule/affirmBill', 'MobileWeb\BillingModuleController@affirmBill'); //确认账单
        Route::post('w1/BillingModule/uploadInvoice', 'MobileWeb\BillingModuleController@uploadInvoice'); //上传发票
        // 服务评价
        Route::post('w1/ServiceEvaluation/index', 'MobileWeb\ServiceEvaluationController@index'); //列表

        // 售后列表
        Route::post('w1/after/index', 'MobileWeb\AftersaleOrderController@index'); //列表
        Route::post('w1/after/handle_ive', 'MobileWeb\AftersaleOrderController@handle_ive'); //立即处理
        Route::post('w1/after/dailyFeedback', 'MobileWeb\AftersaleOrderController@dailyFeedback'); //日常反馈
        Route::post('w1/after/info', 'MobileWeb\AftersaleOrderController@info'); //详情
        Route::post('w1/after/addAfterSalePic', 'MobileWeb\AftersaleOrderController@addAfterSalePic'); //上传售后图片
        Route::post('w1/after/upload', 'MobileWeb\AftersaleOrderController@upload'); //上传售后图片
        Route::post('w1/after/deletPic', 'MobileWeb\AftersaleOrderController@deletPic'); //删除图片
        Route::post('w1/after/quality', 'MobileWeb\AftersaleOrderController@quality'); //申请完成

        // 账单列表
        Route::post('w1/statement/index','MobileWeb\StatementsListController@index');//列表页
        Route::post('w1/statement/info','MobileWeb\StatementsListController@info');//列表页
        Route::post('w1/statement/businessFirm','MobileWeb\StatementsListController@businessFirm');//商家确认
    });
});
