<?php
/**
 * 类别服务
 * @author du 2021年7月23日上午9:40:36
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use App\Models\CategoryDetail;
//use Illuminate\Support\Facades\Cache;
//use Illuminate\Support\Facades\Redis;
use App\Services\RedisService;
class CategoryService extends Service{

	/**
	 * 品类数据
	 * @return array|boolean
	 * @author du 2021年7月23日上午9:40:39
	 */
     public static function getall($ids = [],$key = '' , $search = true)
    {
    	$data = [];
    	if(!is_array($ids)){
    		return $data;
    	}
    	$list = RedisService::redisGet('cdList');
    	if ($list && $search) {
    		$data = CommonService::filterIds($ids,$list,'cd_id');
    	} else {
    		$brandData = CategoryDetail::where('cd_del_flag',1)->select('cd_id','cd_cn_id','cd_pname','cd_nextlevel','sm_ids')->orderBy('cd_id','DESC')->get()->toarray();
    		$data = CommonService::filterIds($ids,$brandData,'cd_id');
    		RedisService::redisSet('cdList', json_encode($brandData));
    	}
    	if($key){
    		$data = CommonService::jointArrayKey($data,$key);
    	}
    	return $data;



    	/* $data = [];
    	$cacheExist = RedisService::redisGet('cdList');
    	if($cacheExist){
    		echo 1;
     		$list = $cacheExist;
     		$data = array_column($list,'cd_pname','cd_id');

     	}else{
     		echo 2;
     		$list = CategoryDetail::where('cd_del_flag',1)->select('cd_id','cd_cn_id','cd_pname')->orderBy('cd_id','DESC')->get()->toarray();
     		$data = array_column($list,'cd_pname','cd_id');
     		RedisService::redisSet('cdList', $list);
     	}

     	return $data; */
    }

    /**
     * 根据ID获取品类名
     * @param $cd_id
     * @return mixed
     * @author du
     * @date 2021/10/14
     */
    public static function getNameByCdId($cd_id){
         $name = CategoryDetail::where('cd_del_flag',1)->where('cd_id',$cd_id)->value('cd_pname');
         return $name;
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加品类
     * @param array $parameter 品类信息
     * @param array $session 操作人信息
     * @param string $ip 操作人信息
     * @retrun /multitype:array
     * @author dou 2022/2/25 14:26
     * |---------------------------------------------------------------------------------
    */
    public static function addCategoryDetali ( $parameter , $session , $ip ){
        $checkKey = CommonService::checkKey(['cn_id','cd_pname'],$parameter);
        if($checkKey['code']!=1){
            return ['Data' => [], 'ErrorMessage' => '参数'.$checkKey['data'].'未填写,或值为空', 'ErrorCode' => ErrorInc::INVALID_PARAM];
        }

        $cd_pname = trim($parameter['cd_pname']);

        $exists = CategoryDetail::where('cd_pname',$cd_pname)->value('cd_id');

        if($exists){
            return ['Data' => [], 'ErrorMessage' => '已存在请重新填写', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
        }
        if($parameter['cd_remark']){
            $dataArr['cd_remark'] = $parameter['cd_remark'];
        }

        $dataArr['cd_cn_id'] = $parameter['cn_id'];
        $dataArr['cd_pname'] = $cd_pname;
        $dataArr['cd_admin_id'] = $session['id'];
        $dataArr['cd_creat_time'] = date("Y-m-d H:i:s");
        $dataArr['cd_nextlevel'] = $parameter['cd_nextlevel']??2;//是否可添加下级1是2否
        if(is_array($parameter['sm_ids'])){
            $dataArr['sm_ids'] = implode(',', $parameter['sm_ids']);
        }else{
            $dataArr['sm_ids'] = $parameter['sm_ids'];
        }


        $res = CategoryDetail::insert($dataArr);
        if($res){
            //更新redis内容
//     		$cdLists = $this->cdList();
//     		$cdList = json_encode($cdLists);
//     		RedisService::redisSet('cdList',$cdList);
            CategoryService::getall([],'',false);
            $BaseController = new BaseController();
            $BaseController->insertingLog('添加品类，','',$cd_pname,'品类管理',$ip,$session['admin_acc']);
            return ['Data' => [], 'ErrorMessage' => '添加成功', 'ErrorCode' => 1];
        }else{
            return ['Data' => [], 'ErrorMessage' => '添加失败', 'ErrorCode' => ErrorInc::MYSQL_FAILED];
        }
    }


}
