<?php

namespace App\Http\Controllers\ExcelInfo;
use App\Http\Controllers\BaseController;
use App\Exceptions\ApiException;
use App\Models\Admin;
use App\Services\CommonService;
use App\Services\ExcelpermissService;
use Illuminate\Http\Request;
use App\Models\ExcelPermiss;
use App\ExcelTemp\ExcelTemp;
use BlueCity\Core\Inc\ErrorInc;
use DB;

class ExcelpermissController extends BaseController
{
	use ExcelTemp;

    /**
     * @name  列表页
     * @param action_name  控制器名
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $session = $request->get('session_token');
        if (!in_array($session['admin_groupnew'],[7,8,9])) {//管理员可以看全部
            return $this->error('无操作权限', ErrorInc::REQUEST_FORBIDDEN);exit;
        }
        $list = ExcelpermissService::getList($input,$session);
        if($list['list']){
            return $this->success('获取成功', $list); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
        }
    }

    /**
     * @name  添加
     * @param admin_id
     * @param action_name
     * @param action_value
     * @param adg_data
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelAdd (Request $request)
    {
        if ($request->filled(['action_name','action_value','adg_data'])) {
            $input = $request->only('action_name','action_value','adg_data','admin_id');
            $exist = ExcelPermiss::where('adg_admin',$input['admin_id'])->where('adg_action',$input['action_value'])->value('adg_id');
            if (!empty($exist)) {
                return $this->error('该权限已添加,请勿重复添加', ErrorInc::MYSQL_FAILED);exit;
            }
            $company_id = Admin::where('id',$input['admin_id'])->value("company_id");
            $res = ExcelPermiss::insert([
                'adg_admin' => $input['admin_id'],
                'adg_action' => $input['action_value'],
                'adg_acname' => $input['action_name'],
                'adg_data'   => json_encode($input['adg_data'],JSON_UNESCAPED_UNICODE,2),
                'adg_type'   => 1,
                'company_id' => $company_id,
            ]);
            if ($res) {
            	$this->insertingLog("导出权限，",$input['action_value'],"导出权限添加".$input['action_name'],"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('添加成功');exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelEdit (Request $request)
    {
        if ($request->filled('adg_id')) {
            $adg_id = intval($request->input('adg_id'));
            $input = $request->only('action_name','action_value','adg_data','admin_id');
            $exist = ExcelPermiss::where('adg_admin',$input['admin_id'])->where('adg_action',$input['action_value'])->where('adg_id','!=',$adg_id)->where('adg_type',1)->value('adg_id');
            if (!empty($exist)) {
                return $this->error('该权限已添加,请勿重复添加', ErrorInc::MYSQL_FAILED);exit;
            }
            $res = ExcelPermiss::where('adg_id',$adg_id)->update([
                'adg_admin' => $input['admin_id'],
                'adg_action' => $input['action_value'],
                'adg_acname' => $input['action_name'],
                'adg_data'   => json_encode($input['adg_data'], JSON_UNESCAPED_UNICODE),
                'adg_type'   => 1,
            ]);
            if ($res) {
                $this->insertingLog("导出权限，",$input['action_value'],"导出权限编辑".$input['action_name'],"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('编辑成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }


    /**
     * @name  删除
     * @param adg_id  数据id
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelDel (Request $request)
    {
        if ($request->filled('adg_id')) {
            $res = ExcelPermiss::where('adg_id',$request->input('adg_id'))->delete();
            if ($res) {
            	$this->insertingLog("导出权限，",$request->input('adg_id'),"导出权限删除ID".$request->input('adg_id'),"导出权限",$request->ip(), $request->get('session_token')['admin_acc']);//日志
                return $this->success('删除成功');exit;
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        } else {
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }

    /**
     * @name  获取 控制器名称
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelActions (Request $request)
    {
        $session = $request->get('session_token');
        $list = $this->getActions();
        if (!in_array($session['admin_groupnew'],[7])) {//管理员可以看全部
            $adg_action = DB::table('admin_excel')->where('adg_admin',$session['id'])->pluck('adg_action');
            $adg_action = CommonService::dataToArray($adg_action);
            if($adg_action) {
                $list = CommonService::arrayFilterFieldValue($list, [['action_value' => $adg_action]]);
            }else{
                $list = [];
            }
        }
        $data['list'] = $list;
        return $this->success('获取成功',$data);exit;
    }

    /**
     * @name  获取字段
     * @param action_value  控制器
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function excelFields (Request $request)
    {
        if ($request->filled('action_value')) {
            $session = $request->get('session_token');
            $action_value = $request->input('action_value');
            $list = $this->getField($action_value);
            if (!in_array($session['admin_groupnew'],[7])) {//管理员可以看全部
                $adg_action = DB::table('admin_excel')->where('adg_admin',$session['id'])->where('adg_action',$action_value)->value('adg_data');
                if($adg_action) {
                    $adg_action = json_decode($adg_action);
                    $field_value = array_column($adg_action, 'field_value');
                    $field_value = CommonService::dataToArray($field_value);
                    $list = CommonService::arrayFilterFieldValue($list, [['field_value' => $field_value]]);
                }else{
                    $list = [];
                }
            }
            $data['list'] = $list;
            return $this->success('获取成功',$data);exit;
        }
    }
}
